/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator;

import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellBoolean;
import ivorius.reccomplex.gui.table.TableCellIntegerRange;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.structures.generic.Selection;
import net.minecraft.util.EnumChatFormatting;

public class TableDataSourceSelectionArea
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private Selection.Area area;
    private int[] dimensions;

    public TableDataSourceSelectionArea(Selection.Area area, int[] dimensions) {
        this.area = area;
        this.dimensions = dimensions;
    }

    @Override
    public int numberOfSegments() {
        return 2;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 1 ? 3 : 1;
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellBoolean cell = new TableCellBoolean("additive", this.area.isAdditive(), EnumChatFormatting.GREEN + "Additive", EnumChatFormatting.GOLD + "Subtractive");
            cell.addPropertyListener(this);
            return new TableElementCell(cell);
        }
        if (segment == 1) {
            String title = String.format("Range: %s", index == 0 ? "X" : (index == 1 ? "Y" : (index == 2 ? "Z" : "" + index)));
            IntegerRange intRange = new IntegerRange(this.area.getMinCoord()[index], this.area.getMaxCoord()[index]);
            TableCellIntegerRange cell = new TableCellIntegerRange("area" + index, intRange, 0, this.dimensions[index] - 1);
            cell.addPropertyListener(this);
            return new TableElementCell(title, cell);
        }
        return null;
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            if (cell.getID().startsWith("area")) {
                int dim = Integer.valueOf(cell.getID().substring(4));
                IntegerRange range = (IntegerRange)cell.getPropertyValue();
                this.area.setCoord(dim, range.getMin(), range.getMax());
            } else if ("additive".equals(cell.getID())) {
                this.area.setAdditive((Boolean)cell.getPropertyValue());
            }
        }
    }
}

