/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator;

import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.reccomplex.gui.TableDataSourceBlockCoord;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCell;
import ivorius.reccomplex.gui.table.TableCellActionListener;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableCellInteger;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazePathConnectionList;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceSelection;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.rules.TableDataSourceMazeRuleList;
import ivorius.reccomplex.scripts.world.WorldScriptMazeGenerator;

public class TableDataSourceWorldScriptMazeGenerator
extends TableDataSourceSegmented
implements TableCellPropertyListener,
TableCellActionListener {
    public static final int[] DIMENSIONS = new int[]{100, 100, 100};
    private WorldScriptMazeGenerator script;
    private TableDelegate tableDelegate;
    private TableNavigator tableNavigator;

    public TableDataSourceWorldScriptMazeGenerator(WorldScriptMazeGenerator script, TableDelegate tableDelegate, TableNavigator tableNavigator) {
        this.script = script;
        this.tableDelegate = tableDelegate;
        this.tableNavigator = tableNavigator;
        this.addManagedSection(2, new TableDataSourceBlockCoord(script.getStructureShift(), script::setStructureShift, new IntegerRange(-50, 50), "Range: %s"));
    }

    public WorldScriptMazeGenerator getScript() {
        return this.script;
    }

    public void setScript(WorldScriptMazeGenerator script) {
        this.script = script;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getTableNavigator() {
        return this.tableNavigator;
    }

    public void setTableNavigator(TableNavigator tableNavigator) {
        this.tableNavigator = tableNavigator;
    }

    @Override
    public int numberOfSegments() {
        return 4;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 0: {
                return 1;
            }
            case 1: 
            case 3: {
                return 3;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellString cell = new TableCellString("mazeID", this.script.getMazeID());
            cell.addPropertyListener(this);
            return new TableElementCell("Maze ID", cell);
        }
        if (segment == 1) {
            if (index == 0) {
                TableCellButton cell = new TableCellButton("rooms", new TableCellButton.Action("edit", "Edit"));
                cell.addListener(this);
                return new TableElementCell("Rooms", cell);
            }
            if (index == 1) {
                TableCellButton cell = new TableCellButton("exits", new TableCellButton.Action("edit", "Edit"));
                cell.addListener(this);
                return new TableElementCell("Exits", cell);
            }
            if (index == 2) {
                TableCellButton cell = new TableCellButton("rules", new TableCellButton.Action("edit", "Edit"));
                cell.addListener(this);
                return new TableElementCell("Rules", cell);
            }
        } else if (segment == 3) {
            if (index == 0) {
                TableCellInteger cell = new TableCellInteger("roomSizeX", this.script.getRoomSize()[0], 1, 64);
                cell.addPropertyListener(this);
                return new TableElementCell("Room Size: X", cell);
            }
            if (index == 1) {
                TableCellInteger cell = new TableCellInteger("roomSizeY", this.script.getRoomSize()[1], 1, 64);
                cell.addPropertyListener(this);
                return new TableElementCell("Room Size: Y", cell);
            }
            if (index == 2) {
                TableCellInteger cell = new TableCellInteger("roomSizeZ", this.script.getRoomSize()[2], 1, 64);
                cell.addPropertyListener(this);
                return new TableElementCell("Room Size: Z", cell);
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("mazeID".equals(cell.getID())) {
            this.script.setMazeID((String)cell.getPropertyValue());
        } else if ("roomSizeX".equals(cell.getID())) {
            int[] size = this.script.getRoomSize();
            size[0] = (Integer)cell.getPropertyValue();
            this.script.setRoomSize(size);
        } else if ("roomSizeY".equals(cell.getID())) {
            int[] size = this.script.getRoomSize();
            size[1] = (Integer)cell.getPropertyValue();
            this.script.setRoomSize(size);
        } else if ("roomSizeZ".equals(cell.getID())) {
            int[] size = this.script.getRoomSize();
            size[2] = (Integer)cell.getPropertyValue();
            this.script.setRoomSize(size);
        }
    }

    @Override
    public void actionPerformed(TableCell tableElementButton, String actionID) {
        if ("exits".equals(tableElementButton.getID())) {
            this.tableNavigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazePathConnectionList(this.script.exitPaths, this.tableDelegate, this.tableNavigator, this.script.rooms.boundsLower(), this.script.rooms.boundsHigher())));
        } else if ("rooms".equals(tableElementButton.getID())) {
            this.tableNavigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceSelection(this.script.rooms, DIMENSIONS, this.tableDelegate, this.tableNavigator)));
        } else if ("rules".equals(tableElementButton.getID())) {
            this.tableNavigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazeRuleList(this.script.rules, this.tableDelegate, this.tableNavigator, this.script.exitPaths, this.script.rooms.boundsLower(), this.script.rooms.boundsHigher())));
        }
    }
}

