/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator.rules;

import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellBoolean;
import ivorius.reccomplex.gui.table.TableCellTitle;
import ivorius.reccomplex.gui.table.TableDataSourcePreloaded;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazePathList;
import ivorius.reccomplex.structures.generic.maze.rules.saved.MazeRuleConnect;
import ivorius.reccomplex.utils.IvTranslations;
import net.minecraft.util.EnumChatFormatting;

public class TableDataSourceMazeRuleConnect
extends TableDataSourceSegmented {
    private final MazeRuleConnect rule;

    public TableDataSourceMazeRuleConnect(MazeRuleConnect rule, TableDelegate tableDelegate, TableNavigator navigator, int[] boundsLower, int[] boundsHigher) {
        this.rule = rule;
        TableCellTitle startTitle = new TableCellTitle("", "Start");
        startTitle.setTooltip(IvTranslations.formatLines("reccomplex.mazerule.connect.start.tooltip", new Object[0]));
        this.addManagedSection(1, new TableDataSourcePreloaded(new TableElementCell(startTitle)));
        this.addManagedSection(2, new TableDataSourceMazePathList(rule.start, tableDelegate, navigator, boundsLower, boundsHigher));
        TableCellTitle endTitle = new TableCellTitle("", "End");
        endTitle.setTooltip(IvTranslations.formatLines("reccomplex.mazerule.connect.end.tooltip", new Object[0]));
        this.addManagedSection(3, new TableDataSourcePreloaded(new TableElementCell(endTitle)));
        this.addManagedSection(4, new TableDataSourceMazePathList(rule.end, tableDelegate, navigator, boundsLower, boundsHigher));
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 0 ? 1 : super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellBoolean preventCell = new TableCellBoolean("prevent", this.rule.preventConnection, EnumChatFormatting.GOLD + "Prevent Connection", EnumChatFormatting.GREEN + "Ensure Connection");
            preventCell.addPropertyListener(cell -> {
                this.rule.preventConnection = (Boolean)cell.getPropertyValue();
            });
            return new TableElementCell(preventCell);
        }
        return super.elementForIndexInSegment(table, index, segment);
    }
}

