/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator.rules;

import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellBoolean;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellTitle;
import ivorius.reccomplex.gui.table.TableDataSourcePreloaded;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazePathList;
import ivorius.reccomplex.structures.generic.maze.Connector;
import ivorius.reccomplex.structures.generic.maze.ConnectorFactory;
import ivorius.reccomplex.structures.generic.maze.SavedMazePath;
import ivorius.reccomplex.structures.generic.maze.SavedMazePathConnection;
import ivorius.reccomplex.structures.generic.maze.rules.saved.MazeRuleConnectAll;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.EnumChatFormatting;

public class TableDataSourceMazeRuleConnectAll
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private final MazeRuleConnectAll rule;
    private List<SavedMazePathConnection> expected;
    private TableDelegate tableDelegate;

    public TableDataSourceMazeRuleConnectAll(MazeRuleConnectAll rule, TableDelegate tableDelegate, TableNavigator navigator, List<SavedMazePathConnection> expected, int[] boundsLower, int[] boundsHigher) {
        this.rule = rule;
        this.expected = expected;
        this.tableDelegate = tableDelegate;
        this.addManagedSection(1, new TableDataSourcePreloaded(new TableElementCell(new TableCellTitle("", "Paths"))));
        this.addManagedSection(3, new TableDataSourceMazePathList(rule.exits, tableDelegate, navigator, boundsLower, boundsHigher));
    }

    @Override
    public int numberOfSegments() {
        return this.rule.additive ? 4 : 6;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 0: 
            case 2: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return this.expected.size() - this.rule.exits.size();
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellBoolean preventCell = new TableCellBoolean("prevent", this.rule.preventConnection, EnumChatFormatting.GOLD + "Prevent Connection", EnumChatFormatting.GREEN + "Ensure Connection");
            preventCell.addPropertyListener(cell -> {
                this.rule.preventConnection = (Boolean)cell.getPropertyValue();
            });
            return new TableElementCell(preventCell);
        }
        if (segment == 2) {
            TableCellBoolean cell2 = new TableCellBoolean("additive", this.rule.additive, EnumChatFormatting.GREEN + "Additive", EnumChatFormatting.GOLD + "Subtractive");
            cell2.addPropertyListener(this);
            return new TableElementCell(cell2);
        }
        if (segment == 4) {
            return new TableElementCell(new TableCellTitle("", "Preview"));
        }
        if (segment == 5) {
            ConnectorFactory factory = new ConnectorFactory();
            Set<Connector> blockedConnections = Collections.singleton(factory.get("Wall"));
            List exitPaths = MazeRuleConnectAll.getPaths(this.rule.exits, this.expected, blockedConnections, factory).collect(Collectors.toList());
            return new TableElementCell(new TableCellTitle("", ((SavedMazePath)exitPaths.get(index)).toString()));
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("additive".equals(cell.getID())) {
            this.rule.additive = (Boolean)cell.getPropertyValue();
            this.tableDelegate.reloadData();
        }
    }
}

