/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator.rules;

import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDataSourceList;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.generic.maze.SavedMazePathConnection;
import ivorius.reccomplex.structures.generic.maze.rules.MazeRule;
import ivorius.reccomplex.structures.generic.maze.rules.MazeRuleRegistry;
import ivorius.reccomplex.utils.IvClasses;
import ivorius.reccomplex.utils.IvTranslations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;

public class TableDataSourceMazeRuleList
extends TableDataSourceList<MazeRule, List<MazeRule>> {
    private List<SavedMazePathConnection> expected;
    private int[] boundsLower;
    private int[] boundsHigher;

    public TableDataSourceMazeRuleList(List<MazeRule> list, TableDelegate tableDelegate, TableNavigator navigator, List<SavedMazePathConnection> expected, int[] boundsLower, int[] boundsHigher) {
        super(list, tableDelegate, navigator);
        this.expected = expected;
        this.boundsLower = boundsLower;
        this.boundsHigher = boundsHigher;
        this.setUsesPresetActionForAdding(true);
    }

    @Override
    public String getDisplayString(MazeRule mazeRule) {
        return StringUtils.abbreviate((String)mazeRule.displayString(), (int)24);
    }

    @Override
    public MazeRule newEntry(String actionID) {
        return (MazeRule)IvClasses.instantiate(MazeRuleRegistry.INSTANCE.objectClass(actionID));
    }

    @Override
    public TableDataSource editEntryDataSource(MazeRule mazeRule) {
        return mazeRule.tableDataSource(this.navigator, this.tableDelegate, this.expected, this.boundsLower, this.boundsHigher);
    }

    @Override
    public TableCellButton.Action[] getAddActions() {
        Collection<String> allTypes = MazeRuleRegistry.INSTANCE.allIDs();
        ArrayList<TableCellButton.Action> actions = new ArrayList<TableCellButton.Action>(allTypes.size());
        for (String type : allTypes) {
            String baseKey = "reccomplex.mazerule." + type;
            actions.add(new TableCellButton.Action(type, StatCollector.func_74838_a((String)baseKey), IvTranslations.formatLines(baseKey + ".tooltip", new Object[0])));
        }
        return actions.toArray(new TableCellButton.Action[actions.size()]);
    }
}

