/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.operation;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public interface Operation {
    public void perform(World var1);

    public void writeToNBT(NBTTagCompound var1);

    public void readFromNBT(NBTTagCompound var1);

    public void renderPreview(PreviewType var1, World var2, int var3, float var4);

    public static enum PreviewType {
        NONE(0, "none"),
        BOUNDING_BOX(1, "bounds"),
        SHAPE(0, "shape");

        public final int id;
        public final String key;

        private PreviewType(int id, String key) {
            this.id = id;
            this.key = key;
        }

        public static String[] keys() {
            PreviewType[] values = PreviewType.values();
            String[] keys = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                keys[i] = values[i].key;
            }
            return keys;
        }

        public static PreviewType findOrDefault(String key, PreviewType defaultType) {
            PreviewType type = PreviewType.find(key);
            return type != null ? type : defaultType;
        }

        public static PreviewType find(String key) {
            for (PreviewType type : PreviewType.values()) {
                if (!type.key.equals(key)) continue;
                return type;
            }
            return null;
        }
    }
}

