/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.random;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.FileLoadContext;
import ivorius.reccomplex.files.FileTypeHandler;
import ivorius.reccomplex.random.Poem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;

public class PoemLoader
implements FileTypeHandler {
    public static final String FILE_SUFFIX = "rcpt";

    @Override
    public boolean loadFile(Path path, FileLoadContext context) {
        Poem.Theme theme = null;
        String name = context.customID != null ? context.customID : FilenameUtils.getBaseName((String)path.getFileName().toString());
        try {
            theme = Poem.Theme.fromFile(new String(Files.readAllBytes(path)));
        }
        catch (IOException e) {
            RecurrentComplex.logger.warn("Error reading poem theme", (Throwable)e);
        }
        if (theme != null) {
            Poem.registerTheme(name, theme, context.custom);
            return true;
        }
        return false;
    }

    @Override
    public void clearCustomFiles() {
        Poem.clearCustom();
    }
}

