/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.scripts.world;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.components.ConnectionStrategy;
import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazeComponentConnector;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePredicate;
import ivorius.ivtoolkit.maze.components.MazePredicateMany;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import ivorius.ivtoolkit.maze.components.SetMazeComponent;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.ivtoolkit.tools.Visitor;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceWorldScriptMazeGenerator;
import ivorius.reccomplex.scripts.world.WorldScript;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.Selection;
import ivorius.reccomplex.structures.generic.maze.Connector;
import ivorius.reccomplex.structures.generic.maze.ConnectorFactory;
import ivorius.reccomplex.structures.generic.maze.ConnectorStrategy;
import ivorius.reccomplex.structures.generic.maze.MazeComponentStructure;
import ivorius.reccomplex.structures.generic.maze.PlacedStructure;
import ivorius.reccomplex.structures.generic.maze.SavedMazePathConnection;
import ivorius.reccomplex.structures.generic.maze.SavedMazePaths;
import ivorius.reccomplex.structures.generic.maze.WorldGenMaze;
import ivorius.reccomplex.structures.generic.maze.rules.BlockedConnectorStrategy;
import ivorius.reccomplex.structures.generic.maze.rules.LimitAABBStrategy;
import ivorius.reccomplex.structures.generic.maze.rules.MazeRule;
import ivorius.reccomplex.structures.generic.maze.rules.MazeRuleRegistry;
import ivorius.reccomplex.utils.IntAreas;
import ivorius.reccomplex.utils.IvTranslations;
import ivorius.reccomplex.utils.NBTStorable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class WorldScriptMazeGenerator
implements WorldScript<InstanceData> {
    public final List<SavedMazePathConnection> exitPaths = new ArrayList<SavedMazePathConnection>();
    public String mazeID = "";
    public Selection rooms = Selection.zeroSelection(3);
    public BlockCoord structureShift = new BlockCoord(0, 0, 0);
    public int[] roomSize = new int[]{3, 5, 3};
    public final List<MazeRule> rules = new ArrayList<MazeRule>();

    public static <C> void addRandomPaths(Random random, int[] size, MorphingMazeComponent<C> maze, List<? extends MazeComponent<C>> components, C roomConnector, int number) {
        HashMap exits = new HashMap();
        for (MazeComponent<C> component : components) {
            for (Map.Entry entry : component.exits().entrySet()) {
                exits.put(entry.getKey(), entry.getValue());
            }
        }
        for (int i = 0; i < number; ++i) {
            int[] randomCoords = new int[size.length];
            for (int c = 0; c < randomCoords.length; ++c) {
                randomCoords[c] = MathHelper.func_76136_a((Random)random, (int)0, (int)size[c]);
            }
            MazeRoom randomRoom = new MazeRoom(randomCoords);
            MazePassage randomConnection = new MazePassage(randomRoom, randomRoom.addInDimension(random.nextInt(size.length), random.nextBoolean() ? 1 : -1));
            if (!Objects.equals(exits.get(randomConnection), roomConnector)) continue;
            maze.exits().put(randomConnection, roomConnector);
        }
    }

    public static void addExits(ConnectorFactory factory, MorphingMazeComponent<Connector> maze, List<SavedMazePathConnection> mazeExits) {
        SavedMazePaths.putAll(maze.exits(), mazeExits.stream().map(SavedMazePaths.buildFunction(factory)).map(e -> maze.rooms().contains(((MazePassage)e.getKey()).getSource()) ? e : Pair.of((Object)((MazePassage)e.getKey()).inverse(), e.getValue())).collect(Collectors.toList()));
    }

    public static <C> void blockRooms(MorphingMazeComponent<C> component, Set<MazeRoom> rooms, C wallConnector) {
        component.add(WorldGenMaze.createCompleteComponent(rooms, Collections.emptyMap(), wallConnector));
    }

    public static <C> void enclose(MorphingMazeComponent<C> component, MazeRoom lower, MazeRoom higher, C wallConnector) {
        if (lower.getDimensions() != higher.getDimensions()) {
            throw new IllegalArgumentException();
        }
        HashSet<MazeRoom> rooms = new HashSet<MazeRoom>();
        int[] coords = lower.getCoordinates();
        int i = 0;
        while (i < coords.length) {
            int lowest = lower.getCoordinate(i);
            int highest = higher.getCoordinate(i);
            int finalI = i;
            IntAreas.visitCoordsExcept(lower.getCoordinates(), higher.getCoordinates(), (TIntList)TIntArrayList.wrap((int[])new int[]{i++}), (Visitor<int[]>)((Visitor)ints -> {
                ints[finalI] = lowest;
                rooms.add(new MazeRoom(ints));
                ints[finalI] = highest;
                rooms.add(new MazeRoom(ints));
                return true;
            }));
        }
        WorldScriptMazeGenerator.blockRooms(component, rooms, wallConnector);
    }

    @Override
    public void generate(StructureSpawnContext context, InstanceData instanceData, BlockCoord coord) {
        List<PlacedStructure> placedStructures = instanceData.placedStructures;
        if (placedStructures == null) {
            return;
        }
        WorldGenMaze.generatePlacedStructures(placedStructures, context);
    }

    @Override
    public String getDisplayString() {
        return IvTranslations.get("reccomplex.worldscript.mazeGen");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate tableDelegate) {
        return new TableDataSourceWorldScriptMazeGenerator(this, tableDelegate, navigator);
    }

    public String getMazeID() {
        return this.mazeID;
    }

    public void setMazeID(String mazeID) {
        this.mazeID = mazeID;
    }

    public BlockCoord getStructureShift() {
        return this.structureShift;
    }

    public void setStructureShift(BlockCoord structureShift) {
        this.structureShift = structureShift;
    }

    public int[] getRoomSize() {
        return (int[])this.roomSize.clone();
    }

    public void setRoomSize(int[] roomSize) {
        this.roomSize = roomSize;
    }

    public Selection getRooms() {
        return this.rooms;
    }

    public void setRooms(Selection rooms) {
        this.rooms = rooms;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.mazeID = compound.func_74779_i("mazeID");
        NBTTagCompound rooms = compound.func_74775_l("rooms");
        this.rooms.readFromNBT(rooms, 3);
        if (compound.func_150297_b("roomNumbers", 11)) {
            this.rooms.add(new Selection.Area(true, new int[]{0, 0, 0}, IvVecMathHelper.sub((int[])IvNBTHelper.readIntArrayFixedSize((String)"roomNumbers", (int)3, (NBTTagCompound)compound), (int[][])new int[][]{{1, 1, 1}})));
        }
        if (compound.func_150297_b("blockedRoomAreas", 9)) {
            NBTTagList blockedRoomsList = compound.func_150295_c("blockedRoomAreas", 10);
            for (int i = 0; i < blockedRoomsList.func_74745_c(); ++i) {
                NBTTagCompound blockedRoomTag = blockedRoomsList.func_150305_b(i);
                this.rooms.add(new Selection.Area(false, IvNBTHelper.readIntArrayFixedSize((String)"min", (int)3, (NBTTagCompound)blockedRoomTag), IvNBTHelper.readIntArrayFixedSize((String)"max", (int)3, (NBTTagCompound)blockedRoomTag)));
            }
        }
        this.exitPaths.clear();
        this.exitPaths.addAll(NBTCompoundObjects.readListFrom((NBTTagCompound)compound, (String)"mazeExits", SavedMazePathConnection.class));
        this.structureShift = BlockCoord.readCoordFromNBT((String)"structureShift", (NBTTagCompound)compound);
        this.roomSize = IvNBTHelper.readIntArrayFixedSize((String)"roomSize", (int)3, (NBTTagCompound)compound);
        this.rules.clear();
        this.rules.addAll(NBTTagLists.compoundsFrom((NBTTagCompound)compound, (String)"rules").stream().map(MazeRuleRegistry.INSTANCE::read).collect(Collectors.toList()));
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("mazeID", this.mazeID);
        NBTTagCompound rooms = new NBTTagCompound();
        this.rooms.writeToNBT(rooms);
        compound.func_74782_a("rooms", (NBTBase)rooms);
        NBTCompoundObjects.writeListTo((NBTTagCompound)compound, (String)"mazeExits", this.exitPaths);
        BlockCoord.writeCoordToNBT((String)"structureShift", (BlockCoord)this.structureShift, (NBTTagCompound)compound);
        compound.func_74783_a("roomSize", this.roomSize);
        NBTTagLists.writeCompoundsTo((NBTTagCompound)compound, (String)"rules", this.rules.stream().map(MazeRuleRegistry.INSTANCE::write).collect(Collectors.toList()));
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, BlockCoord coord, World world) {
        InstanceData instanceData = new InstanceData();
        instanceData.placedStructures.addAll(WorldGenMaze.convertToPlacedStructures(context.random, coord, this.structureShift, this.getPlacedRooms(context.random, context.transform), this.roomSize, context.transform));
        return instanceData;
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new InstanceData(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound());
    }

    public List<ShiftedMazeComponent<MazeComponentStructure<Connector>, Connector>> getPlacedRooms(Random random, AxisAlignedTransform2D transform) {
        if (this.rooms.isEmpty()) {
            return null;
        }
        ConnectorFactory factory = new ConnectorFactory();
        Connector roomConnector = factory.get("Path");
        Connector wallConnector = factory.get("Wall");
        Set<Connector> blockedConnections = Collections.singleton(wallConnector);
        int[] boundsHigher = this.rooms.boundsHigher();
        int[] boundsLower = this.rooms.boundsLower();
        int[] oneArray = new int[boundsHigher.length];
        Arrays.fill(oneArray, 1);
        int[] outsideBoundsHigher = IvVecMathHelper.add((int[][])new int[][]{boundsHigher, oneArray});
        int[] outsideBoundsLower = IvVecMathHelper.sub((int[])boundsLower, (int[][])new int[][]{oneArray});
        List<MazeComponentStructure<Connector>> transformedComponents = WorldGenMaze.transformedComponents(StructureRegistry.INSTANCE.getStructuresInMaze(this.mazeID), factory, transform, blockedConnections);
        SetMazeComponent maze = new SetMazeComponent();
        WorldScriptMazeGenerator.enclose(maze, new MazeRoom(outsideBoundsLower), new MazeRoom(outsideBoundsHigher), wallConnector);
        WorldScriptMazeGenerator.blockRooms(maze, this.rooms.mazeRooms(false), wallConnector);
        WorldScriptMazeGenerator.addExits(factory, (MorphingMazeComponent<Connector>)maze, this.exitPaths);
        WorldScriptMazeGenerator.addRandomPaths(random, outsideBoundsHigher, maze, transformedComponents, roomConnector, outsideBoundsHigher[0] * outsideBoundsHigher[1] * outsideBoundsHigher[2] / 125 + 1);
        List predicates = this.rules.stream().map(r -> r.build(this, blockedConnections, factory, transformedComponents)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        predicates.add(new LimitAABBStrategy(outsideBoundsHigher));
        predicates.add(new BlockedConnectorStrategy(blockedConnections));
        ConnectorStrategy connectionStrategy = new ConnectorStrategy();
        int totalRooms = this.rooms.mazeRooms(true).size();
        return MazeComponentConnector.randomlyConnect((MorphingMazeComponent)maze, transformedComponents, (ConnectionStrategy)connectionStrategy, (MazePredicate)new MazePredicateMany(predicates), (Random)random, (int)(RCConfig.mazePlacementReversesPerRoom >= 0.0f ? MathHelper.func_76141_d((float)((float)totalRooms * RCConfig.mazePlacementReversesPerRoom + 0.5f)) : MazeComponentConnector.INFINITE_REVERSES));
    }

    public static class InstanceData
    implements NBTStorable {
        public final List<PlacedStructure> placedStructures = new ArrayList<PlacedStructure>();

        public InstanceData() {
        }

        public InstanceData(NBTTagCompound compound) {
            this.placedStructures.addAll(NBTCompoundObjects.readListFrom((NBTTagCompound)compound, (String)"placedStructures", PlacedStructure.class));
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            NBTCompoundObjects.writeListTo((NBTTagCompound)compound, (String)"placedStructures", this.placedStructures);
            return compound;
        }
    }
}

