/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.scripts.world;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.IvCollections;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.worldscripts.structuregenerator.TableDataSourceStructureBlock;
import ivorius.reccomplex.scripts.world.WorldScript;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureInfos;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.gentypes.StructureListGenerationInfo;
import ivorius.reccomplex.utils.IvTranslations;
import ivorius.reccomplex.utils.NBTStorable;
import ivorius.reccomplex.worldgen.StructureGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class WorldScriptStructureGenerator
implements WorldScript<InstanceData> {
    protected boolean simpleMode;
    protected BlockCoord structureShift = new BlockCoord(0, 0, 0);
    protected String structureListID = "";
    protected ForgeDirection front;
    protected List<String> structureNames = new ArrayList<String>();
    protected Integer structureRotation;
    protected Boolean structureMirror;

    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    public void setSimpleMode(boolean simpleMode) {
        this.simpleMode = simpleMode;
    }

    public BlockCoord getStructureShift() {
        return this.structureShift;
    }

    public void setStructureShift(BlockCoord structureShift) {
        this.structureShift = structureShift;
    }

    public String getStructureListID() {
        return this.structureListID;
    }

    public void setStructureListID(String structureListID) {
        this.structureListID = structureListID;
    }

    public ForgeDirection getFront() {
        return this.front;
    }

    public void setFront(ForgeDirection front) {
        this.front = front;
    }

    public List<String> getStructureNames() {
        return Collections.unmodifiableList(this.structureNames);
    }

    public void setStructureNames(List<String> structureNames) {
        IvCollections.setContentsOfList(this.structureNames, structureNames);
    }

    public Integer getStructureRotation() {
        return this.structureRotation;
    }

    public void setStructureRotation(Integer structureRotation) {
        this.structureRotation = structureRotation;
    }

    public Boolean getStructureMirror() {
        return this.structureMirror;
    }

    public void setStructureMirror(Boolean structureMirror) {
        this.structureMirror = structureMirror;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.structureShift = BlockCoord.readCoordFromNBT((String)"structureShift", (NBTTagCompound)nbtTagCompound);
        this.simpleMode = !nbtTagCompound.func_150297_b("simpleMode", 1) || nbtTagCompound.func_74767_n("simpleMode");
        this.structureListID = nbtTagCompound.func_74779_i("structureListID");
        this.front = nbtTagCompound.func_150297_b("front", 8) ? Directions.deserialize((String)nbtTagCompound.func_74779_i("front")) : null;
        ArrayList<String> structureList = new ArrayList<String>();
        NBTTagList structureNBTList = nbtTagCompound.func_150295_c("structures", 8);
        for (int i = 0; i < structureNBTList.func_74745_c(); ++i) {
            structureList.add(structureNBTList.func_150307_f(i));
        }
        IvCollections.setContentsOfList(this.structureNames, structureList);
        this.structureRotation = nbtTagCompound.func_74764_b("structureRotation") ? Integer.valueOf(nbtTagCompound.func_74762_e("structureRotation")) : null;
        this.structureMirror = nbtTagCompound.func_74764_b("structureMirror") ? Boolean.valueOf(nbtTagCompound.func_74767_n("structureMirror")) : null;
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        BlockCoord.writeCoordToNBT((String)"structureShift", (BlockCoord)this.structureShift, (NBTTagCompound)nbtTagCompound);
        nbtTagCompound.func_74757_a("simpleMode", this.simpleMode);
        nbtTagCompound.func_74778_a("structureListID", this.structureListID);
        if (this.front != null) {
            nbtTagCompound.func_74778_a("front", Directions.serialize((ForgeDirection)this.front));
        }
        NBTTagList structureNBTList = new NBTTagList();
        for (String struc : this.structureNames) {
            structureNBTList.func_74742_a((NBTBase)new NBTTagString(struc));
        }
        nbtTagCompound.func_74782_a("structures", (NBTBase)structureNBTList);
        if (this.structureRotation != null) {
            nbtTagCompound.func_74768_a("structureRotation", this.structureRotation.intValue());
        }
        if (this.structureMirror != null) {
            nbtTagCompound.func_74757_a("structureMirror", this.structureMirror.booleanValue());
        }
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new InstanceData(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound());
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, BlockCoord coord, World world) {
        InstanceData instanceData = null;
        Random random = context.random;
        AxisAlignedTransform2D transform = context.transform;
        if (this.simpleMode) {
            String structureID;
            StructureInfo structureInfo;
            if (this.structureNames.size() > 0 && (structureInfo = StructureRegistry.INSTANCE.getStructure(structureID = this.structureNames.get(random.nextInt(this.structureNames.size())))) != null) {
                int rotations;
                int n = structureInfo.isRotatable() ? (this.structureRotation != null ? transform.getRotation() + this.structureRotation : random.nextInt(4)) : (rotations = 0);
                boolean mirrorX = structureInfo.isMirrorable() && (this.structureMirror != null ? transform.isMirrorX() != this.structureMirror.booleanValue() : random.nextBoolean());
                AxisAlignedTransform2D strucTransform = AxisAlignedTransform2D.from((int)rotations, (boolean)mirrorX);
                int[] strucSize = structureInfo.structureBoundingBox();
                BlockCoord strucCoord = transform.apply(this.structureShift, new int[]{1, 1, 1}).subtract(transform.apply(new BlockCoord(0, 0, 0), strucSize)).add(coord);
                instanceData = new InstanceData(structureID, strucCoord, strucTransform, (NBTStorable)structureInfo.prepareInstanceData(new StructurePrepareContext(random, strucTransform, StructureInfos.structureBoundingBox(strucCoord, strucSize), context.generateAsSource)));
            }
        } else {
            Collection<Pair<StructureInfo, StructureListGenerationInfo>> generationInfos = StructureRegistry.INSTANCE.getStructuresInList(this.structureListID, this.front);
            if (generationInfos.size() > 0) {
                int rotations;
                boolean mirrorX;
                Pair pair = (Pair)WeightedSelector.select((Random)random, generationInfos, item -> ((StructureListGenerationInfo)item.getRight()).getWeight());
                StructureInfo structureInfo = (StructureInfo)pair.getLeft();
                String structureID = StructureRegistry.INSTANCE.structureID(structureInfo);
                StructureListGenerationInfo generationInfo = (StructureListGenerationInfo)pair.getRight();
                if (this.front != null) {
                    ForgeDirection curFront = Directions.rotate((ForgeDirection)this.front, (AxisAlignedTransform2D)transform);
                    mirrorX = structureInfo.isMirrorable() && structureInfo.isRotatable() && random.nextBoolean();
                    Integer neededRotations = Directions.getHorizontalClockwiseRotations((ForgeDirection)curFront, (ForgeDirection)generationInfo.front, (boolean)mirrorX);
                    rotations = neededRotations != null ? neededRotations : 0;
                } else {
                    mirrorX = structureInfo.isMirrorable() && random.nextBoolean();
                    rotations = structureInfo.isRotatable() ? random.nextInt(4) : 0;
                }
                AxisAlignedTransform2D strucTransform = AxisAlignedTransform2D.from((int)rotations, (boolean)mirrorX);
                int[] strucSize = structureInfo.structureBoundingBox();
                BlockCoord strucCoord = transform.apply(this.structureShift.add(generationInfo.shiftX, generationInfo.shiftY, generationInfo.shiftZ), new int[]{1, 1, 1}).subtract(transform.apply(new BlockCoord(0, 0, 0), strucSize)).add(coord);
                instanceData = new InstanceData(structureID, strucCoord, strucTransform, (NBTStorable)structureInfo.prepareInstanceData(new StructurePrepareContext(random, strucTransform, StructureInfos.structureBoundingBox(strucCoord, strucSize), context.generateAsSource)));
            }
        }
        return instanceData != null ? instanceData : new InstanceData();
    }

    @Override
    public void generate(StructureSpawnContext context, InstanceData instanceData, BlockCoord coord) {
        World world = context.world;
        Random random = context.random;
        int layer = context.generationLayer;
        StructureInfo structureInfo = StructureRegistry.INSTANCE.getStructure(instanceData.structureID);
        if (structureInfo != null && instanceData.structureData != null) {
            StructureGenerator.partially(structureInfo, world, random, instanceData.lowerCoord, instanceData.structureTransform, context.generationBB, layer + 1, instanceData.structureID, instanceData.structureData, context.isFirstTime);
        }
    }

    @Override
    public String getDisplayString() {
        return IvTranslations.get("reccomplex.worldscript.strucGen");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate tableDelegate) {
        return new TableDataSourceStructureBlock(this, navigator, tableDelegate);
    }

    public static class InstanceData
    implements NBTStorable {
        public String structureID;
        public BlockCoord lowerCoord;
        public AxisAlignedTransform2D structureTransform;
        public NBTStorable structureData;

        public InstanceData() {
            this.structureID = "";
        }

        public InstanceData(String structureID, BlockCoord lowerCoord, AxisAlignedTransform2D structureTransform, NBTStorable structureData) {
            this.structureID = structureID;
            this.lowerCoord = lowerCoord;
            this.structureTransform = structureTransform;
            this.structureData = structureData;
        }

        public InstanceData(NBTTagCompound compound) {
            this.structureID = compound.func_74779_i("structureID");
            this.lowerCoord = BlockCoord.readCoordFromNBT((String)"lowerCoord", (NBTTagCompound)compound);
            this.structureTransform = AxisAlignedTransform2D.from((int)compound.func_74762_e("rotation"), (boolean)compound.func_74767_n("mirrorX"));
            StructureInfo structureInfo = StructureRegistry.INSTANCE.getStructure(this.structureID);
            if (structureInfo != null) {
                this.structureData = structureInfo.loadInstanceData(new StructureLoadContext(this.structureTransform, StructureInfos.structureBoundingBox(this.lowerCoord, StructureInfos.structureSize(structureInfo, this.structureTransform)), false), compound.func_74781_a("structureData"));
            }
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("structureID", this.structureID);
            BlockCoord.writeCoordToNBT((String)"lowerCoord", (BlockCoord)this.lowerCoord, (NBTTagCompound)compound);
            compound.func_74768_a("rotation", this.structureTransform.getRotation());
            compound.func_74757_a("mirrorX", this.structureTransform.isMirrorX());
            compound.func_74782_a("structureData", this.structureData.writeToNBT());
            return compound;
        }
    }
}

