/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.eventhandler.Event;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.events.RCEventBus;
import ivorius.reccomplex.events.StructureRegistrationEvent;
import ivorius.reccomplex.json.NbtToJson;
import ivorius.reccomplex.json.SerializableStringTypeRegistry;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.generic.GenericStructureInfo;
import ivorius.reccomplex.structures.generic.gentypes.MazeGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.StaticGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.StructureListGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.VanillaStructureGenerationInfo;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.utils.CustomizableBiMap;
import ivorius.reccomplex.utils.CustomizableMap;
import ivorius.reccomplex.worldgen.StructureSelector;
import ivorius.reccomplex.worldgen.villages.GenericVillageCreationHandler;
import ivorius.reccomplex.worldgen.villages.GenericVillagePiece;
import ivorius.reccomplex.worldgen.villages.TemporaryVillagerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class StructureRegistry {
    private static SerializableStringTypeRegistry<Transformer> transformerRegistry = new SerializableStringTypeRegistry<Transformer>("transformer", "type", Transformer.class);
    private static SerializableStringTypeRegistry<StructureGenerationInfo> structureGenerationInfoRegistry = new SerializableStringTypeRegistry<StructureGenerationInfo>("generationInfo", "type", StructureGenerationInfo.class);
    public static final StructureRegistry INSTANCE = new StructureRegistry();
    private CustomizableBiMap<String, StructureInfo> allStructures = new CustomizableBiMap();
    private CustomizableMap<String, StructureData> structureData = new CustomizableMap();
    private boolean needsGenerationCacheUpdate = true;
    private Set<String> generatingStructures = new HashSet<String>();
    private Map<Class<? extends StructureGenerationInfo>, Collection<Pair<StructureInfo, ? extends StructureGenerationInfo>>> cachedGeneration = new HashMap<Class<? extends StructureGenerationInfo>, Collection<Pair<StructureInfo, ? extends StructureGenerationInfo>>>();
    private Map<Pair<Integer, String>, StructureSelector> structureSelectors = new HashMap<Pair<Integer, String>, StructureSelector>();
    private Gson gson = StructureRegistry.createGson();

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(GenericStructureInfo.class, (Object)new GenericStructureInfo.Serializer());
        transformerRegistry.constructGson(builder);
        structureGenerationInfoRegistry.constructGson(builder);
        NbtToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    public boolean registerStructure(StructureInfo info, String key, String domain, boolean generates, boolean custom) {
        StructureRegistrationEvent.Pre event = new StructureRegistrationEvent.Pre(key, info, generates);
        RCEventBus.INSTANCE.post((Event)event);
        if (event.getResult() != Event.Result.DENY && RCConfig.shouldStructureLoad(key, domain)) {
            String baseString = this.allStructures.put(key, info, custom) != null ? "Replaced structure '%s'" : "Registered structure '%s'";
            RecurrentComplex.logger.info(String.format(baseString, key));
            this.structureData.put(key, new StructureData(!event.shouldGenerate, domain), custom);
            this.clearCaches();
            RCEventBus.INSTANCE.post((Event)new StructureRegistrationEvent.Post(key, info, generates));
            return true;
        }
        return false;
    }

    public boolean hasStructure(String key) {
        return this.allStructures.getMap().containsKey((Object)key);
    }

    public StructureInfo getStructure(String key) {
        return (StructureInfo)this.allStructures.getMap().get((Object)key);
    }

    @Deprecated
    public String getName(StructureInfo structureInfo) {
        return this.structureID(structureInfo);
    }

    public String structureID(StructureInfo structureInfo) {
        return (String)this.allStructures.getMap().inverse().get((Object)structureInfo);
    }

    public void clearCustom() {
        this.structureData.clearCustom();
        this.allStructures.clearCustom();
    }

    public void unregisterStructure(String key, boolean custom) {
        StructureInfo info = (StructureInfo)this.allStructures.remove(key, custom);
        this.structureData.remove(key, custom);
        if (info != null) {
            this.generatingStructures.remove(key);
        }
        this.clearCaches();
    }

    public GenericStructureInfo createStructureFromJSON(String jsonData) throws JsonSyntaxException {
        return (GenericStructureInfo)this.gson.fromJson(jsonData, GenericStructureInfo.class);
    }

    public String createJSONFromStructure(GenericStructureInfo structureInfo) {
        return this.gson.toJson((Object)structureInfo, GenericStructureInfo.class);
    }

    public Set<StructureInfo> getAllStructures() {
        return Collections.unmodifiableSet(this.allStructures.getMap().values());
    }

    private void ensureGenerationCache() {
        if (this.needsGenerationCacheUpdate) {
            this.needsGenerationCacheUpdate = false;
            this.generatingStructures.clear();
            for (Map.Entry entry : this.allStructures.getMap().entrySet()) {
                StructureInfo info = (StructureInfo)entry.getValue();
                String key = (String)entry.getKey();
                StructureData structureData = this.structureData.getMap().get(key);
                if (structureData.disabled || !RCConfig.shouldStructureGenerate(key, structureData.domain) || !info.areDependenciesResolved()) continue;
                this.generatingStructures.add(key);
            }
        }
    }

    public Set<StructureInfo> getAllGeneratingStructures() {
        this.ensureGenerationCache();
        return Collections.unmodifiableSet(Maps.filterKeys(this.allStructures.getMap(), input -> this.generatingStructures.contains(input)).values());
    }

    public Set<String> getAllGeneratingStructureKeys() {
        return Collections.unmodifiableSet(this.generatingStructures);
    }

    public boolean isStructureGenerating(String key) {
        this.ensureGenerationCache();
        return this.generatingStructures.contains(key);
    }

    public Map<String, StructureInfo> structureMap() {
        return Collections.unmodifiableMap(this.allStructures.getMap());
    }

    @Deprecated
    public Set<String> getAllStructureNames() {
        return this.allStructureIDs();
    }

    public Set<String> allStructureIDs() {
        return Collections.unmodifiableSet(this.allStructures.getMap().keySet());
    }

    protected <T extends StructureGenerationInfo> Collection<Pair<StructureInfo, T>> getCachedGeneration(Class<T> clazz) {
        return this.cachedGeneration.get(clazz);
    }

    public <T extends StructureGenerationInfo> Collection<Pair<StructureInfo, T>> getStructureGenerations(Class<T> clazz) {
        Collection<Pair<StructureInfo, T>> pairs = this.getCachedGeneration(clazz);
        if (pairs != null) {
            return pairs;
        }
        pairs = new ArrayList<Pair<StructureInfo, T>>();
        for (StructureInfo info : this.getAllGeneratingStructures()) {
            List<T> generationInfos = info.generationInfos(clazz);
            for (StructureGenerationInfo t : generationInfos) {
                pairs.add(Pair.of((Object)info, (Object)t));
            }
        }
        ((ArrayList)pairs).trimToSize();
        this.cachedGeneration.put(clazz, pairs);
        return pairs;
    }

    public <T extends StructureGenerationInfo> Collection<Pair<StructureInfo, T>> getStructureGenerations(Class<T> clazz, Predicate<Pair<StructureInfo, T>> predicate) {
        return Collections2.filter(this.getStructureGenerations(clazz), predicate::test);
    }

    public StructureSelector getStructureSelector(BiomeGenBase biome, WorldProvider provider) {
        ImmutablePair pair = new ImmutablePair((Object)provider.field_76574_g, (Object)biome.field_76791_y);
        StructureSelector structureSelector = this.structureSelectors.get(pair);
        if (structureSelector == null || !structureSelector.isValid(biome, provider)) {
            structureSelector = new StructureSelector(this.getAllGeneratingStructures(), biome, provider);
            this.structureSelectors.put((Pair<Integer, String>)pair, structureSelector);
        }
        return structureSelector;
    }

    public Collection<Pair<StructureInfo, StructureListGenerationInfo>> getStructuresInList(String listID, ForgeDirection front) {
        return this.getStructureGenerations(StructureListGenerationInfo.class, input -> listID.equals(((StructureListGenerationInfo)input.getRight()).listID) && (front == null || ((StructureInfo)input.getLeft()).isRotatable() || ((StructureListGenerationInfo)input.getRight()).front == front));
    }

    public Collection<Pair<StructureInfo, MazeGenerationInfo>> getStructuresInMaze(String mazeID) {
        return this.getStructureGenerations(MazeGenerationInfo.class, input -> {
            MazeGenerationInfo info = (MazeGenerationInfo)input.getRight();
            return mazeID.equals(info.mazeID) && info.mazeComponent.isValid();
        });
    }

    private boolean chunkContains(int chunkX, int chunkZ, int x, int z) {
        return x >> 4 == chunkX && z >> 4 == chunkZ;
    }

    public Collection<Pair<StructureInfo, StaticGenerationInfo>> getStaticStructuresAt(int chunkX, int chunkZ, World world, ChunkCoordinates spawnPos) {
        return this.getStructureGenerations(StaticGenerationInfo.class, input -> {
            StaticGenerationInfo info = (StaticGenerationInfo)input.getRight();
            return info.dimensionMatcher.apply(world.field_73011_w) && this.chunkContains(chunkX, chunkZ, info.getPositionX(spawnPos), info.getPositionZ(spawnPos));
        });
    }

    public SerializableStringTypeRegistry<Transformer> getTransformerRegistry() {
        return transformerRegistry;
    }

    public SerializableStringTypeRegistry<StructureGenerationInfo> getStructureGenerationInfoRegistry() {
        return structureGenerationInfoRegistry;
    }

    private void clearCaches() {
        this.structureSelectors.clear();
        this.cachedGeneration.clear();
        this.needsGenerationCacheUpdate = true;
        this.updateVanillaGenerations();
        for (Pair<StructureInfo, VanillaStructureGenerationInfo> pair : this.getStructureGenerations(VanillaStructureGenerationInfo.class)) {
            String generationID;
            String structureID = this.structureID((StructureInfo)pair.getLeft());
            Class<? extends GenericVillagePiece> clazz = GenericVillageCreationHandler.getPieceClass(structureID, generationID = ((VanillaStructureGenerationInfo)pair.getRight()).id());
            if (clazz == null) continue;
            MapGenStructureIO.func_143031_a(clazz, (String)("Rc:" + structureID + "_" + generationID));
        }
    }

    private void updateVanillaGenerations() {
        TemporaryVillagerRegistry.instance().setHandlers(Sets.newHashSet((Iterable)Collections2.transform(this.getStructureGenerations(VanillaStructureGenerationInfo.class), input -> GenericVillageCreationHandler.forGeneration(this.structureID((StructureInfo)input.getLeft()), ((VanillaStructureGenerationInfo)input.getRight()).id())).stream().filter(Objects::nonNull).collect(Collectors.toList())));
    }

    private static class StructureData {
        public boolean disabled;
        public String domain;

        public StructureData(boolean disabled, String domain) {
            this.disabled = disabled;
            this.domain = domain;
        }
    }
}

