/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import ivorius.ivtoolkit.tools.IvGsonHelper;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.YSelector;
import java.lang.reflect.Type;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class GenericYSelector
implements YSelector {
    public static final int MIN_DIST_TO_VOID = 3;
    public SelectionMode selectionMode;
    public int minYShift;
    public int maxYShift;

    public GenericYSelector(SelectionMode selectionMode, int minYShift, int maxYShift) {
        this.selectionMode = selectionMode;
        this.minYShift = minYShift;
        this.maxYShift = maxYShift;
    }

    @Override
    public int selectY(World world, Random random, StructureBoundingBox boundingBox) {
        int yShift = this.minYShift + random.nextInt(this.maxYShift - this.minYShift + 1);
        switch (this.selectionMode) {
            case BEDROCK: {
                return GenericYSelector.selectByConstant(world, boundingBox, yShift);
            }
            case TOP: {
                return GenericYSelector.selectByConstant(world, boundingBox, world.func_72800_K() + yShift - 1);
            }
            case SEALEVEL: {
                return GenericYSelector.selectByConstant(world, boundingBox, 63 + yShift);
            }
            case SURFACE: {
                return GenericYSelector.selectByFunction(world, boundingBox, GenericYSelector.surfaceSelector(world), GenericYSelector.averageReducer(yShift));
            }
            case UNDERWATER: {
                return GenericYSelector.selectByFunction(world, boundingBox, GenericYSelector.surfaceUnderwaterSelector(world), GenericYSelector.averageReducer(yShift));
            }
            case LOWEST_EDGE: {
                return GenericYSelector.selectByFunction(world, boundingBox, GenericYSelector.surfaceUnderwaterSelector(world), GenericYSelector.minReducer(yShift));
            }
        }
        throw new RuntimeException("Unrecognized selection mode " + (Object)((Object)this.selectionMode));
    }

    protected static SingleYSelector surfaceSelector(World world) {
        return (x, z) -> GenericYSelector.surfaceHeight(world, x, z);
    }

    protected static SingleYSelector surfaceUnderwaterSelector(World world) {
        return (x, z) -> GenericYSelector.surfaceHeightUnderwater(world, x, z);
    }

    protected static IntListReducer minReducer(int y) {
        return list -> {
            int average = list.min();
            return average > 3 ? average + y : -1;
        };
    }

    protected static IntListReducer averageReducer(int y) {
        return list -> {
            int average = GenericYSelector.averageIgnoringErrors(list.toArray());
            return average > 3 ? average + y : -1;
        };
    }

    protected static int surfaceHeightUnderwater(World world, int x, int z) {
        int curYWater;
        for (curYWater = world.func_72825_h(x, z); curYWater > 0; --curYWater) {
            Block block = world.func_147439_a(x, curYWater, z);
            if (block instanceof BlockLiquid || block.func_149688_o() == Material.field_151588_w) continue;
            ++curYWater;
            break;
        }
        return curYWater;
    }

    protected static int surfaceHeight(World world, int x, int z) {
        Block block;
        int curY;
        for (curY = world.func_72825_h(x, z); curY > 0 && ((block = world.func_147439_a(x, curY, z)).isFoliage((IBlockAccess)world, x, curY, z) || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151585_k || block.func_149688_o() == Material.field_151575_d); --curY) {
        }
        while (curY < world.func_72800_K() && world.func_147439_a(x, curY, z) instanceof BlockLiquid) {
            ++curY;
        }
        return curY;
    }

    protected static int selectByConstant(World world, StructureBoundingBox boundingBox, int y) {
        return y;
    }

    protected static int selectByFunction(World world, StructureBoundingBox boundingBox, SingleYSelector selector, IntListReducer reducer) {
        TIntList intList = GenericYSelector.selectAll(world, boundingBox, selector);
        if (intList.size() == 0) {
            return -1;
        }
        return reducer.reduce(intList);
    }

    protected static TIntList selectAll(World world, StructureBoundingBox boundingBox, SingleYSelector selector) {
        TIntArrayList list = new TIntArrayList();
        for (int x = boundingBox.field_78897_a; x <= boundingBox.field_78893_d; ++x) {
            for (int z = boundingBox.field_78896_c; z <= boundingBox.field_78892_f; ++z) {
                if (!world.func_72899_e(x, 0, z)) continue;
                list.add(selector.select(x, z));
            }
        }
        return list;
    }

    protected static int averageIgnoringErrors(int ... values) {
        int average = 0;
        for (int val : values) {
            average += val;
        }
        average /= values.length;
        int averageDist = 0;
        for (int val : values) {
            averageDist += GenericYSelector.dist(val, average);
        }
        averageDist /= values.length;
        int newAverage = 0;
        int ignored = 0;
        for (int val : values) {
            if (GenericYSelector.dist(val, average) <= averageDist * 2) {
                newAverage += val;
                continue;
            }
            ++ignored;
        }
        return newAverage / (values.length - ignored);
    }

    protected static int dist(int val1, int val2) {
        return val1 > val2 ? val1 - val2 : val2 - val1;
    }

    public static class Serializer
    implements JsonSerializer<GenericYSelector>,
    JsonDeserializer<GenericYSelector> {
        public GenericYSelector deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "ySelector");
            SelectionMode selectionMode = jsonObject.has("selectionMode") ? (SelectionMode)((Object)context.deserialize(jsonObject.get("selectionMode"), SelectionMode.class)) : SelectionMode.SURFACE;
            int minYShift = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, "minY", 0);
            int maxYShift = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, "maxY", 0);
            return new GenericYSelector(selectionMode, minYShift, maxYShift);
        }

        public JsonElement serialize(GenericYSelector src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("selectionMode", context.serialize((Object)src.selectionMode));
            jsonObject.addProperty("minY", (Number)src.minYShift);
            jsonObject.addProperty("maxY", (Number)src.maxYShift);
            return jsonObject;
        }
    }

    protected static interface SingleYSelector {
        public int select(int var1, int var2);
    }

    protected static interface IntListReducer {
        public int reduce(TIntList var1);
    }

    public static enum SelectionMode {
        BEDROCK,
        SURFACE,
        SEALEVEL,
        UNDERWATER,
        TOP,
        LOWEST_EDGE;


        public String serializedName() {
            return IvGsonHelper.serializedName((Enum)this);
        }

        public static SelectionMode selectionMode(String serializedName) {
            return (SelectionMode)IvGsonHelper.enumForName((String)serializedName, (Enum[])SelectionMode.values());
        }
    }
}

