/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic;

import ivorius.ivtoolkit.tools.IvFileHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.FileLoadContext;
import ivorius.reccomplex.files.FileTypeHandler;
import ivorius.reccomplex.files.RCFileTypeRegistry;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.GenericStructureInfo;
import ivorius.reccomplex.structures.generic.StructureInvalidZipException;
import ivorius.reccomplex.structures.generic.StructureLoadException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class StructureSaveHandler
implements FileTypeHandler {
    public static final StructureSaveHandler INSTANCE = new StructureSaveHandler(StructureRegistry.INSTANCE);
    public static final String FILE_SUFFIX = "rcst";
    public static final String STRUCTURE_INFO_JSON_FILENAME = "structure.json";
    public static final String WORLD_DATA_NBT_FILENAME = "worldData.nbt";
    public StructureRegistry registry;

    public StructureSaveHandler(StructureRegistry registry) {
        this.registry = registry;
    }

    public static byte[] completeByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int aByte;
            while ((aByte = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(aByte);
            }
        }
        catch (Exception ignored) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected static void addZipEntry(ZipOutputStream zip, String path, byte[] bytes) throws IOException {
        ZipEntry jsonEntry = new ZipEntry(path);
        zip.putNextEntry(jsonEntry);
        jsonEntry.setSize(bytes.length);
        zip.write(bytes);
        zip.closeEntry();
    }

    public boolean saveGenericStructure(GenericStructureInfo info, String structureName, boolean activeFolder) {
        File parent = RCFileTypeRegistry.getStructuresDirectory(activeFolder);
        if (parent != null) {
            String json = this.registry.createJSONFromStructure(info);
            File newFile = new File(parent, structureName + "." + FILE_SUFFIX);
            boolean failed = false;
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(newFile));
                StructureSaveHandler.addZipEntry(zipOutputStream, STRUCTURE_INFO_JSON_FILENAME, json.getBytes());
                StructureSaveHandler.addZipEntry(zipOutputStream, WORLD_DATA_NBT_FILENAME, CompressedStreamTools.func_74798_a((NBTTagCompound)info.worldDataCompound));
                zipOutputStream.close();
            }
            catch (Exception ex) {
                RecurrentComplex.logger.error("Could not write structure to zip file", (Throwable)ex);
                failed = true;
            }
            return !failed && newFile.exists();
        }
        return false;
    }

    public boolean hasGenericStructure(String structureName, boolean activeFolder) {
        try {
            File parent = RCFileTypeRegistry.getStructuresDirectory(activeFolder);
            return parent != null && (new File(parent, structureName + "." + FILE_SUFFIX).exists() || new File(parent, structureName + ".zip").exists());
        }
        catch (Throwable e) {
            RecurrentComplex.logger.error("Error when looking up structure", e);
            return false;
        }
    }

    public boolean deleteGenericStructure(String structureName, boolean activeFolder) {
        try {
            File parent = RCFileTypeRegistry.getStructuresDirectory(activeFolder);
            return parent != null && (new File(parent, structureName + "." + FILE_SUFFIX).delete() || new File(parent, structureName + ".zip").delete());
        }
        catch (Throwable e) {
            RecurrentComplex.logger.error("Error when deleting structure", e);
            return false;
        }
    }

    public GenericStructureInfo readGenericStructure(Path file) throws StructureLoadException, IOException {
        try (ZipInputStream zip = new ZipInputStream(Files.newInputStream(file, new OpenOption[0]));){
            GenericStructureInfo genericStructureInfo = this.structureInfoFromZip(zip);
            return genericStructureInfo;
        }
    }

    public GenericStructureInfo structureInfoFromResource(ResourceLocation resourceLocation) {
        try {
            return this.structureInfoFromZip(new ZipInputStream(IvFileHelper.inputStreamFromResourceLocation((ResourceLocation)resourceLocation)));
        }
        catch (Exception ex) {
            RecurrentComplex.logger.error("Could not read generic structure " + resourceLocation.toString(), (Throwable)ex);
            return null;
        }
    }

    public GenericStructureInfo structureInfoFromZip(ZipInputStream zipInputStream) throws StructureLoadException {
        try {
            ZipEntry zipEntry;
            String json = null;
            NBTTagCompound worldData = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                byte[] bytes = StructureSaveHandler.completeByteArray(zipInputStream);
                if (bytes != null) {
                    if (STRUCTURE_INFO_JSON_FILENAME.equals(zipEntry.getName())) {
                        json = new String(bytes);
                    } else if (WORLD_DATA_NBT_FILENAME.equals(zipEntry.getName())) {
                        worldData = CompressedStreamTools.func_152457_a((byte[])bytes, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                    }
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
            if (json == null || worldData == null) {
                throw new StructureInvalidZipException(json != null, worldData != null);
            }
            GenericStructureInfo genericStructureInfo = this.registry.createStructureFromJSON(json);
            genericStructureInfo.worldDataCompound = worldData;
            return genericStructureInfo;
        }
        catch (IOException e) {
            throw new StructureLoadException(e);
        }
    }

    @Override
    public boolean loadFile(Path path, FileLoadContext context) {
        try {
            String structureID;
            GenericStructureInfo genericStructureInfo = this.readGenericStructure(path);
            String string = structureID = context.customID != null ? context.customID : FilenameUtils.getBaseName((String)path.getFileName().toString());
            if (this.registry.registerStructure(genericStructureInfo, structureID, context.domain, context.active, context.custom)) {
                return true;
            }
        }
        catch (StructureLoadException | IOException e) {
            RecurrentComplex.logger.warn("Error reading structure", (Throwable)e);
        }
        return false;
    }

    @Override
    public void clearCustomFiles() {
        StructureRegistry.INSTANCE.clearCustom();
    }
}

