/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.gentypes;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceStructureListGenerationInfo;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class StructureListGenerationInfo
extends StructureGenerationInfo
implements WeightedSelector.Item {
    public String id = "";
    public String listID;
    public Double weight;
    public int shiftX;
    public int shiftY;
    public int shiftZ;
    public ForgeDirection front;

    public StructureListGenerationInfo() {
        this(StructureListGenerationInfo.randomID("List"), "", null, 0, 0, 0, ForgeDirection.NORTH);
    }

    public StructureListGenerationInfo(String id, String listID, Double weight, int shiftX, int shiftY, int shiftZ, ForgeDirection front) {
        this.id = id;
        this.listID = listID;
        this.weight = weight;
        this.shiftX = shiftX;
        this.shiftY = shiftY;
        this.shiftZ = shiftZ;
        this.front = front;
    }

    @Override
    @Nonnull
    public String id() {
        return this.id;
    }

    @Override
    public void setID(@Nonnull String id) {
        this.id = id;
    }

    @Override
    public String displayString() {
        return StatCollector.func_74837_a((String)"reccomplex.generationInfo.structureList.title", (Object[])new Object[]{this.listID});
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceStructureListGenerationInfo(navigator, delegate, this);
    }

    public double getWeight() {
        return this.weight != null ? this.weight : 1.0;
    }

    public static class Serializer
    implements JsonSerializer<StructureListGenerationInfo>,
    JsonDeserializer<StructureListGenerationInfo> {
        public StructureListGenerationInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "vanillaStructureSpawnInfo");
            String id = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "id", "");
            String listID = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "listID", "");
            Double weight = jsonObject.has("weight") ? Double.valueOf(JsonUtils.getJsonObjectDoubleFieldValue(jsonObject, "weight")) : null;
            int positionX = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, "positionX", 0);
            int positionY = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, "positionY", 0);
            int positionZ = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, "positionZ", 0);
            ForgeDirection front = Directions.deserialize((String)JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "front", "NORTH"));
            return new StructureListGenerationInfo(id, listID, weight, positionX, positionY, positionZ, front);
        }

        public JsonElement serialize(StructureListGenerationInfo src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", src.id);
            jsonObject.addProperty("listID", src.listID);
            if (src.weight != null) {
                jsonObject.addProperty("weight", (Number)src.weight);
            }
            jsonObject.addProperty("positionX", (Number)src.shiftX);
            jsonObject.addProperty("positionY", (Number)src.shiftY);
            jsonObject.addProperty("positionZ", (Number)src.shiftZ);
            jsonObject.addProperty("front", Directions.serialize((ForgeDirection)src.front));
            return jsonObject;
        }
    }
}

