/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.matchers;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import ivorius.ivtoolkit.tools.IvGsonHelper;
import ivorius.reccomplex.json.RCGsonHelper;
import ivorius.reccomplex.utils.ExpressionCaches;
import ivorius.reccomplex.utils.PrefixedTypeExpressionCache;
import ivorius.reccomplex.utils.RCBoolAlgebra;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import joptsimple.internal.Strings;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeMatcher
extends PrefixedTypeExpressionCache<Boolean>
implements Predicate<BiomeGenBase> {
    public static final String BIOME_TYPE_PREFIX = "$";

    public BiomeMatcher(String expression) {
        super(RCBoolAlgebra.algebra(), true, EnumChatFormatting.GREEN + "Any Biome", expression);
        this.addType(new BiomeVariableType(""));
        this.addType(new BiomeDictVariableType(BIOME_TYPE_PREFIX));
    }

    public static String ofTypes(BiomeDictionary.Type ... biomeTypes) {
        return BIOME_TYPE_PREFIX + Strings.join((List)Lists.transform(Arrays.asList(biomeTypes), input -> input != null ? IvGsonHelper.serializedName((Enum)input) : null), (String)" & $");
    }

    public static Set<BiomeGenBase> gatherAllBiomes() {
        HashSet<BiomeGenBase> set = new HashSet<BiomeGenBase>();
        for (BiomeGenBase biomeGenBase : BiomeGenBase.func_150565_n()) {
            if (biomeGenBase == null) continue;
            set.add(biomeGenBase);
        }
        for (BiomeGenBase biomeGenBase : BiomeDictionary.Type.values()) {
            try {
                Collections.addAll(set, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeGenBase));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return set;
    }

    @Override
    public boolean containsUnknownVariables() {
        return super.containsUnknownVariables(BiomeMatcher.gatherAllBiomes());
    }

    @Override
    @Nonnull
    public String getDisplayString() {
        return super.getDisplayString(BiomeMatcher.gatherAllBiomes());
    }

    public boolean apply(BiomeGenBase input) {
        return (Boolean)this.evaluate(input);
    }

    protected static class BiomeDictVariableType
    extends ExpressionCaches.SimpleVariableType<Boolean> {
        public BiomeDictVariableType(String prefix) {
            super(prefix);
        }

        @Override
        public Boolean evaluate(String var, Object ... args) {
            BiomeDictionary.Type type = (BiomeDictionary.Type)RCGsonHelper.enumForNameIgnoreCase((String)var, (Enum[])BiomeDictionary.Type.values());
            return type != null && BiomeDictionary.isBiomeOfType((BiomeGenBase)((BiomeGenBase)args[0]), (BiomeDictionary.Type)type);
        }

        @Override
        public boolean isKnown(String var, Object ... args) {
            return RCGsonHelper.enumForNameIgnoreCase((String)var, (Enum[])BiomeDictionary.Type.values()) != null;
        }
    }

    protected static class BiomeVariableType
    extends ExpressionCaches.SimpleVariableType<Boolean> {
        public BiomeVariableType(String prefix) {
            super(prefix);
        }

        @Override
        public Boolean evaluate(String var, Object ... args) {
            return ((BiomeGenBase)args[0]).field_76791_y.equals(var);
        }

        @Override
        public boolean isKnown(String var, Object ... args) {
            return StreamSupport.stream(((Iterable)args[0]).spliterator(), false).anyMatch(input -> input.field_76791_y.equals(var));
        }
    }
}

