/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.reccomplex.json.JsonUtils;
import java.lang.reflect.Type;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class SavedMazePath
implements NBTCompoundObject,
Comparable<SavedMazePath> {
    public int pathDimension;
    public MazeRoom sourceRoom;
    public boolean pathGoesUp;

    public SavedMazePath() {
    }

    public SavedMazePath(int pathDimension, MazeRoom sourceRoom, boolean pathGoesUp) {
        this.pathDimension = pathDimension;
        this.sourceRoom = sourceRoom;
        this.pathGoesUp = pathGoesUp;
    }

    public void set(SavedMazePath path) {
        this.pathDimension = path.pathDimension;
        this.sourceRoom = path.sourceRoom;
        this.pathGoesUp = path.pathGoesUp;
    }

    public MazePassage build() {
        return new MazePassage(this.getSourceRoom(), this.getDestRoom());
    }

    public MazeRoom getSourceRoom() {
        return this.sourceRoom;
    }

    public MazeRoom getDestRoom() {
        return this.sourceRoom.addInDimension(this.pathDimension, this.pathGoesUp ? 1 : -1);
    }

    public SavedMazePath inverse() {
        return new SavedMazePath(this.pathDimension, this.sourceRoom.addInDimension(this.pathDimension, this.pathGoesUp ? 1 : -1), !this.pathGoesUp);
    }

    public SavedMazePath copy() {
        return new SavedMazePath(this.pathDimension, this.sourceRoom, this.pathGoesUp);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.sourceRoom = compound.func_150297_b("source", 10) ? new MazeRoom(compound.func_74775_l("source").func_74759_k("coordinates")) : new MazeRoom(compound.func_74759_k("source"));
        this.pathDimension = compound.func_74762_e("pathDimension");
        this.pathGoesUp = compound.func_74767_n("pathGoesUp");
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("source", (NBTBase)this.sourceRoom.storeInNBT());
        compound.func_74768_a("pathDimension", this.pathDimension);
        compound.func_74757_a("pathGoesUp", this.pathGoesUp);
    }

    public String toString() {
        return String.format("%s %s", this.sourceRoom, this.getForgeDirection());
    }

    public ForgeDirection getForgeDirection() {
        switch (this.pathDimension) {
            case 0: {
                return this.pathGoesUp ? ForgeDirection.EAST : ForgeDirection.WEST;
            }
            case 1: {
                return this.pathGoesUp ? ForgeDirection.UP : ForgeDirection.DOWN;
            }
            case 2: {
                return this.pathGoesUp ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
            }
        }
        throw new InternalError();
    }

    @Override
    public int compareTo(SavedMazePath o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavedMazePath that = (SavedMazePath)o;
        if (this.pathDimension != that.pathDimension) {
            return false;
        }
        if (this.pathGoesUp != that.pathGoesUp) {
            return false;
        }
        return this.sourceRoom != null ? this.sourceRoom.equals((Object)that.sourceRoom) : that.sourceRoom == null;
    }

    public int hashCode() {
        int result = this.pathDimension;
        result = 31 * result + (this.sourceRoom != null ? this.sourceRoom.hashCode() : 0);
        result = 31 * result + (this.pathGoesUp ? 1 : 0);
        return result;
    }

    public static class Serializer
    implements JsonSerializer<SavedMazePath>,
    JsonDeserializer<SavedMazePath> {
        public SavedMazePath deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "MazeRoom");
            MazeRoom src = (MazeRoom)context.deserialize(jsonObject.get("source"), MazeRoom.class);
            int pathDimension = JsonUtils.getJsonObjectIntegerFieldValue(jsonObject, "pathDimension");
            boolean pathGoesUp = JsonUtils.getJsonObjectBooleanFieldValue(jsonObject, "pathGoesUp");
            return new SavedMazePath(pathDimension, src, pathGoesUp);
        }

        public JsonElement serialize(SavedMazePath src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("source", context.serialize((Object)src.sourceRoom));
            jsonObject.addProperty("pathDimension", (Number)src.pathDimension);
            jsonObject.addProperty("pathGoesUp", Boolean.valueOf(src.pathGoesUp));
            return jsonObject;
        }
    }
}

