/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.generic.maze.Connector;
import ivorius.reccomplex.structures.generic.maze.ConnectorFactory;
import ivorius.reccomplex.structures.generic.maze.SavedConnector;
import ivorius.reccomplex.structures.generic.maze.SavedMazePath;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;

public class SavedMazePathConnection
implements NBTCompoundObject {
    public final SavedMazePath path = new SavedMazePath();
    public final SavedConnector connector = new SavedConnector("Path");

    public SavedMazePathConnection() {
    }

    public SavedMazePathConnection(SavedMazePath path, SavedConnector connector) {
        this(path.pathDimension, path.sourceRoom, path.pathGoesUp, connector.id);
    }

    public SavedMazePathConnection(int pathDimension, MazeRoom sourceRoom, boolean pathGoesUp, String connector) {
        this.path.pathDimension = pathDimension;
        this.path.sourceRoom = sourceRoom;
        this.path.pathGoesUp = pathGoesUp;
        this.connector.id = connector;
    }

    public SavedMazePath getPath() {
        return this.path;
    }

    public SavedConnector getConnector() {
        return this.connector;
    }

    public Map.Entry<MazePassage, Connector> build(ConnectorFactory factory) {
        return Pair.of((Object)this.path.build(), (Object)this.connector.toConnector(factory));
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.path.readFromNBT(compound);
        this.connector.id = compound.func_150297_b("connector", 8) ? compound.func_74779_i("connector") : "Path";
    }

    public void writeToNBT(NBTTagCompound compound) {
        this.path.writeToNBT(compound);
        compound.func_74778_a("connector", this.connector.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavedMazePathConnection that = (SavedMazePathConnection)o;
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return this.connector != null ? this.connector.equals(that.connector) : that.connector == null;
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.connector != null ? this.connector.hashCode() : 0);
        return result;
    }

    public static class Serializer
    implements JsonSerializer<SavedMazePathConnection>,
    JsonDeserializer<SavedMazePathConnection> {
        public SavedMazePathConnection deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "MazeRoom");
            SavedMazePath path = (SavedMazePath)context.deserialize(json, SavedMazePath.class);
            String connector = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "connector", "Path");
            return new SavedMazePathConnection(path, new SavedConnector(connector));
        }

        public JsonElement serialize(SavedMazePathConnection src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = (JsonObject)context.serialize((Object)src.path);
            jsonObject.addProperty("connector", src.connector.id);
            return jsonObject;
        }
    }
}

