/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePassages;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.scripts.world.WorldScriptMazeGenerator;
import ivorius.reccomplex.structures.generic.Selection;
import ivorius.reccomplex.structures.generic.maze.Connector;
import ivorius.reccomplex.structures.generic.maze.SavedMazeComponent;
import ivorius.reccomplex.structures.generic.maze.SavedMazePath;
import ivorius.reccomplex.structures.generic.maze.SavedMazePaths;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class SavedMazeReachability
implements NBTCompoundObject {
    private static final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
    public final List<Set<SavedMazePath>> groups = new ArrayList<Set<SavedMazePath>>();
    public final List<ImmutablePair<SavedMazePath, SavedMazePath>> crossConnections = new ArrayList<ImmutablePair<SavedMazePath, SavedMazePath>>();

    public <T extends Map.Entry<SavedMazePath, SavedMazePath>> SavedMazeReachability(List<Set<SavedMazePath>> groups, List<T> crossConnections) {
        this.set(groups, crossConnections);
    }

    public SavedMazeReachability() {
    }

    public static Predicate<MazePassage> notBlocked(Collection<Connector> blockedConnections, Map<MazePassage, Connector> connections) {
        return input -> !blockedConnections.contains(connections.get(input));
    }

    public static Set<SavedMazePath> buildExpected(WorldScriptMazeGenerator script) {
        HashSet complete = Sets.newHashSet((Iterable)script.exitPaths.stream().map(input -> input.path).collect(Collectors.toList()));
        SavedMazeReachability.completeExitPaths(complete, script.rooms);
        return complete;
    }

    public static Set<SavedMazePath> buildExpected(SavedMazeComponent savedMazeComponent) {
        HashSet complete = Sets.newHashSet((Iterable)savedMazeComponent.exitPaths.stream().map(input -> input.path).collect(Collectors.toList()));
        SavedMazeReachability.completeExitPaths(complete, savedMazeComponent.rooms);
        return complete;
    }

    public static void completeExitPaths(Set<SavedMazePath> exits, Selection rooms) {
        Set<MazeRoom> roomSet = rooms.mazeRooms(true);
        for (MazeRoom room : roomSet) {
            SavedMazePaths.neighborPaths(room).filter(connection -> !exits.contains(connection) && (!roomSet.contains(connection.getSourceRoom()) || !roomSet.contains(connection.getDestRoom()))).forEach(exits::add);
        }
    }

    public void set(SavedMazeReachability reachability) {
        this.set(reachability.groups, reachability.crossConnections);
    }

    public <T extends Map.Entry<SavedMazePath, SavedMazePath>> void set(List<Set<SavedMazePath>> groups, List<T> crossConnections) {
        this.groups.clear();
        for (Set<SavedMazePath> group : groups) {
            this.groups.add(Sets.newHashSet((Iterable)group.stream().map(SavedMazePath::copy).collect(Collectors.toList())));
        }
        this.crossConnections.clear();
        for (Map.Entry entry : crossConnections) {
            this.crossConnections.add((ImmutablePair<SavedMazePath, SavedMazePath>)ImmutablePair.of((Object)((SavedMazePath)entry.getKey()).copy(), (Object)((SavedMazePath)entry.getValue()).copy()));
        }
    }

    public ImmutableMultimap<MazePassage, MazePassage> build(AxisAlignedTransform2D transform, int[] size, Predicate<MazePassage> filter, Set<MazePassage> connections) {
        filter = ((Predicate<MazePassage>)arg_0 -> ((com.google.common.base.Predicate)Predicates.in(connections)).apply(arg_0)).and(filter);
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        HashSet defaultGroup = Sets.newHashSet(connections);
        for (Set<SavedMazePath> set : this.groups) {
            List mazePassages = set.stream().map(savedMazePath -> MazePassages.rotated((MazePassage)savedMazePath.build(), (AxisAlignedTransform2D)transform, (int[])size)).filter(filter).collect(Collectors.toList());
            defaultGroup.removeAll(mazePassages);
            this.addInterconnections((ImmutableMultimap.Builder<MazePassage, MazePassage>)builder, mazePassages.stream());
        }
        this.addInterconnections((ImmutableMultimap.Builder<MazePassage, MazePassage>)builder, defaultGroup.stream());
        for (Map.Entry entry : this.crossConnections) {
            MazePassage key = MazePassages.rotated((MazePassage)((SavedMazePath)entry.getKey()).build(), (AxisAlignedTransform2D)transform, (int[])size);
            MazePassage val = MazePassages.rotated((MazePassage)((SavedMazePath)entry.getValue()).build(), (AxisAlignedTransform2D)transform, (int[])size);
            if (!filter.test(key) || !filter.test(val)) continue;
            builder.put((Object)key, (Object)val);
        }
        return builder.build();
    }

    protected void addInterconnections(ImmutableMultimap.Builder<MazePassage, MazePassage> builder, Stream<MazePassage> existing) {
        existing.reduce((last, current) -> {
            if (last != null) {
                builder.put(last, current);
                builder.put(current, last);
            }
            return current;
        });
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.groups.clear();
        this.groups.addAll(Lists.transform((List)NBTTagLists.listsFrom((NBTTagCompound)compound, (String)"groups"), input -> Sets.newHashSet((Iterable)NBTCompoundObjects.readList((NBTTagList)input, SavedMazePath.class))));
        this.crossConnections.clear();
        this.crossConnections.addAll(Lists.transform((List)NBTTagLists.compoundsFrom((NBTTagCompound)compound, (String)"crossConnections"), input -> ImmutablePair.of((Object)NBTCompoundObjects.readFrom((NBTTagCompound)input, (String)"key", SavedMazePath.class), (Object)NBTCompoundObjects.readFrom((NBTTagCompound)input, (String)"val", SavedMazePath.class))));
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagLists.writeTo((NBTTagCompound)compound, (String)"groups", (List)Lists.transform(this.groups, NBTCompoundObjects::writeList));
        NBTTagLists.writeCompoundsTo((NBTTagCompound)compound, (String)"crossConnections", (List)Lists.transform(this.crossConnections, input -> {
            NBTTagCompound compound1 = new NBTTagCompound();
            NBTCompoundObjects.writeTo((NBTTagCompound)compound1, (String)"key", (NBTCompoundObject)((NBTCompoundObject)input.getKey()));
            NBTCompoundObjects.writeTo((NBTTagCompound)compound1, (String)"val", (NBTCompoundObject)((NBTCompoundObject)input.getValue()));
            return compound1;
        }));
    }

    public static class Serializer
    implements JsonSerializer<SavedMazeReachability>,
    JsonDeserializer<SavedMazeReachability> {
        public SavedMazeReachability deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List crossConnections;
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "MazeReachability");
            List<Set<SavedMazePath>> groups = (List<Set<SavedMazePath>>)context.deserialize(jsonObject.get("groups"), new TypeToken<List<Set<SavedMazePath>>>(){}.getType());
            if (groups == null) {
                groups = Collections.emptyList();
            }
            if ((crossConnections = (List)gson.fromJson((JsonElement)JsonUtils.getJsonObjectJsonArrayFieldOrDefault(jsonObject, "crossConnections", new JsonArray()), new TypeToken<List<ImmutablePair<SavedMazePath, SavedMazePath>>>(){}.getType())) == null) {
                crossConnections = Collections.emptyList();
            }
            return new SavedMazeReachability(groups, crossConnections);
        }

        public JsonElement serialize(SavedMazeReachability src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("groups", context.serialize(src.groups));
            jsonObject.add("crossConnections", gson.toJsonTree(src.crossConnections));
            return jsonObject;
        }
    }
}

