/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze.rules;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePredicate;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import ivorius.ivtoolkit.tools.GuavaCollectors;
import ivorius.ivtoolkit.tools.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class ReachabilityStrategy<M extends MazeComponent<C>, C>
implements MazePredicate<M, C> {
    private final Set<Pair<MazeRoom, Set<MazeRoom>>> traversalAbilities = new HashSet<Pair<MazeRoom, Set<MazeRoom>>>();
    private ConnectionPoint mainConnectionPoint;
    private final List<ConnectionPoint> connectionPoints = new ArrayList<ConnectionPoint>();
    private final TObjectIntMap<ConnectionPoint> stepsReached = new TObjectIntHashMap();
    private final Predicate<MazeRoom> confiner;
    private final Predicate<C> traverser;
    private boolean preventConnection;

    public ReachabilityStrategy(Predicate<MazeRoom> confiner, Predicate<C> traverser, boolean preventConnection) {
        this.confiner = confiner;
        this.traverser = traverser;
        this.preventConnection = preventConnection;
    }

    public static <M extends MazeComponent<C>, C> ReachabilityStrategy<M, C> connect(Collection<Collection<MazePassage>> points, Predicate<C> traverser, Predicate<MazeRoom> confiner, Set<Pair<MazeRoom, Set<MazeRoom>>> traversalAbilities) {
        ReachabilityStrategy<M, C> strategy = new ReachabilityStrategy<M, C>(confiner, traverser, false);
        strategy.setConnection(points);
        strategy.traversalAbilities.addAll(traversalAbilities);
        return strategy;
    }

    public static <M extends MazeComponent<C>, C> ReachabilityStrategy<M, C> preventConnection(Collection<Collection<MazePassage>> points, Predicate<C> traverser, Predicate<MazeRoom> confiner) {
        ReachabilityStrategy<M, C> strategy = new ReachabilityStrategy<M, C>(confiner, traverser, true);
        strategy.setConnection(points);
        return strategy;
    }

    public static <C> Set<Pair<MazeRoom, Set<MazeRoom>>> compileAbilities(Collection<? extends MazeComponent<C>> components, Predicate<C> traverser) {
        HashSet<Pair<MazeRoom, Set<MazeRoom>>> abilities = new HashSet<Pair<MazeRoom, Set<MazeRoom>>>();
        for (MazeComponent<C> component : components) {
            component.exits().forEach((passage, c) -> {
                if (traverser.test(c)) {
                    abilities.add(Pair.of((Object)passage.normalize().getDest(), Collections.emptySet()));
                }
            });
            for (Map.Entry entry : component.reachability().entries()) {
                if (!traverser.test(component.exits().get(entry.getValue()))) continue;
                MazePassage passage2 = new MazePassage(((MazePassage)entry.getKey()).getSource(), ((MazePassage)entry.getValue()).getSource());
                abilities.add((Pair<MazeRoom, Set<MazeRoom>>)Pair.of((Object)passage2.normalize().getDest(), component.rooms().stream().map(r -> r.sub(passage2.getSource())).collect(Collectors.toSet())));
            }
        }
        Iterator iterator = abilities.iterator();
        while (iterator.hasNext()) {
            Pair ability = (Pair)iterator.next();
            MazeRoom nullRoom = new MazeRoom(new int[((MazeRoom)ability.getLeft()).getDimensions()]);
            if (!ReachabilityStrategy.canReach((Set)ability.getRight(), abilities.stream().filter(a -> !a.equals((Object)ability)).collect(Collectors.toSet()), Collections.singleton(nullRoom), Collections.singleton(ability.getLeft()), null)) continue;
            iterator.remove();
        }
        return abilities;
    }

    public static <C> Predicate<C> connectorTraverser(Set<C> blockingConnections) {
        return input -> !blockingConnections.contains(input);
    }

    protected static <C> Set<MazePassage> traverse(Collection<MazeComponent<C>> mazes, @Nullable Collection<MazePassage> traversed, boolean addToTraversed, Set<MazePassage> connections, Predicate<C> traverser, @Nullable Visitor<MazePassage> visitor) {
        MazePassage traversing;
        if (addToTraversed) {
            Objects.requireNonNull(traversed);
        }
        LinkedList dirty = Lists.newLinkedList(connections);
        HashSet<MazePassage> added = new HashSet<MazePassage>();
        while ((traversing = (MazePassage)dirty.pollFirst()) != null) {
            for (MazeComponent maze : mazes) {
                maze.reachability().get((Object)traversing).forEach(dest -> {
                    if (!(traversed != null && traversed.contains(dest) || !addToTraversed && added.contains(dest) || visitor != null && !visitor.visit(dest))) {
                        MazePassage rDest;
                        if (traverser.test(maze.exits().get(dest)) && added.add(rDest = dest.inverse())) {
                            if (addToTraversed) {
                                traversed.add(rDest);
                            }
                            dirty.addLast(rDest);
                        }
                        if (addToTraversed) {
                            traversed.add((MazePassage)dest);
                        }
                        dirty.addLast(dest);
                        added.add((MazePassage)dest);
                    }
                });
            }
        }
        return added;
    }

    private static boolean canReach(Set<MazeRoom> rooms, Set<Pair<MazeRoom, Set<MazeRoom>>> abilities, Set<MazeRoom> left, Set<MazeRoom> right, Predicate<MazeRoom> confiner) {
        return ReachabilityStrategy.canReach(rooms, abilities, Collections.emptyList(), left, right, Collections.emptyList(), confiner, null);
    }

    private static <C> boolean canReach(Set<MazeRoom> rooms, Set<Pair<MazeRoom, Set<MazeRoom>>> abilities, Collection<MazeComponent<C>> mazes, Set<MazeRoom> left, Set<MazeRoom> right, Collection<MazePassage> pTraversed, Predicate<MazeRoom> confiner, Predicate<C> traverser) {
        if (left.size() <= 0 || right.size() <= 0) {
            return false;
        }
        HashSet traversed = Sets.newHashSet(pTraversed);
        Predicate<MazeRoom> predicate = confiner != null ? confiner.and(o -> !rooms.contains(o)) : rooms::contains;
        Predicate<MazePassage> passagePredicate = p -> predicate.test(p.getDest()) && !traversed.contains(p);
        Multimap<MazeRoom, MazePassage> entryReachability = ReachabilityStrategy.compileEntryReachability(mazes, passagePredicate, traverser);
        HashSet visited = Sets.newHashSet(left);
        TreeSet dirty = Sets.newTreeSet((o1, o2) -> {
            int compare = Double.compare(ReachabilityStrategy.minDistanceSQ(o1, right), ReachabilityStrategy.minDistanceSQ(o2, right));
            return compare != 0 ? compare : ReachabilityStrategy.compare(o1.getCoordinates(), o2.getCoordinates());
        });
        dirty.addAll(left);
        visited.addAll(left);
        LinkedList tryAdd = Lists.newLinkedList();
        while (!dirty.isEmpty()) {
            MazeRoom cur = (MazeRoom)dirty.pollFirst();
            for (MazeRoom next : abilities.stream().filter(e -> ((Set)e.getValue()).stream().map(p -> p.add(cur)).allMatch(predicate)).map(p -> ((MazeRoom)p.getKey()).add(cur))::iterator) {
                do {
                    if (right.contains(next)) {
                        return true;
                    }
                    if (!predicate.test(next) || !visited.add(next)) continue;
                    for (MazePassage passage : entryReachability.removeAll((Object)next)) {
                        Set<MazeRoom> roomExits = ReachabilityStrategy.traverse(mazes, traversed, true, Collections.singleton(passage), traverser, null).stream().map(MazePassage::getDest).collect(Collectors.toSet());
                        tryAdd.addAll(roomExits);
                        roomExits.forEach(arg_0 -> entryReachability.removeAll(arg_0));
                    }
                    dirty.add(next);
                } while (!tryAdd.isEmpty() && (next = (MazeRoom)tryAdd.pollFirst()) != null);
            }
        }
        return false;
    }

    private static <C> Multimap<MazeRoom, MazePassage> compileEntryReachability(Collection<MazeComponent<C>> mazes, Predicate<MazePassage> passagePredicate, Predicate<C> traverser) {
        HashMultimap iReachability = HashMultimap.create();
        for (MazeComponent maze : mazes) {
            iReachability.putAll((Multimap)maze.reachability().keySet().stream().filter(passagePredicate.and(p -> traverser.test(maze.exits().get(p)))).collect(GuavaCollectors.toMultimap(MazePassage::getDest, arg_0 -> ((Multimap)maze.reachability()).get(arg_0))));
        }
        return iReachability;
    }

    private static int compare(int[] left, int[] right) {
        for (int i = 0; i < left.length; ++i) {
            int cmp = Integer.compare(left[i], right[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static double minDistanceSQ(MazeRoom room, Collection<MazeRoom> rooms) {
        return rooms.stream().mapToDouble(r -> room.distanceSQ(room)).min().orElse(0.0);
    }

    protected void setConnection(Collection<Collection<MazePassage>> points) {
        this.connectionPoints.addAll(points.stream().map(p -> new ConnectionPoint((Collection<MazePassage>)p, p.stream().map(MazePassage::inverse).collect(Collectors.toList()))).collect(Collectors.toList()));
        this.mainConnectionPoint = this.connectionPoints.size() > 0 ? this.connectionPoints.remove(0) : null;
    }

    public boolean canPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component) {
        if (this.preventConnection && !this.stepsReached.isEmpty()) {
            return true;
        }
        if (this.stepsReached.size() == this.connectionPoints.size()) {
            return true;
        }
        this.place(maze, component, true);
        Sets.SetView roomsFromBoth = Sets.union((Set)maze.rooms(), (Set)component.rooms());
        Predicate<MazePassage> isDirty = arg_0 -> this.lambda$canPlace$77((Set)roomsFromBoth, arg_0);
        boolean canPlace = this.preventConnection ? this.stepsReached.isEmpty() : this.connectionPoints.stream().allMatch(arg_0 -> this.lambda$canPlace$78((Set)roomsFromBoth, maze, component, isDirty, arg_0));
        this.unplace(maze, component, true);
        return canPlace;
    }

    public void willPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component) {
        this.place(maze, component, false);
    }

    public void didPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component) {
    }

    public void willUnplace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component) {
    }

    protected void place(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component, boolean simulate) {
        if (this.stepsReached.size() == this.connectionPoints.size()) {
            this.stepsReached.transformValues(i -> i + 1);
        } else {
            for (ConnectionPoint point2 : this.connectionPoints) {
                if (this.stepsReached.containsKey((Object)point2)) {
                    this.stepsReached.adjustValue((Object)point2, 1);
                    continue;
                }
                point2.order.add(this.traverse((MazeComponent<C>)maze, (MazeComponent<C>)component, point2.traversed, (Collection<MazePassage>)this.mainConnectionPoint.traversed, p -> this.stepsReached.put((Object)point2, 0)));
            }
            this.mainConnectionPoint.order.add(this.traverse((MazeComponent<C>)maze, (MazeComponent<C>)component, this.mainConnectionPoint.traversed, this.connectionPoints.stream().filter(point -> !this.stepsReached.containsKey(point)).flatMap(point -> point.traversed.stream()).collect(Collectors.toList()), p -> this.connectionPoints.stream().filter(point -> point.traversed.contains(p)).forEach(point -> this.stepsReached.put(point, 0))));
        }
    }

    protected Set<MazePassage> traverse(MazeComponent<C> maze, MazeComponent<C> component, Set<MazePassage> traversed, Collection<MazePassage> goal, Consumer<MazePassage> goalConsumer) {
        return ReachabilityStrategy.traverse(Arrays.asList(maze, component), traversed, true, (Set<MazePassage>)Sets.intersection(component.exits().keySet(), traversed), this.traverser, (Visitor<MazePassage>)((Visitor)connection -> {
            if (goal.contains(connection)) {
                goalConsumer.accept((MazePassage)connection);
            }
            return true;
        }));
    }

    public void didUnplace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component) {
        this.unplace(maze, component, false);
    }

    protected void unplace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component, boolean simulate) {
        this.stepsReached.transformValues(i -> i - 1);
        this.stepsReached.retainEntries((a, i) -> i >= 0);
        if (this.stepsReached.size() < this.connectionPoints.size()) {
            this.mainConnectionPoint.reverseStep();
            for (ConnectionPoint point : this.connectionPoints) {
                if (point.order.size() <= this.mainConnectionPoint.order.size()) continue;
                point.reverseStep();
            }
        }
    }

    public boolean isDirtyConnection(MazeRoom dest, MazeRoom source, C c) {
        return true;
    }

    private /* synthetic */ boolean lambda$canPlace$78(Set roomsFromBoth, MorphingMazeComponent maze, ShiftedMazeComponent component, Predicate isDirty, ConnectionPoint point) {
        return this.stepsReached.containsKey((Object)point) || ReachabilityStrategy.canReach(roomsFromBoth, this.traversalAbilities, Arrays.asList(maze, component), point.traversed.stream().filter(isDirty).map(MazePassage::getDest).collect(Collectors.toSet()), this.mainConnectionPoint.traversed.stream().filter(isDirty).map(MazePassage::getDest).collect(Collectors.toSet()), point.traversed, this.confiner, this.traverser);
    }

    private /* synthetic */ boolean lambda$canPlace$77(Set roomsFromBoth, MazePassage input) {
        return this.confiner.test(input.getSource()) && !roomsFromBoth.contains(input.getSource());
    }

    private static class ConnectionPoint {
        public final Set<MazePassage> traversed = new HashSet<MazePassage>();
        public final List<Set<MazePassage>> order = new ArrayList<Set<MazePassage>>();

        @SafeVarargs
        public ConnectionPoint(Collection<MazePassage> ... points) {
            for (Collection<MazePassage> point : points) {
                this.traversed.addAll(point);
            }
        }

        public void reverseStep() {
            this.traversed.removeAll((Collection)this.order.remove(this.order.size() - 1));
        }
    }
}

