/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze.rules.saved;

import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.rules.TableDataSourceMazeRuleConnect;
import ivorius.reccomplex.scripts.world.WorldScriptMazeGenerator;
import ivorius.reccomplex.structures.generic.maze.Connector;
import ivorius.reccomplex.structures.generic.maze.ConnectorFactory;
import ivorius.reccomplex.structures.generic.maze.MazeComponentStructure;
import ivorius.reccomplex.structures.generic.maze.SavedMazePath;
import ivorius.reccomplex.structures.generic.maze.SavedMazePathConnection;
import ivorius.reccomplex.structures.generic.maze.rules.LimitAABBStrategy;
import ivorius.reccomplex.structures.generic.maze.rules.MazeRule;
import ivorius.reccomplex.structures.generic.maze.rules.ReachabilityStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class MazeRuleConnect
extends MazeRule {
    public final List<SavedMazePath> start = new ArrayList<SavedMazePath>();
    public final List<SavedMazePath> end = new ArrayList<SavedMazePath>();
    public boolean preventConnection = false;

    protected static Set<MazePassage> buildPaths(List<SavedMazePath> start) {
        return start.stream().map(SavedMazePath::build).collect(Collectors.toSet());
    }

    @Override
    public String displayString() {
        return String.format("%s %s->%s %s", this.summarize(this.start), this.preventConnection ? EnumChatFormatting.GOLD : EnumChatFormatting.GREEN, EnumChatFormatting.RESET, this.summarize(this.end));
    }

    private String summarize(List<SavedMazePath> list) {
        return list.size() == 0 ? "?" : String.format("%s%s", list.get(0).getSourceRoom().toString(), list.size() > 1 ? "..." : "");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate, List<SavedMazePathConnection> expected, int[] boundsLower, int[] boundsHigher) {
        return new TableDataSourceMazeRuleConnect(this, delegate, navigator, boundsLower, boundsHigher);
    }

    public ReachabilityStrategy<MazeComponentStructure<Connector>, Connector> build(WorldScriptMazeGenerator script, Set<Connector> blockedConnections, ConnectorFactory connectorFactory, Collection<? extends MazeComponent<Connector>> components) {
        if (this.start.size() > 0 && this.end.size() > 0) {
            List<Collection<MazePassage>> points = Arrays.asList(MazeRuleConnect.buildPaths(this.start), MazeRuleConnect.buildPaths(this.end));
            Predicate<Connector> traverser = ReachabilityStrategy.connectorTraverser(blockedConnections);
            LimitAABBStrategy confiner = new LimitAABBStrategy(script.rooms.boundsSize());
            return this.preventConnection ? ReachabilityStrategy.preventConnection(points, traverser, confiner) : ReachabilityStrategy.connect(points, traverser, confiner, ReachabilityStrategy.compileAbilities(components, traverser));
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.start.clear();
        this.start.addAll(NBTCompoundObjects.readListFrom((NBTTagCompound)compound, (String)"start", SavedMazePath.class));
        this.end.clear();
        this.end.addAll(NBTCompoundObjects.readListFrom((NBTTagCompound)compound, (String)"end", SavedMazePath.class));
        this.preventConnection = compound.func_74767_n("preventConnection");
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTCompoundObjects.writeListTo((NBTTagCompound)compound, (String)"start", this.start);
        NBTCompoundObjects.writeListTo((NBTTagCompound)compound, (String)"end", this.end);
        compound.func_74757_a("preventConnection", this.preventConnection);
    }
}

