/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze.rules.saved;

import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePredicate;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.rules.TableDataSourceMazeRuleConnectAll;
import ivorius.reccomplex.scripts.world.WorldScriptMazeGenerator;
import ivorius.reccomplex.structures.generic.maze.Connector;
import ivorius.reccomplex.structures.generic.maze.ConnectorFactory;
import ivorius.reccomplex.structures.generic.maze.MazeComponentStructure;
import ivorius.reccomplex.structures.generic.maze.SavedMazePath;
import ivorius.reccomplex.structures.generic.maze.SavedMazePathConnection;
import ivorius.reccomplex.structures.generic.maze.rules.LimitAABBStrategy;
import ivorius.reccomplex.structures.generic.maze.rules.MazeRule;
import ivorius.reccomplex.structures.generic.maze.rules.ReachabilityStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class MazeRuleConnectAll
extends MazeRule {
    public final List<SavedMazePath> exits = new ArrayList<SavedMazePath>();
    public boolean additive = false;
    public boolean preventConnection = false;

    public static Stream<SavedMazePath> getPaths(List<SavedMazePath> paths, List<SavedMazePathConnection> omega, Set<Connector> blockedConnections, ConnectorFactory connectorFactory) {
        return omega.stream().filter(e -> !blockedConnections.contains(e.connector.toConnector(connectorFactory))).map(e -> e.path).filter(e -> !paths.contains(e));
    }

    @Override
    public String displayString() {
        return String.format("%s%s %s", this.preventConnection ? EnumChatFormatting.GOLD + "Split" : EnumChatFormatting.GREEN + "Connect", EnumChatFormatting.RESET, !this.additive && this.exits.size() == 0 ? "All" : "Some");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate, List<SavedMazePathConnection> expected, int[] boundsLower, int[] boundsHigher) {
        return new TableDataSourceMazeRuleConnectAll(this, delegate, navigator, expected, boundsLower, boundsHigher);
    }

    @Override
    public MazePredicate<MazeComponentStructure<Connector>, Connector> build(WorldScriptMazeGenerator script, Set<Connector> blockedConnections, ConnectorFactory connectorFactory, Collection<? extends MazeComponent<Connector>> components) {
        List<SavedMazePath> paths;
        List<SavedMazePath> list = paths = this.additive ? this.exits : MazeRuleConnectAll.getPaths(this.exits, script.exitPaths, blockedConnections, connectorFactory).collect(Collectors.toList());
        if (paths.size() > 1) {
            List<Collection<MazePassage>> points = paths.stream().map(SavedMazePath::build).map(Collections::singleton).collect(Collectors.toList());
            Predicate<Connector> traverser = ReachabilityStrategy.connectorTraverser(blockedConnections);
            LimitAABBStrategy confiner = new LimitAABBStrategy(script.rooms.boundsSize());
            return this.preventConnection ? ReachabilityStrategy.preventConnection(points, traverser, confiner) : ReachabilityStrategy.connect(points, traverser, confiner, ReachabilityStrategy.compileAbilities(components, traverser));
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.additive = compound.func_74767_n("additive");
        this.exits.clear();
        this.exits.addAll(NBTCompoundObjects.readListFrom((NBTTagCompound)compound, (String)"exits", SavedMazePath.class));
        this.preventConnection = compound.func_74767_n("preventConnection");
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a("additive", this.additive);
        NBTCompoundObjects.writeListTo((NBTTagCompound)compound, (String)"exits", this.exits);
        compound.func_74757_a("preventConnection", this.preventConnection);
    }
}

