/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.transformers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.blocks.RCBlocks;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTNaturalAir;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.matchers.BlockMatcher;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.structures.generic.transformers.TransformerReplace;
import ivorius.reccomplex.structures.generic.transformers.TransformerSingleBlock;
import ivorius.reccomplex.utils.BlockStates;
import ivorius.reccomplex.utils.IBlockState;
import ivorius.reccomplex.utils.NBTNone;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TransformerNaturalAir
extends TransformerSingleBlock<NBTNone> {
    public static final double DEFAULT_NATURAL_EXPANSION_DISTANCE = 4.0;
    public static final double DEFAULT_NATURAL_EXPANSION_RANDOMIZATION = 10.0;
    public BlockMatcher sourceMatcher;
    public double naturalExpansionDistance;
    public double naturalExpansionRandomization;

    public TransformerNaturalAir() {
        this(BlockMatcher.of((MCRegistry)RecurrentComplex.specialRegistry, RCBlocks.genericSpace, 1), 4.0, 10.0);
    }

    public TransformerNaturalAir(String sourceMatcherExpression, double naturalExpansionDistance, double naturalExpansionRandomization) {
        this.sourceMatcher = new BlockMatcher(RecurrentComplex.specialRegistry, sourceMatcherExpression);
        this.naturalExpansionDistance = naturalExpansionDistance;
        this.naturalExpansionRandomization = naturalExpansionRandomization;
    }

    @Override
    public boolean matches(NBTNone instanceData, IBlockState state) {
        return this.sourceMatcher.apply(state);
    }

    @Override
    public void transformBlock(NBTNone instanceData, Transformer.Phase phase, StructureSpawnContext context, BlockCoord coord, IBlockState sourceState) {
        World world = context.world;
        Random random = context.random;
        BiomeGenBase biome = world.func_72807_a(coord.x, coord.z);
        Block topBlock = biome.field_76752_A != null ? biome.field_76752_A : Blocks.field_150350_a;
        Block fillerBlock = biome.field_76753_B != null ? biome.field_76753_B : Blocks.field_150350_a;
        coord = coord.subtract(0, 4, 0);
        ArrayList currentList = new ArrayList();
        ArrayList<int[]> nextList = new ArrayList<int[]>();
        nextList.add(new int[]{coord.x, coord.z});
        int worldHeight = world.func_72800_K();
        for (int currentY = coord.y; nextList.size() > 0 && currentY < worldHeight; ++currentY) {
            ArrayList cachedList = currentList;
            currentList = nextList;
            nextList = cachedList;
            while (currentList.size() > 0) {
                boolean replaceable;
                int currentZ;
                int[] currentPos = (int[])currentList.remove(0);
                int currentX = currentPos[0];
                Block curBlock = world.func_147439_a(currentX, currentY, currentZ = currentPos[1]);
                boolean isFoliage = curBlock.isFoliage((IBlockAccess)world, currentX, currentY, currentZ) || curBlock.func_149688_o() == Material.field_151584_j || curBlock.func_149688_o() == Material.field_151585_k || curBlock.func_149688_o() == Material.field_151575_d;
                boolean isCommon = curBlock == Blocks.field_150348_b || curBlock == Blocks.field_150346_d || curBlock == Blocks.field_150354_m || curBlock == Blocks.field_150406_ce || curBlock == Blocks.field_150351_n;
                boolean bl = replaceable = currentY == coord.y || curBlock == topBlock || curBlock == fillerBlock || curBlock.isReplaceable((IBlockAccess)world, currentX, currentY, currentZ) || isCommon || isFoliage;
                if (replaceable) {
                    context.setBlock(currentX, currentY, currentZ, BlockStates.defaultState(Blocks.field_150350_a));
                }
                if (!replaceable && curBlock.func_149688_o() != Material.field_151579_a) continue;
                double distToOrigSQ = IvVecMathHelper.distanceSQ((double[])new double[]{coord.x, coord.y, coord.z}, (double[])new double[]{currentX, currentY, currentZ});
                double add = (random.nextDouble() - random.nextDouble()) * this.naturalExpansionRandomization;
                double d = add < 0.0 ? -(add * add) : add * add;
                if (!((distToOrigSQ += d) < this.naturalExpansionDistance * this.naturalExpansionDistance)) continue;
                this.addIfNew(nextList, currentX, currentZ);
                this.addIfNew(nextList, currentX - 1, currentZ);
                this.addIfNew(nextList, currentX + 1, currentZ);
                this.addIfNew(nextList, currentX, currentZ - 1);
                this.addIfNew(nextList, currentX, currentZ + 1);
            }
        }
    }

    private void addIfNew(List<int[]> list, int ... object) {
        if (!list.contains(object)) {
            list.add(object);
        }
    }

    @Override
    public String getDisplayString() {
        return "Natural Air: " + this.sourceMatcher.getDisplayString();
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTNaturalAir(this);
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    @Override
    public boolean generatesInPhase(NBTNone instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.BEFORE;
    }

    public static class Serializer
    implements JsonDeserializer<TransformerNaturalAir>,
    JsonSerializer<TransformerNaturalAir> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public TransformerNaturalAir deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "transformerNatural");
            String expression = TransformerReplace.Serializer.readLegacyMatcher(jsonObject, "source", "sourceMetadata");
            if (expression == null) {
                expression = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "sourceExpression", "");
            }
            double naturalExpansionDistance = JsonUtils.getJsonObjectDoubleFieldValueOrDefault(jsonObject, "naturalExpansionDistance", 4.0);
            double naturalExpansionRandomization = JsonUtils.getJsonObjectDoubleFieldValueOrDefault(jsonObject, "naturalExpansionRandomization", 10.0);
            return new TransformerNaturalAir(expression, naturalExpansionDistance, naturalExpansionRandomization);
        }

        public JsonElement serialize(TransformerNaturalAir transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("sourceExpression", transformer.sourceMatcher.getExpression());
            jsonObject.addProperty("naturalExpansionDistance", (Number)transformer.naturalExpansionDistance);
            jsonObject.addProperty("naturalExpansionRandomization", (Number)transformer.naturalExpansionRandomization);
            return jsonObject;
        }
    }
}

