/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.transformers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTReplaceAll;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.WeightedBlockState;
import ivorius.reccomplex.structures.generic.matchers.BlockMatcher;
import ivorius.reccomplex.structures.generic.presets.WeightedBlockStatePresets;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.structures.generic.transformers.TransformerReplace;
import ivorius.reccomplex.structures.generic.transformers.TransformerSingleBlock;
import ivorius.reccomplex.utils.BlockStates;
import ivorius.reccomplex.utils.IBlockState;
import ivorius.reccomplex.utils.NBTStorable;
import ivorius.reccomplex.utils.PresettedList;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TransformerReplaceAll
extends TransformerSingleBlock<InstanceData> {
    public final PresettedList<WeightedBlockState> destination = new PresettedList<WeightedBlockState>(WeightedBlockStatePresets.instance(), null);
    public BlockMatcher sourceMatcher;

    public TransformerReplaceAll() {
        this(BlockMatcher.of((MCRegistry)RecurrentComplex.specialRegistry, Blocks.field_150325_L, new IntegerRange(0, 15)));
        this.destination.setToDefault();
    }

    public TransformerReplaceAll(String sourceExpression) {
        this.sourceMatcher = new BlockMatcher(RecurrentComplex.specialRegistry, sourceExpression);
    }

    public TransformerReplaceAll replaceWith(WeightedBlockState ... states) {
        this.destination.setContents(Arrays.asList(states));
        return this;
    }

    @Override
    public boolean matches(InstanceData instanceData, IBlockState state) {
        return this.sourceMatcher.apply(state);
    }

    @Override
    public void transformBlock(InstanceData instanceData, Transformer.Phase phase, StructureSpawnContext context, BlockCoord coord, IBlockState sourceState) {
        TransformerReplace.setBlockWith(context, coord, context.world, instanceData.blockState, instanceData.tileEntityInfo);
    }

    @Override
    public String getDisplayString() {
        return "Replace All: " + this.sourceMatcher.getDisplayString();
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTReplaceAll(this, navigator, delegate);
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context) {
        WeightedBlockState blockState = this.destination.list.size() > 0 ? (WeightedBlockState)WeightedSelector.selectItem((Random)context.random, this.destination.list) : new WeightedBlockState(null, BlockStates.defaultState(Blocks.field_150350_a), "");
        NBTTagCompound tileEntityInfo = blockState.tileEntityInfo.trim().length() > 0 && blockState.state.getBlock().hasTileEntity(BlockStates.getMetadata(blockState.state)) ? TransformerReplace.tryParse(blockState.tileEntityInfo) : null;
        return new InstanceData(blockState, tileEntityInfo);
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new InstanceData(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound());
    }

    @Override
    public boolean generatesInPhase(InstanceData instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.BEFORE;
    }

    public static class Serializer
    implements JsonDeserializer<TransformerReplaceAll>,
    JsonSerializer<TransformerReplaceAll> {
        private MCRegistry registry;
        private Gson gson;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
            this.gson = new GsonBuilder().registerTypeAdapter(WeightedBlockState.class, (Object)new WeightedBlockState.Serializer(registry)).create();
        }

        public TransformerReplaceAll deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "transformerReplace");
            String expression = TransformerReplace.Serializer.readLegacyMatcher(jsonObject, "source", "sourceMetadata");
            if (expression == null) {
                expression = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "sourceExpression", "");
            }
            TransformerReplaceAll transformer = new TransformerReplaceAll(expression);
            if (!transformer.destination.setPreset(JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "destinationPreset", null)) && jsonObject.has("destination")) {
                Collections.addAll(transformer.destination.list, (Object[])this.gson.fromJson(jsonObject.get("destination"), WeightedBlockState[].class));
            }
            if (jsonObject.has("dest")) {
                String destBlock = JsonUtils.getJsonObjectStringFieldValue(jsonObject, "dest");
                Block dest = this.registry.blockFromID(destBlock);
                byte[] destMeta = (byte[])context.deserialize(jsonObject.get("destMetadata"), byte[].class);
                transformer.destination.setToCustom();
                for (byte b : destMeta) {
                    transformer.destination.list.add(new WeightedBlockState(null, BlockStates.fromMetadata(dest, b), ""));
                }
            }
            return transformer;
        }

        public JsonElement serialize(TransformerReplaceAll transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("sourceExpression", transformer.sourceMatcher.getExpression());
            if (transformer.destination.getPreset() != null) {
                jsonObject.addProperty("destinationPreset", transformer.destination.getPreset());
            }
            jsonObject.add("destination", this.gson.toJsonTree(transformer.destination.list));
            return jsonObject;
        }
    }

    public static class InstanceData
    implements NBTStorable {
        public WeightedBlockState blockState;
        public NBTTagCompound tileEntityInfo;

        public InstanceData(WeightedBlockState blockState, NBTTagCompound tileEntityInfo) {
            this.blockState = blockState;
            this.tileEntityInfo = tileEntityInfo;
        }

        public InstanceData(NBTTagCompound compound) {
            this.blockState = new WeightedBlockState(RecurrentComplex.specialRegistry, compound.func_74775_l("blockState"));
            this.tileEntityInfo = compound.func_150297_b("tileEntityInfo", 10) ? (NBTTagCompound)compound.func_74775_l("tileEntityInfo").func_74737_b() : null;
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("blockState", (NBTBase)this.blockState.writeToNBT(RecurrentComplex.specialRegistry));
            if (this.tileEntityInfo != null) {
                compound.func_74782_a("tileEntityInfo", this.tileEntityInfo.func_74737_b());
            }
            return compound;
        }
    }
}

