/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.utils.FMLRemapper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;

public class MCRegistrySpecial
implements MCRegistry {
    public static final String HIDDEN_ITEM_TAG = "RC_HIDDEN_ITEM";
    private static final Item DUMMY_ITEM = Items.field_151044_h;
    protected final BiMap<String, Item> itemMap = HashBiMap.create();
    protected final BiMap<String, Block> blockMap = HashBiMap.create();
    protected final Map<String, Class<? extends TileEntity>> tileEntityMap = new HashMap<String, Class<? extends TileEntity>>();
    protected MCRegistry parent;
    protected FMLRemapper remapper;
    protected ItemHidingRegistry itemHidingRegistry = new ItemHidingRegistry();

    public MCRegistrySpecial(MCRegistry parent, FMLRemapper remapper) {
        this.parent = parent;
        this.remapper = remapper;
    }

    public void register(String id, Item item) {
        this.itemMap.put((Object)id, (Object)item);
    }

    public void register(String id, Block block) {
        this.blockMap.put((Object)id, (Object)block);
    }

    public void register(String id, Class<? extends TileEntity> tileEntity) {
        this.tileEntityMap.put(id, tileEntity);
    }

    public ItemHidingRegistry itemHidingMode() {
        return this.itemHidingRegistry;
    }

    public Item itemFromID(String itemID) {
        Item item = (Item)this.itemMap.get((Object)(itemID = this.remapper.mapItem(itemID)));
        return item != null ? item : this.parent.itemFromID(itemID);
    }

    public String idFromItem(Item item) {
        String id = (String)this.itemMap.inverse().get((Object)item);
        return id != null ? id : this.parent.idFromItem(item);
    }

    public void modifyItemStackCompound(NBTTagCompound compound, String itemID) {
        this.parent.modifyItemStackCompound(compound, itemID);
    }

    public boolean isSafe(Item item) {
        return this.itemMap.isEmpty() || !this.itemMap.containsValue((Object)item);
    }

    public boolean isItemSafe(String itemID) {
        return this.itemMap.isEmpty() || !this.itemMap.containsKey((Object)itemID);
    }

    public Block blockFromID(String blockID) {
        Block block = (Block)this.blockMap.get((Object)(blockID = this.remapper.mapBlock(blockID)));
        return block != null ? block : this.parent.blockFromID(blockID);
    }

    public String idFromBlock(Block block) {
        String id = (String)this.blockMap.inverse().get((Object)block);
        return id != null ? id : this.parent.idFromBlock(block);
    }

    public boolean isSafe(Block block) {
        return this.blockMap.isEmpty() || !this.blockMap.containsValue((Object)block);
    }

    public boolean isBlockSafe(String blockID) {
        return this.blockMap.isEmpty() || !this.blockMap.containsKey((Object)blockID);
    }

    public TileEntity loadTileEntity(NBTTagCompound compound) {
        try {
            Class<? extends TileEntity> oclass = this.tileEntityMap.get(this.remapper.mapTileEntity(compound.func_74779_i("id")));
            if (oclass != null) {
                TileEntity tileEntity = oclass.newInstance();
                tileEntity.func_145839_a(compound);
                return tileEntity;
            }
        }
        catch (Throwable e) {
            RecurrentComplex.logger.error("Error loading special TileEntity", e);
        }
        return this.parent.loadTileEntity(compound);
    }

    public boolean isSafe(TileEntity tileEntity) {
        return this.tileEntityMap.isEmpty() || !this.tileEntityMap.containsValue(tileEntity.getClass());
    }

    public class ItemHidingRegistry
    implements MCRegistry {
        public Item itemFromID(String itemID) {
            return !MCRegistrySpecial.this.isItemSafe(itemID = MCRegistrySpecial.this.remapper.mapItem(itemID)) ? DUMMY_ITEM : MCRegistrySpecial.this.parent.itemFromID(itemID);
        }

        public String idFromItem(Item item) {
            return MCRegistrySpecial.this.idFromItem(item);
        }

        public String containedItemID(ItemStack stack) {
            return MCRegistrySpecial.this.idFromItem(this.containedItem(stack));
        }

        public Item containedItem(ItemStack stack) {
            Item hidden = this.hiddenItem(stack);
            return hidden != null ? hidden : stack.func_77973_b();
        }

        @Nullable
        public Item hiddenItem(ItemStack stack) {
            return stack.func_77942_o() && stack.func_77978_p().func_150297_b(MCRegistrySpecial.HIDDEN_ITEM_TAG, 8) ? MCRegistrySpecial.this.itemFromID(stack.func_77978_p().func_74779_i(MCRegistrySpecial.HIDDEN_ITEM_TAG)) : null;
        }

        public ItemStack constructItemStack(String itemID, int stackSize, int metadata) {
            return this.constructItemStack(MCRegistrySpecial.this.itemFromID(itemID), stackSize, metadata);
        }

        public ItemStack constructItemStack(Item item, int stackSize, int metadata) {
            String hiddenID = (String)MCRegistrySpecial.this.itemMap.inverse().get((Object)item);
            if (hiddenID != null) {
                ItemStack stack = new ItemStack(DUMMY_ITEM, stackSize, metadata);
                stack.func_77983_a(MCRegistrySpecial.HIDDEN_ITEM_TAG, (NBTBase)new NBTTagString(hiddenID));
                return stack;
            }
            return new ItemStack(item, stackSize, metadata);
        }

        public void modifyItemStackCompound(NBTTagCompound compound, String itemID) {
            Item item = (Item)MCRegistrySpecial.this.itemMap.get((Object)MCRegistrySpecial.this.remapper.mapItem(itemID));
            if (item != null) {
                NBTTagCompound stackNBT;
                if (compound.func_150297_b("tag", 10)) {
                    stackNBT = compound.func_74775_l("tag");
                } else {
                    stackNBT = new NBTTagCompound();
                    compound.func_74782_a("tag", (NBTBase)stackNBT);
                }
                stackNBT.func_74778_a(MCRegistrySpecial.HIDDEN_ITEM_TAG, itemID);
            }
        }

        public Block blockFromID(String blockID) {
            return MCRegistrySpecial.this.blockFromID(blockID);
        }

        public String idFromBlock(Block block) {
            return MCRegistrySpecial.this.idFromBlock(block);
        }

        public TileEntity loadTileEntity(NBTTagCompound compound) {
            return MCRegistrySpecial.this.loadTileEntity(compound);
        }
    }
}

