/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.schematics;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.reccomplex.structures.schematics.SchematicMapping;
import ivorius.reccomplex.utils.BlockStates;
import ivorius.reccomplex.utils.IBlockState;
import ivorius.reccomplex.utils.IvStreams;
import ivorius.reccomplex.utils.RCAccessorEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SchematicFile {
    public final List<NBTTagCompound> entityCompounds = new ArrayList<NBTTagCompound>();
    public final List<NBTTagCompound> tileEntityCompounds = new ArrayList<NBTTagCompound>();
    public short width;
    public short height;
    public short length;
    public Short weOriginX;
    public Short weOriginY;
    public Short weOriginZ;
    public IBlockState[] blockStates;

    public SchematicFile() {
    }

    public SchematicFile(short width, short height, short length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.blockStates = new IBlockState[width * height * length];
    }

    public SchematicFile(NBTTagCompound tagCompound) throws UnsupportedSchematicFormatException {
        String materials = tagCompound.func_74779_i("Materials");
        if (!materials.equals("Alpha")) {
            throw new UnsupportedSchematicFormatException(materials);
        }
        this.width = tagCompound.func_74765_d("Width");
        this.height = tagCompound.func_74765_d("Height");
        this.length = tagCompound.func_74765_d("Length");
        if (tagCompound.func_150297_b("WEOriginX", 2)) {
            this.weOriginX = tagCompound.func_74765_d("WEOriginX");
        }
        if (tagCompound.func_150297_b("WEOriginY", 2)) {
            this.weOriginY = tagCompound.func_74765_d("WEOriginY");
        }
        if (tagCompound.func_150297_b("WEOriginZ", 2)) {
            this.weOriginZ = tagCompound.func_74765_d("WEOriginZ");
        }
        byte[] metadatas = tagCompound.func_74770_j("Data");
        byte[] blockIDs = tagCompound.func_74770_j("Blocks");
        byte[] addBlocks = tagCompound.func_74770_j("AddBlocks");
        SchematicMapping schematicMapping = tagCompound.func_150297_b("SchematicaMapping", 10) ? new SchematicMapping(tagCompound.func_74775_l("SchematicaMapping")) : null;
        this.blockStates = new IBlockState[blockIDs.length];
        for (int i = 0; i < blockIDs.length; ++i) {
            int blockID = blockIDs[i] & 0xFF;
            if (addBlocks.length >= (blockIDs.length + 1) / 2) {
                boolean lowerNybble = (i & 1) == 0;
                blockID |= lowerNybble ? (addBlocks[i >> 1] & 0xF) << 8 : (addBlocks[i >> 1] & 0xF0) << 4;
            }
            Block block = schematicMapping != null ? schematicMapping.blockFromID(blockID) : Block.func_149729_e((int)blockID);
            this.blockStates[i] = BlockStates.defaultState(block);
        }
        NBTTagList entities = tagCompound.func_150295_c("Entities", 10);
        for (int i = 0; i < entities.func_74745_c(); ++i) {
            this.entityCompounds.add(entities.func_150305_b(i));
        }
        NBTTagList tileEntities = tagCompound.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tileEntities.func_74745_c(); ++i) {
            this.tileEntityCompounds.add(tileEntities.func_150305_b(i));
        }
    }

    public int getBlockIndex(int x, int y, int z) {
        return x + (y * this.length + z) * this.width;
    }

    public IBlockState getBlockState(BlockCoord coord) {
        if (coord.x < 0 || coord.y < 0 || coord.z < 0 || coord.x >= this.width || coord.y >= this.height || coord.z >= this.length) {
            return BlockStates.defaultState(Blocks.field_150350_a);
        }
        return this.blockStates[this.getBlockIndex(coord.x, coord.y, coord.z)];
    }

    public boolean shouldRenderSide(BlockCoord coord, ForgeDirection side) {
        BlockCoord sideCoord = coord.add(side.offsetX, side.offsetY, side.offsetZ);
        IBlockState blockState = this.getBlockState(sideCoord);
        return !blockState.getBlock().func_149662_c();
    }

    public void generate(World world, int x, int y, int z) {
        HashMap<BlockCoord, TileEntity> tileEntities = new HashMap<BlockCoord, TileEntity>();
        for (NBTTagCompound tileTagCompound : this.tileEntityCompounds) {
            TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)tileTagCompound);
            if (tileEntity == null) continue;
            tileEntities.put(new BlockCoord(tileEntity), tileEntity);
        }
        BlockArea blockArea = BlockArea.areaFromSize((BlockCoord)new BlockCoord(0, 0, 0), (int[])new int[]{this.width, this.height, this.length});
        for (int pass = 0; pass < 2; ++pass) {
            for (BlockCoord srcCoord : blockArea) {
                int index = this.getBlockIndex(srcCoord.x, srcCoord.y, srcCoord.z);
                IBlockState blockState = this.blockStates[index];
                if (blockState == null || this.getPass(blockState) != pass) continue;
                BlockCoord worldPos = srcCoord.add(x, y, z);
                world.func_147465_d(worldPos.x, worldPos.y, worldPos.z, blockState.getBlock(), BlockStates.getMetadata(blockState), 3);
                TileEntity tileEntity = (TileEntity)tileEntities.get(srcCoord);
                if (tileEntity == null) continue;
                world.func_72921_c(worldPos.x, worldPos.y, worldPos.z, BlockStates.getMetadata(blockState), 2);
                IvWorldData.setTileEntityPosForGeneration((TileEntity)tileEntity, (BlockCoord)worldPos);
                world.func_147455_a(worldPos.x, worldPos.y, worldPos.z, tileEntity);
                tileEntity.func_145836_u();
            }
        }
        for (NBTTagCompound entityCompound : this.entityCompounds) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)entityCompound, (World)world);
            if (entity == null) continue;
            RCAccessorEntity.setEntityUniqueID(entity, UUID.randomUUID());
            IvWorldData.moveEntityForGeneration((Entity)entity, (BlockCoord)new BlockCoord(x, y, z));
            world.func_72838_d(entity);
        }
    }

    private int getPass(IBlockState blockState) {
        return blockState.getBlock().func_149721_r() || blockState.getBlock().func_149688_o() == Material.field_151579_a ? 0 : 1;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("Materials", "Alpha");
        tagCompound.func_74777_a("Width", this.width);
        tagCompound.func_74777_a("Height", this.height);
        tagCompound.func_74777_a("Length", this.length);
        if (this.weOriginX != null) {
            tagCompound.func_74777_a("WEOriginX", this.weOriginX.shortValue());
        }
        if (this.weOriginY != null) {
            tagCompound.func_74777_a("WEOriginY", this.weOriginY.shortValue());
        }
        if (this.weOriginZ != null) {
            tagCompound.func_74777_a("WEOriginZ", this.weOriginZ.shortValue());
        }
        tagCompound.func_74773_a("Data", IvStreams.toByteArray(Stream.of(this.blockStates).mapToInt(BlockStates::getMetadata)));
        byte[] blockIDs = new byte[this.blockStates.length];
        byte[] addBlocks = new byte[(this.blockStates.length + 1) / 2];
        SchematicMapping schematicMapping = new SchematicMapping();
        for (int i = 0; i < this.blockStates.length; ++i) {
            Block block = this.blockStates[i].getBlock();
            int blockID = this.getBlockID(block);
            schematicMapping.putBlock(blockID, block);
            blockIDs[i] = (byte)(blockID & 0xFF);
            boolean lowerNybble = (i & 1) == 0;
            int n = i >> 1;
            addBlocks[n] = (byte)(addBlocks[n] | (lowerNybble ? (byte)(blockID >> 8 & 0xF) : (byte)(blockID >> 4 & 0xF0)));
        }
        tagCompound.func_74773_a("Blocks", blockIDs);
        tagCompound.func_74773_a("AddBlocks", addBlocks);
        tagCompound.func_74782_a("SchematicaMapping", (NBTBase)schematicMapping.writeToNBT());
        NBTTagList entities = new NBTTagList();
        this.entityCompounds.forEach(arg_0 -> ((NBTTagList)entities).func_74742_a(arg_0));
        tagCompound.func_74782_a("Entities", (NBTBase)entities);
        NBTTagList tileEntitites = new NBTTagList();
        this.tileEntityCompounds.forEach(arg_0 -> ((NBTTagList)entities).func_74742_a(arg_0));
        tagCompound.func_74782_a("TileEntities", (NBTBase)tileEntitites);
    }

    private int getBlockID(Block block) {
        return Block.field_149771_c.func_148757_b((Object)block);
    }

    public static class UnsupportedSchematicFormatException
    extends Exception {
        public final String format;

        public UnsupportedSchematicFormatException(String format) {
            this.format = format;
        }
    }
}

