/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ListPresets<T> {
    protected Gson gson = this.createGson();
    protected final Map<String, List<T>> presets = new HashMap<String, List<T>>();
    @Nullable
    protected String defaultType;

    public void register(@Nonnull String type, @Nonnull List<T> values) {
        this.presets.put(type, Lists.newArrayList(values));
    }

    @SafeVarargs
    public final void register(@Nonnull String type, T ... values) {
        this.presets.put(type, Arrays.asList(values));
    }

    public void setDefault(@Nonnull String type) {
        this.defaultType = type;
    }

    @Nullable
    public String defaultType() {
        return this.defaultType;
    }

    @Nullable
    public List<T> preset(String type) {
        List<T> list = this.presets.get(type);
        if (list != null) {
            return Arrays.asList((Object[])this.gson.fromJson(this.gson.toJsonTree(list), this.getType()));
        }
        return null;
    }

    public Collection<String> allTypes() {
        return this.presets.keySet();
    }

    public boolean has(String type) {
        return this.presets.containsKey(type);
    }

    protected abstract Gson createGson();

    protected abstract Class<T[]> getType();
}

