/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.inventory;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.json.NbtToJson;
import ivorius.reccomplex.utils.CustomizableMap;
import ivorius.reccomplex.worldgen.inventory.GenericItemCollection;
import ivorius.reccomplex.worldgen.inventory.InventoryLoadException;
import ivorius.reccomplex.worldgen.inventory.WeightedItemCollection;
import ivorius.reccomplex.worldgen.inventory.WeightedItemCollectionRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GenericItemCollectionRegistry {
    public static final GenericItemCollectionRegistry INSTANCE = new GenericItemCollectionRegistry();
    private CustomizableMap<String, GenericItemCollection.Component> allComponents = new CustomizableMap();
    private CustomizableMap<String, ComponentData> componentData = new CustomizableMap();
    private Set<String> generatingComponents = new HashSet<String>();
    private Gson gson = GenericItemCollectionRegistry.createGson();

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(GenericItemCollection.Component.class, (Object)new GenericItemCollection.Component.Serializer());
        NbtToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    public boolean register(GenericItemCollection.Component component, String key, String domain, boolean generates, boolean custom) {
        if (RCConfig.shouldInventoryGeneratorLoad(key, domain)) {
            String baseString = this.allComponents.put(key, component, custom) != null ? "Replaced inventory generation component '%s'" : "Registered generation component '%s'";
            RecurrentComplex.logger.info(String.format(baseString, key));
            this.componentData.put(key, new ComponentData(!generates, domain), custom);
            this.clearCaches();
            return true;
        }
        return false;
    }

    public GenericItemCollection.Component component(String key) {
        return this.allComponents.getMap().get(key);
    }

    public Set<String> allComponentKeys() {
        return Collections.unmodifiableSet(this.allComponents.getMap().keySet());
    }

    public void unregister(String key, boolean custom) {
        this.componentData.remove(key, custom);
        this.allComponents.remove(key, custom);
        this.clearCaches();
    }

    public void clearCustom() {
        this.componentData.clearCustom();
        this.allComponents.clearCustom();
    }

    public boolean isLoaded(String key) {
        return this.allComponents.getMap().containsKey(key);
    }

    public boolean isActive(String key) {
        return this.generatingComponents.contains(key);
    }

    public String createJSONFromComponent(GenericItemCollection.Component inventoryGenerator) {
        return this.gson.toJson((Object)inventoryGenerator, GenericItemCollection.Component.class);
    }

    public GenericItemCollection.Component createComponentFromJSON(String json) throws InventoryLoadException {
        try {
            return (GenericItemCollection.Component)((Object)this.gson.fromJson(json, GenericItemCollection.Component.class));
        }
        catch (JsonSyntaxException e) {
            throw new InventoryLoadException(e);
        }
    }

    private void clearCaches() {
        WeightedItemCollection collection;
        GenericItemCollection.Component component;
        HashSet<String> newGeneratingComponents = new HashSet<String>();
        for (Map.Entry<String, GenericItemCollection.Component> entry : this.allComponents.getMap().entrySet()) {
            component = entry.getValue();
            String key = entry.getKey();
            ComponentData structureData = this.componentData.getMap().get(key);
            if (structureData.disabled || !RCConfig.shouldInventoryGeneratorGenerate(key, structureData.domain) || !component.areDependenciesResolved()) continue;
            newGeneratingComponents.add(key);
        }
        for (String key : Sets.difference(newGeneratingComponents, this.generatingComponents)) {
            component = this.allComponents.getMap().get(key);
            collection = this.registerGetGenericItemCollection(component.inventoryGeneratorID);
            collection.components.add(component);
        }
        for (String key : Sets.difference(this.generatingComponents, newGeneratingComponents)) {
            component = this.allComponents.getMap().get(key);
            collection = WeightedItemCollectionRegistry.itemCollection(component.inventoryGeneratorID);
            if (!(collection instanceof GenericItemCollection)) continue;
            collection.components.remove((Object)component);
            if (collection.components.size() != 0) continue;
            WeightedItemCollectionRegistry.unregister(component.inventoryGeneratorID);
        }
        this.generatingComponents = newGeneratingComponents;
    }

    private GenericItemCollection registerGetGenericItemCollection(String key) {
        WeightedItemCollection collection = WeightedItemCollectionRegistry.itemCollection(key);
        if (collection == null || !(collection instanceof GenericItemCollection)) {
            collection = new GenericItemCollection();
            WeightedItemCollectionRegistry.register(collection, key);
        }
        return (GenericItemCollection)collection;
    }

    private static class ComponentData {
        public boolean disabled;
        public String domain;

        public ComponentData(boolean disabled, String domain) {
            this.disabled = disabled;
            this.domain = domain;
        }
    }
}

