/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.inventory;

import ivorius.ivtoolkit.tools.IvFileHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.FileLoadContext;
import ivorius.reccomplex.files.FileTypeHandler;
import ivorius.reccomplex.worldgen.inventory.GenericItemCollection;
import ivorius.reccomplex.worldgen.inventory.GenericItemCollectionRegistry;
import ivorius.reccomplex.worldgen.inventory.InventoryLoadException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class ItemCollectionSaveHandler
implements FileTypeHandler {
    public static final ItemCollectionSaveHandler INSTANCE = new ItemCollectionSaveHandler();
    public static final String FILE_SUFFIX = "rcig";

    public static GenericItemCollection.Component readInventoryGenerator(Path file) throws IOException, InventoryLoadException {
        return GenericItemCollectionRegistry.INSTANCE.createComponentFromJSON(new String(Files.readAllBytes(file)));
    }

    @Override
    public boolean loadFile(Path path, FileLoadContext context) {
        try {
            String name;
            GenericItemCollection.Component component = ItemCollectionSaveHandler.readInventoryGenerator(path);
            String string = name = context.customID != null ? context.customID : FilenameUtils.getBaseName((String)path.getFileName().toString());
            if (component.inventoryGeneratorID == null || component.inventoryGeneratorID.length() == 0) {
                component.inventoryGeneratorID = name;
            }
            GenericItemCollectionRegistry.INSTANCE.register(component, name, context.domain, context.active, context.custom);
            return true;
        }
        catch (InventoryLoadException | IOException e) {
            RecurrentComplex.logger.warn("Error reading inventory generator", (Throwable)e);
            return false;
        }
    }

    @Override
    public void clearCustomFiles() {
        GenericItemCollectionRegistry.INSTANCE.clearCustom();
    }

    public static boolean saveInventoryGenerator(GenericItemCollection.Component info, String name) {
        File inventoryGeneratorsFile;
        File structuresFile = IvFileHelper.getValidatedFolder((File)RecurrentComplex.proxy.getBaseFolderFile("structures"));
        if (structuresFile != null && (inventoryGeneratorsFile = IvFileHelper.getValidatedFolder((File)structuresFile, (String)"active")) != null) {
            File newFile = new File(inventoryGeneratorsFile, String.format("%s.%s", name, FILE_SUFFIX));
            String json = GenericItemCollectionRegistry.INSTANCE.createJSONFromComponent(info);
            try {
                FileUtils.writeStringToFile((File)newFile, (String)json);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return newFile.exists();
        }
        return false;
    }
}

