/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.villages;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.VanillaStructureGenerationInfo;
import ivorius.reccomplex.worldgen.StructureGenerationData;
import ivorius.reccomplex.worldgen.StructureGenerator;
import ivorius.reccomplex.worldgen.villages.VanillaGenerationClassFactory;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.util.ForgeDirection;

public class GenericVillagePiece
extends StructureVillagePieces.Village {
    public String structureID;
    public String generationID;
    public boolean mirrorX;
    public boolean startedGeneration;
    public NBTBase instanceData;

    public GenericVillagePiece() {
    }

    public GenericVillagePiece(StructureVillagePieces.Start start, int generationDepth) {
        super(start, generationDepth);
    }

    public void setIds(String structureID, String generationID) {
        this.structureID = structureID;
        this.generationID = generationID;
    }

    public void setOrientation(int front, boolean mirrorX, StructureBoundingBox boundingBox) {
        this.field_74885_f = front;
        this.mirrorX = mirrorX;
        this.field_74887_e = boundingBox;
    }

    public void prepare(Random random) {
        StructureGenerationInfo generationInfo;
        StructureInfo structureInfo = StructureRegistry.INSTANCE.getStructure(this.structureID);
        if (structureInfo != null && (generationInfo = structureInfo.generationInfo(this.generationID)) instanceof VanillaStructureGenerationInfo) {
            VanillaStructureGenerationInfo vanillaGenInfo = (VanillaStructureGenerationInfo)generationInfo;
            AxisAlignedTransform2D transform = GenericVillagePiece.getTransform(vanillaGenInfo, this.field_74885_f, this.mirrorX);
            this.instanceData = structureInfo.prepareInstanceData(new StructurePrepareContext(random, transform, this.field_74887_e, false)).writeToNBT();
        }
    }

    public static AxisAlignedTransform2D getTransform(VanillaStructureGenerationInfo vanillaGenInfo, int front, boolean mirrorX) {
        return AxisAlignedTransform2D.from((int)GenericVillagePiece.getRotations(vanillaGenInfo, front, mirrorX), (boolean)mirrorX);
    }

    public static int getRotations(VanillaStructureGenerationInfo vanillaGenInfo, int front, boolean mirrorX) {
        Integer rotations = Directions.getHorizontalClockwiseRotations((ForgeDirection)vanillaGenInfo.front, (ForgeDirection)Directions.getDirectionFromVRotation((int)front), (boolean)mirrorX);
        return rotations == null ? 0 : rotations;
    }

    @Nullable
    public static GenericVillagePiece create(String structureID, String generationID) {
        return VanillaGenerationClassFactory.instance().create(structureID, generationID);
    }

    @Nullable
    public static GenericVillagePiece create(String structureID, String generationID, StructureVillagePieces.Start start, int generationDepth) {
        return VanillaGenerationClassFactory.instance().create(structureID, generationID, start, generationDepth);
    }

    public static boolean canVillageGoDeeperC(StructureBoundingBox box) {
        return GenericVillagePiece.func_74895_a((StructureBoundingBox)box);
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox boundingBox) {
        StructureGenerationInfo generationInfo;
        StructureInfo structureInfo = StructureRegistry.INSTANCE.getStructure(this.structureID);
        if (structureInfo != null && (generationInfo = structureInfo.generationInfo(this.generationID)) instanceof VanillaStructureGenerationInfo) {
            VanillaStructureGenerationInfo vanillaGenInfo = (VanillaStructureGenerationInfo)generationInfo;
            AxisAlignedTransform2D transform = GenericVillagePiece.getTransform(vanillaGenInfo, this.field_74885_f, this.mirrorX);
            BlockCoord structureShift = transform.apply(vanillaGenInfo.spawnShift, new int[]{1, 1, 1});
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(world, boundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b + structureShift.y, 0);
            }
            BlockCoord lowerCoord = new BlockCoord(this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c);
            Object instanceData = structureInfo.loadInstanceData(new StructureLoadContext(transform, boundingBox, false), this.instanceData);
            StructureGenerator.partially(structureInfo, world, random, lowerCoord, transform, boundingBox, this.field_74886_g, this.structureID, instanceData, !this.startedGeneration);
            if (this.structureID != null && !this.startedGeneration) {
                StructureGenerationData.get(world).addCompleteEntry(this.structureID, lowerCoord, transform);
            }
            this.startedGeneration = true;
            return true;
        }
        return false;
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74778_a("RcSId", this.structureID);
        tagCompound.func_74778_a("RcGtId", this.structureID);
        tagCompound.func_74757_a("RcMirror", this.mirrorX);
        tagCompound.func_74757_a("RcStartGen", this.startedGeneration);
        tagCompound.func_74782_a("RcInstDat", this.instanceData);
    }

    protected void func_143011_b(NBTTagCompound tagCompound) {
        super.func_143011_b(tagCompound);
        this.structureID = tagCompound.func_74779_i("RcSId");
        this.generationID = tagCompound.func_74779_i("RcGtId");
        this.mirrorX = tagCompound.func_74767_n("RcMirror");
        this.startedGeneration = tagCompound.func_74767_n("RcStartGen");
        this.instanceData = tagCompound.func_74781_a("RcInstDat");
    }
}

