/*
 * Decompiled with CFR 0.152.
 */
package vswe.production.network.data;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import vswe.production.network.DataReader;
import vswe.production.network.DataWriter;
import vswe.production.network.data.DataBase;
import vswe.production.page.setting.ItemSetting;
import vswe.production.page.setting.Setting;
import vswe.production.page.setting.Side;
import vswe.production.page.setting.Transfer;
import vswe.production.page.setting.TransferMode;
import vswe.production.tileentity.TileEntityTable;

public abstract class DataSide
extends DataBase {
    private static final int SETTINGS = 5;
    private static final int SIDES = 6;
    private static final int MODES = 2;
    public static final int LENGTH = 60;

    protected Transfer getTransfer(TileEntityTable table, int id) {
        int settingId = id % 5;
        int sideId = (id /= 5) % 6;
        int modeId = id /= 6;
        Side side = table.getTransferPage().getSettings().get(settingId).getSides().get(sideId);
        if (modeId == 0) {
            return side.getInput();
        }
        return side.getOutput();
    }

    public static int getId(Setting setting, Side side, Transfer transfer) {
        return setting.getId() + 5 * side.getDirection().ordinal() + (transfer.isInput() ? 0 : 30);
    }

    public static class FilterMode
    extends FilterBase {
        @Override
        public void save(TileEntityTable table, DataWriter dw, int id) {
            dw.writeEnum(this.getSetting(table, id).getMode());
        }

        @Override
        public void load(TileEntityTable table, DataReader dr, int id) {
            this.getSetting(table, id).setMode(dr.readEnum(TransferMode.class));
        }
    }

    public static class Filter
    extends FilterBase {
        @Override
        public void save(TileEntityTable table, DataWriter dw, int id) {
            ItemSetting setting = this.getSetting(table, id);
            ItemStack itemStack = setting.getItem();
            dw.writeBoolean(itemStack != null);
            if (itemStack != null) {
                dw.writeShort(Item.func_150891_b((Item)itemStack.func_77973_b()));
                dw.writeShort(itemStack.func_77960_j());
                dw.writeNBT(itemStack.func_77978_p());
            }
        }

        @Override
        public void load(TileEntityTable table, DataReader dr, int id) {
            ItemSetting setting = this.getSetting(table, id);
            if (dr.readBoolean()) {
                int itemId = dr.readShort();
                int itemDmg = dr.readShort();
                ItemStack item = new ItemStack(Item.func_150899_d((int)itemId), 1, itemDmg);
                item.func_77982_d(dr.readNBT());
                setting.setItem(item);
            } else {
                setting.setItem(null);
            }
        }
    }

    public static abstract class FilterBase
    extends DataSide {
        public static final int LENGTH = 600;

        protected ItemSetting getSetting(TileEntityTable table, int id) {
            return this.getTransfer(table, id / 10).getItem(id % 10);
        }

        public static int getId(Setting setting, Side side, Transfer transfer, ItemSetting itemSetting) {
            return FilterBase.getId(setting, side, transfer) * 10 + itemSetting.getId();
        }
    }

    public static class WhiteList
    extends DataSide {
        @Override
        public void save(TileEntityTable table, DataWriter dw, int id) {
            dw.writeBoolean(this.getTransfer(table, id).hasWhiteList());
        }

        @Override
        public void load(TileEntityTable table, DataReader dr, int id) {
            this.getTransfer(table, id).setUseWhiteList(dr.readBoolean());
        }
    }

    public static class Auto
    extends DataSide {
        @Override
        public void save(TileEntityTable table, DataWriter dw, int id) {
            dw.writeBoolean(this.getTransfer(table, id).isAuto());
        }

        @Override
        public void load(TileEntityTable table, DataReader dr, int id) {
            this.getTransfer(table, id).setAuto(dr.readBoolean());
        }
    }

    public static class Enabled
    extends DataSide {
        @Override
        public void save(TileEntityTable table, DataWriter dw, int id) {
            dw.writeBoolean(this.getTransfer(table, id).isEnabled());
        }

        @Override
        public void load(TileEntityTable table, DataReader dr, int id) {
            this.getTransfer(table, id).setEnabled(dr.readBoolean());
        }
    }
}

