/*
 * Decompiled with CFR 0.152.
 */
package vswe.production.network.data;

import vswe.production.network.DataReader;
import vswe.production.network.DataWriter;
import vswe.production.network.IBitCount;
import vswe.production.network.LengthCount;
import vswe.production.network.data.DataBase;
import vswe.production.network.data.DataFuel;
import vswe.production.network.data.DataLava;
import vswe.production.network.data.DataLit;
import vswe.production.network.data.DataPage;
import vswe.production.network.data.DataSide;
import vswe.production.network.data.DataUnit;
import vswe.production.tileentity.TileEntityTable;

public enum DataType {
    PAGE(DataPage.class),
    PROGRESS(DataUnit.Progress.class, 8),
    POWER(DataFuel.class),
    SIDE_ENABLED(DataSide.Enabled.class, 60),
    SIDE_AUTO(DataSide.Auto.class, 60),
    SIDE_FILTER(DataSide.Filter.class, 600),
    SIDE_WHITE_LIST(DataSide.WhiteList.class, 60),
    SIDE_FILTER_MODE(DataSide.FilterMode.class, 600),
    LAVA(DataLava.class),
    LIT(DataLit.class),
    CHARGED(DataUnit.Charged.class, 8);

    private IBitCount lengthBits;
    private int length;
    private DataBase data;

    private DataType(Class<? extends DataBase> clazz, int length) {
        this(clazz);
        this.length = length;
        this.lengthBits = new LengthCount(length);
    }

    private DataType(Class<? extends DataBase> clazz) {
        try {
            this.data = clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.length = 1;
    }

    public void save(TileEntityTable table, DataWriter dw, int id) {
        if (this.data != null) {
            if (id == -1) {
                for (int i = 0; i < this.length; ++i) {
                    this.data.save(table, dw, i);
                }
            } else {
                if (this.lengthBits != null) {
                    dw.writeData(id, this.lengthBits);
                }
                this.data.save(table, dw, id);
            }
        }
    }

    public int load(TileEntityTable table, DataReader dr, boolean all) {
        if (this.data != null) {
            if (all) {
                for (int i = 0; i < this.length; ++i) {
                    this.data.load(table, dr, i);
                }
            } else {
                int id = 0;
                if (this.lengthBits != null) {
                    id = dr.readData(this.lengthBits);
                }
                this.data.load(table, dr, id);
                return id;
            }
        }
        return -1;
    }

    public boolean shouldBounce(TileEntityTable table) {
        return this.data != null && this.data.shouldBounce(table);
    }

    public boolean shouldBounceToAll(TileEntityTable table) {
        return this.data != null && this.data.shouldBounceToAll(table);
    }
}

