/*
 * Decompiled with CFR 0.152.
 */
package vswe.production.page;

import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import vswe.production.block.ModBlocks;
import vswe.production.gui.GuiBase;
import vswe.production.gui.GuiTable;
import vswe.production.gui.component.ArrowScroll;
import vswe.production.gui.component.CheckBox;
import vswe.production.gui.menu.GuiMenuItem;
import vswe.production.item.Upgrade;
import vswe.production.network.data.DataSide;
import vswe.production.network.data.DataType;
import vswe.production.page.Page;
import vswe.production.page.setting.Direction;
import vswe.production.page.setting.ItemSetting;
import vswe.production.page.setting.Setting;
import vswe.production.page.setting.SettingCoal;
import vswe.production.page.setting.SettingNormal;
import vswe.production.page.setting.Side;
import vswe.production.page.setting.Transfer;
import vswe.production.tileentity.TileEntityTable;

public class PageTransfer
extends Page {
    private List<Setting> settings = new ArrayList<Setting>();
    private Setting selectedSetting;
    private Side selectedSide;
    private List<CheckBox> checkBoxes;
    private List<ArrowScroll> arrows;
    private boolean selectMode;
    private Transfer selectedTransfer;
    private static final int SIDE_X = 75;
    private static final int SIDE_Y = 15;
    private static final int SIDE_OFFSET = 20;
    private static final int SIDE_SIZE = 18;
    private static final int SIDE_SRC_X = 0;
    private static final int SIDE_SRC_Y = 166;
    private static final int SIDE_ITEM_OFFSET = 1;
    private static final int SETTING_X = 5;
    private static final int SETTING_Y = 25;
    private static final int SETTING_OFFSET = 20;
    private static final int SETTING_SIZE = 18;
    private static final int SETTING_SRC_X = 0;
    private static final int SETTING_SRC_Y = 112;
    private static final int SETTING_ITEM_OFFSET = 1;
    private static final int ITEM_X = 10;
    private static final int ITEM_Y = 125;
    private static final int ITEM_OFFSET = 20;
    private static final int ITEM_SIZE = 18;

    public PageTransfer(TileEntityTable table, String name) {
        super(table, name);
        for (int i = 0; i < 4; ++i) {
            int x = 5 + i % 2 * 20;
            int y = 25 + i / 2 * 20;
            this.settings.add(new SettingNormal(table, i, x, y));
        }
        this.settings.add(new SettingCoal(table, 4, 45, 35));
        for (Setting setting : this.settings) {
            for (Direction direction : Direction.values()) {
                setting.getSides().add(new Side(setting, direction, 75 + direction.getInterfaceX() * 20, 15 + direction.getInterfaceY() * 20));
            }
        }
        this.checkBoxes = new ArrayList<CheckBox>();
        this.checkBoxes.add(new CheckBox("Select mode", 165, 20){

            @Override
            public void setValue(boolean value) {
                PageTransfer.this.selectMode = value;
            }

            @Override
            public boolean getValue() {
                return PageTransfer.this.selectMode;
            }

            @Override
            public void onUpdate() {
                if (!this.getValue()) {
                    PageTransfer.this.selectedSide = null;
                    PageTransfer.this.selectedTransfer = null;
                }
            }

            @Override
            public boolean isVisible() {
                return PageTransfer.this.selectedSetting != null && PageTransfer.this.shouldSelectModeBeVisible();
            }
        });
        this.checkBoxes.add(new CheckBox("Enabled", 170, 58){

            @Override
            public void setValue(boolean value) {
                PageTransfer.this.selectedTransfer.setEnabled(value);
                PageTransfer.this.table.updateServer(DataType.SIDE_ENABLED, DataSide.getId(PageTransfer.this.selectedSetting, PageTransfer.this.selectedSide, PageTransfer.this.selectedTransfer));
                PageTransfer.this.table.onSideChange();
            }

            @Override
            public boolean getValue() {
                return PageTransfer.this.selectedTransfer.isEnabled();
            }

            @Override
            public boolean isVisible() {
                return PageTransfer.this.selectedTransfer != null;
            }
        });
        this.checkBoxes.add(new CheckBox("Auto transfer", 170, 68){

            @Override
            public void setValue(boolean value) {
                PageTransfer.this.selectedTransfer.setAuto(value);
                PageTransfer.this.table.updateServer(DataType.SIDE_AUTO, PageTransfer.this.getSyncId());
            }

            @Override
            public boolean getValue() {
                return PageTransfer.this.selectedTransfer.isAuto();
            }

            @Override
            public boolean isVisible() {
                return PageTransfer.this.selectedTransfer != null && PageTransfer.this.table.getUpgradePage().hasGlobalUpgrade(Upgrade.AUTO_TRANSFER);
            }
        });
        this.arrows = new ArrayList<ArrowScroll>();
        this.arrows.add(new ArrowScroll(165, 40, 50){

            @Override
            public String getText() {
                return PageTransfer.this.selectedTransfer.isInput() ? "Input" : "Output";
            }

            @Override
            public void setId(int id) {
                PageTransfer.this.selectedTransfer = id == 0 ? PageTransfer.this.selectedSide.getInput() : PageTransfer.this.selectedSide.getOutput();
            }

            @Override
            public int getId() {
                return PageTransfer.this.selectedTransfer.isInput() ? 0 : 1;
            }

            @Override
            public boolean isVisible() {
                return PageTransfer.this.selectedTransfer != null;
            }

            @Override
            protected int getLength() {
                return 2;
            }
        });
        this.arrows.add(new ArrowScroll(10, 112, 80){

            @Override
            public String getText() {
                return PageTransfer.this.selectedTransfer.hasWhiteList() ? "Use white list" : "Use black list";
            }

            @Override
            public void setId(int id) {
                PageTransfer.this.selectedTransfer.setUseWhiteList(id == 0);
            }

            @Override
            public int getId() {
                return PageTransfer.this.selectedTransfer.hasWhiteList() ? 0 : 1;
            }

            @Override
            public boolean isVisible() {
                return PageTransfer.this.selectedTransfer != null && PageTransfer.this.table.getUpgradePage().hasGlobalUpgrade(Upgrade.FILTER);
            }

            @Override
            public void onUpdate() {
                PageTransfer.this.table.updateServer(DataType.SIDE_WHITE_LIST, PageTransfer.this.getSyncId());
            }

            @Override
            protected int getLength() {
                return 2;
            }
        });
    }

    public int getSyncId() {
        return DataSide.getId(this.selectedSetting, this.selectedSide, this.selectedTransfer);
    }

    public int getSyncId(ItemSetting itemSetting) {
        return DataSide.FilterBase.getId(this.selectedSetting, this.selectedSide, this.selectedTransfer, itemSetting);
    }

    private boolean shouldSelectModeBeVisible() {
        return this.table.getUpgradePage().hasGlobalUpgrade(Upgrade.AUTO_TRANSFER) || this.table.getUpgradePage().hasGlobalUpgrade(Upgrade.FILTER);
    }

    @Override
    public int createSlots(int id) {
        return id;
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        int textureIndexY;
        super.draw(gui, mX, mY);
        for (Setting setting : this.settings) {
            int textureIndexX;
            gui.prepare();
            boolean isValid = setting.isValid();
            boolean isSelected = setting.equals(this.selectedSetting);
            if (isSelected) {
                if (!this.shouldSelectModeBeVisible()) {
                    this.selectMode = false;
                    this.selectedTransfer = null;
                    this.selectedSide = null;
                }
                if (!isValid) {
                    this.selectedTransfer = null;
                    this.selectedSide = null;
                    this.selectedSetting = null;
                }
            }
            boolean hover = gui.inBounds(setting.getX(), setting.getY(), 18, 18, mX, mY);
            int n = textureIndexX = isValid && hover ? 1 : 0;
            textureIndexY = isValid ? (isSelected ? 1 : 0) : 2;
            ItemStack item = setting.getItem();
            gui.drawRect(setting.getX(), setting.getY(), 0 + textureIndexX * 18, 112 + textureIndexY * 18, 18, 18);
            gui.drawItem(item, setting.getX() + 1, setting.getY() + 1);
            if (!hover || !isValid) continue;
            String name = setting.getName();
            if (name == null) {
                gui.getItemName(item);
            }
            gui.drawMouseOver(name);
        }
        if (this.selectedSetting != null) {
            for (Side side : this.selectedSetting.getSides()) {
                gui.prepare();
                boolean hover = gui.inBounds(side.getX(), side.getY(), 18, 18, mX, mY);
                int textureIndexX = side.equals(this.selectedSide) ? 2 : (hover ? 1 : 0);
                boolean output = side.isOutputEnabled();
                boolean input = side.isInputEnabled();
                textureIndexY = output && input ? 3 : (output ? 2 : (input ? 1 : 0));
                gui.drawRect(side.getX(), side.getY(), 0 + textureIndexX * 18, 166 + textureIndexY * 18, 18, 18);
                gui.drawBlockIcon(ModBlocks.table.getIconFromSideAndMeta(side.getDirection().ordinal(), 0), side.getX() + 1, side.getY() + 1);
                if (!hover) continue;
                gui.drawMouseOver(side.getDescription(side == this.selectedSide));
            }
            if (this.selectedTransfer != null && this.table.getUpgradePage().hasGlobalUpgrade(Upgrade.FILTER)) {
                gui.drawString("Filter", 8, 100, 0x404040);
                for (int i = 0; i < 10; ++i) {
                    gui.prepare();
                    ItemSetting itemSetting = this.selectedTransfer.getItem(i);
                    ItemStack item = itemSetting != null ? itemSetting.getItem() : null;
                    int x = 10 + i * 20;
                    gui.drawItemWithBackground(item, x, 125, mX, mY);
                }
            }
        }
        for (CheckBox checkBox : this.checkBoxes) {
            checkBox.draw(gui, mX, mY);
        }
        for (ArrowScroll arrowScroll : this.arrows) {
            arrowScroll.draw(gui, mX, mY);
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int button) {
        for (Setting setting : this.settings) {
            if (!gui.inBounds(setting.getX(), setting.getY(), 18, 18, mX, mY)) continue;
            if (!setting.isValid()) break;
            if (setting.equals(this.selectedSetting)) {
                this.selectedSetting = null;
                this.selectedSide = null;
                this.selectedTransfer = null;
                break;
            }
            if (this.selectedSide != null) {
                Side side = setting.getSides().get(this.selectedSide.getDirection().ordinal());
                this.selectedTransfer = this.selectedTransfer.isInput() ? side.getInput() : side.getOutput();
                this.selectedSide = side;
            }
            this.selectedSetting = setting;
            break;
        }
        if (this.selectedSetting != null) {
            for (Side side : this.selectedSetting.getSides()) {
                boolean newOutput;
                if (!gui.inBounds(side.getX(), side.getY(), 18, 18, mX, mY)) continue;
                if (this.selectMode) {
                    if (side.equals(this.selectedSide)) {
                        this.selectedSide = null;
                        this.selectedTransfer = null;
                        break;
                    }
                    this.selectedTransfer = this.selectedTransfer == null ? side.getInput() : (this.selectedTransfer.isInput() ? side.getInput() : side.getOutput());
                    this.selectedSide = side;
                    break;
                }
                boolean input = side.isInputEnabled();
                boolean output = side.isOutputEnabled();
                int id = (output ? 2 : 0) + (input ? 1 : 0);
                id = (id += button == 0 ? 1 : -1) < 0 ? (id += 4) : (id %= 4);
                boolean newInput = (id & 1) != 0;
                boolean bl = newOutput = (id & 2) != 0;
                if (newInput != input) {
                    side.setInputEnabled(newInput);
                    this.table.updateServer(DataType.SIDE_ENABLED, DataSide.getId(this.selectedSetting, side, side.getInput()));
                }
                if (newOutput != output) {
                    side.setOutputEnabled(newOutput);
                    this.table.updateServer(DataType.SIDE_ENABLED, DataSide.getId(this.selectedSetting, side, side.getOutput()));
                }
                this.table.onSideChange();
                break;
            }
            if (this.selectedTransfer != null && this.table.getUpgradePage().hasGlobalUpgrade(Upgrade.FILTER)) {
                for (int i = 0; i < 10; ++i) {
                    if (!gui.inBounds(10 + i * 20, 125, 18, 18, mX, mY)) continue;
                    EntityPlayer player = this.getPlayer();
                    ItemStack itemStack = player.field_71071_by.func_70445_o();
                    if (itemStack == null) {
                        this.table.setMenu(new GuiMenuItem(this.table, this.selectedTransfer.getItem(i)));
                        break;
                    }
                    itemStack = itemStack.func_77946_l();
                    itemStack.field_77994_a = 1;
                    this.selectedTransfer.getItem(i).setItem(itemStack);
                    this.table.updateServer(DataType.SIDE_FILTER, this.getSyncId(this.selectedTransfer.getItem(i)));
                    break;
                }
            }
        }
        for (CheckBox checkBox : this.checkBoxes) {
            checkBox.onClick(gui, mX, mY);
        }
        for (ArrowScroll arrow : this.arrows) {
            arrow.onClick(gui, mX, mY);
        }
    }

    @SideOnly(value=cpw.mods.fml.relauncher.Side.CLIENT)
    private EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void onRelease(GuiTable gui, int mX, int mY, int button) {
        for (ArrowScroll arrow : this.arrows) {
            arrow.onRelease();
        }
    }

    public List<Setting> getSettings() {
        return this.settings;
    }
}

