/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.ejml.data.D1Matrix64F;
import org.ejml.ops.CommonOps;

public class MatrixComponent
extends JPanel {
    BufferedImage image;

    public MatrixComponent(int n, int n2) {
        this.image = new BufferedImage(n, n2, 1);
        this.setPreferredSize(new Dimension(n, n2));
        this.setMinimumSize(new Dimension(n, n2));
    }

    public synchronized void setMatrix(D1Matrix64F d1Matrix64F) {
        double d = CommonOps.elementMaxAbs(d1Matrix64F);
        MatrixComponent.renderMatrix(d1Matrix64F, this.image, d);
        this.repaint();
    }

    public static void renderMatrix(D1Matrix64F d1Matrix64F, BufferedImage bufferedImage, double d) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        double d2 = (double)d1Matrix64F.numCols / (double)bufferedImage.getWidth();
        double d3 = (double)d1Matrix64F.numRows / (double)bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3;
                int n4;
                double d4 = d1Matrix64F.get((int)((double)i * d3), (int)((double)j * d2));
                if (d4 == 0.0) {
                    bufferedImage.setRGB(j, i, -16777216);
                    continue;
                }
                if (d4 > 0.0) {
                    n4 = 255 - (int)(255.0 * (d4 / d));
                    n3 = 0xFFFF0000 | n4 << 8 | n4;
                    bufferedImage.setRGB(j, i, n3);
                    continue;
                }
                n4 = 255 + (int)(255.0 * (d4 / d));
                n3 = 0xFF000000 | n4 << 16 | n4 << 8 | 0xFF;
                bufferedImage.setRGB(j, i, n3);
            }
        }
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
    }
}

