/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ArrayHashList<E>
extends AbstractCollection<E>
implements List<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3230581060536180693L;
    private transient Object[] elementData;
    protected transient int size;
    protected transient int mask;
    protected transient Entry[] hashTable;
    protected transient int modCount;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    private static int roundUpToPowerOf2(int number) {
        return number >= 0x40000000 ? 0x40000000 : (number > 2 ? Integer.highestOneBit(number - 1 << 1) : 2);
    }

    public ArrayHashList() {
        this.elementData = new Object[10];
        this.hashTable = new Entry[8];
        this.mask = 7;
    }

    public ArrayHashList(int size) {
        this.elementData = new Object[size];
        size = ArrayHashList.roundUpToPowerOf2(size) >> 1;
        this.hashTable = new Entry[size];
        this.mask = size - 1;
    }

    public ArrayHashList(Collection<E> col) {
        int size = col.size();
        this.elementData = new Object[size];
        size = ArrayHashList.roundUpToPowerOf2(size) >> 1;
        this.hashTable = new Entry[size];
        this.mask = size - 1;
        this.addAll(col);
    }

    protected int hash(Object n) {
        int h = n == null ? 0 : n.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected void add(E obj, int hash) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = obj;
        this.insert(new Entry(obj, hash));
        this.rehashIfNecessary();
    }

    @Override
    public boolean add(E obj) {
        int hash = this.hash(obj);
        if (this.seek(obj, hash) != null) {
            return false;
        }
        this.add(obj, hash);
        return true;
    }

    @Override
    public E set(int index, E obj) {
        this.checkElementIndex(index);
        int hash = this.hash(obj);
        if (this.seek(obj, hash) != null) {
            throw new IllegalArgumentException("Duplicate entries not allowed");
        }
        ++this.modCount;
        Entry e = this.seek(this.elementData[index], this.hash(this.elementData[index]));
        this.delete(e);
        this.elementData[index] = obj;
        this.insert(new Entry(obj, hash));
        return (E)e.key;
    }

    @Override
    public void add(int index, E obj) {
        this.checkPositionIndex(index);
        int hash = this.hash(obj);
        if (this.seek(obj, hash) != null) {
            throw new IllegalArgumentException("Duplicate entries not allowed");
        }
        if (index == this.size) {
            this.add(obj, hash);
            return;
        }
        this.ensureCapacityInternal(++this.size);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index - 1);
        this.elementData[index] = obj;
        this.insert(new Entry(obj, hash));
        this.rehashIfNecessary();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c.size() == 0) {
            return false;
        }
        for (E e : c) {
            this.add(index++, e);
        }
        return true;
    }

    @Override
    public E get(int index) {
        this.checkElementIndex(index);
        return this.index(index);
    }

    @Override
    public int indexOf(Object obj) {
        Entry e = this.seek(obj, this.hash(obj));
        if (e == null) {
            return -1;
        }
        Object o = e.key;
        Object[] data = this.elementData;
        int i = this.size;
        while (i-- > 0 && data[i] != o) {
        }
        return i;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public boolean contains(Object obj) {
        return this.seek(obj, this.hash(obj)) != null;
    }

    @Override
    public E remove(int index) {
        this.checkElementIndex(index);
        E oldValue = this.index(index);
        this.delete(this.seek(oldValue, this.hash(oldValue)));
        this.fastRemove(index);
        return oldValue;
    }

    @Override
    public boolean remove(Object obj) {
        Entry e = this.seek(obj, this.hash(obj));
        if (e == null) {
            return false;
        }
        Object o = e.key;
        Object[] data = this.elementData;
        int i = this.size;
        while (i-- > 0) {
            if (data[i] != o) continue;
            this.fastRemove(i);
            break;
        }
        this.delete(e);
        return true;
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        int i;
        ++this.modCount;
        for (i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        i = this.hashTable.length;
        while (i-- > 0) {
            this.hashTable[i] = null;
        }
        this.size = 0;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.elementData.length) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > 0) {
            this.ensureCapacityInternal(minCapacity);
        }
    }

    private void ensureCapacityInternal(int minCapacity) {
        ++this.modCount;
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ArrayHashList.hugeCapacity(minCapacity);
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int expectedModCount = this.modCount;
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.elementData = new Object[10];
        this.hashTable = new Entry[8];
        this.mask = 7;
        this.size = 0;
        s.defaultReadObject();
        int size = s.readInt();
        if (size > 0) {
            this.ensureCapacityInternal(size);
            for (int i = 0; i < size; ++i) {
                this.add(s.readObject());
            }
        }
    }

    E index(int index) {
        return (E)this.elementData[index];
    }

    protected Entry seek(Object obj, int hash) {
        Entry entry = this.hashTable[hash & this.mask];
        while (entry != null) {
            if (hash == entry.hash && Objects.equal((Object)obj, (Object)entry.key)) {
                return entry;
            }
            entry = entry.nextInBucket;
        }
        return null;
    }

    protected void insert(Entry entry) {
        int bucket = entry.hash & this.mask;
        entry.nextInBucket = this.hashTable[bucket];
        this.hashTable[bucket] = entry;
    }

    protected void delete(Entry entry) {
        Entry[] entryArray = this.hashTable;
        synchronized (this.hashTable) {
            block6: {
                int bucket = entry.hash & this.mask;
                Entry prev = null;
                Entry cur = this.hashTable[bucket];
                if (cur == entry) {
                    this.hashTable[bucket] = cur.nextInBucket;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    break block6;
                }
                while (true) {
                    if (cur == entry) {
                        prev.nextInBucket = entry.nextInBucket;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        break;
                    }
                    prev = cur;
                    cur = cur.nextInBucket;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void rehashIfNecessary() {
        Entry[] old = this.hashTable;
        if (this.size <= old.length * 2 || old.length >= 0x40000000) return;
        Entry[] entryArray = this.hashTable;
        synchronized (this.hashTable) {
            int newTableSize = old.length * 2;
            int newMask = newTableSize - 1;
            this.hashTable = new Entry[newTableSize];
            Entry[] newTable = this.hashTable;
            this.mask = newMask;
            int bucket = old.length;
            while (bucket-- > 0) {
                Entry entry = old[bucket];
                while (entry != null) {
                    Entry nextEntry = entry.nextInBucket;
                    int keyBucket = entry.hash & newMask;
                    entry.nextInBucket = newTable[keyBucket];
                    newTable[keyBucket] = entry;
                    entry = nextEntry;
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    public ArrayHashList<E> clone() {
        return new ArrayHashList<E>(this);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListItr(index);
    }

    protected boolean isElementIndex(int index) {
        return index >= 0 && index < this.size;
    }

    protected boolean isPositionIndex(int index) {
        return index >= 0 && index <= this.size;
    }

    protected String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    protected void checkElementIndex(int index) {
        if (!this.isElementIndex(index)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    protected void checkPositionIndex(int index) {
        if (!this.isPositionIndex(index)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayHashList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayHashList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                ArrayHashList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayHashList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = ArrayHashList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayHashList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= ArrayHashList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayHashList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayHashList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayHashList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (ArrayHashList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected static final class Entry {
        protected final Object key;
        protected final int hash;
        protected Entry nextInBucket;

        protected Entry(Object key, int keyHash) {
            this.key = key;
            this.hash = keyHash;
        }
    }
}

