/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock.tile;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.endertech.block.ETBlocks;
import io.endertech.multiblock.MultiblockControllerBase;
import io.endertech.multiblock.MultiblockValidationException;
import io.endertech.multiblock.block.BlockTankController;
import io.endertech.multiblock.controller.ControllerTank;
import io.endertech.multiblock.tile.TileTankPart;
import io.endertech.util.BlockCoord;
import java.util.Set;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTankController
extends TileTankPart {
    public static void init() {
        GameRegistry.registerTileEntity(TileTankController.class, (String)"tile.endertech.enderTankController");
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
        throw new MultiblockValidationException("Controllers cannot be used for tank sides (only the frame).");
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        throw new MultiblockValidationException("Controllers cannot be used for tank top (only the frame).");
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        throw new MultiblockValidationException("Controllers cannot be used for tank bottom (only the frame).");
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException("Controllers cannot be used for tank interior (only the frame).");
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isConnected()) {
            return INFINITE_EXTENT_AABB;
        }
        ControllerTank controller = this.getTankController();
        BlockCoord min = controller.getMinimumCoord();
        BlockCoord max = controller.getMaximumCoord();
        return AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    public double func_145833_n() {
        return 16384.0;
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        Set<ForgeDirection> out = this.getOutwardsDir();
        if (out.isEmpty()) {
            this.setOrientation(ForgeDirection.SOUTH);
        } else if (!out.contains(this.getOrientation())) {
            for (int i = 2; i < 6; ++i) {
                ForgeDirection orientation = ForgeDirection.getOrientation((int)i);
                if (!out.contains(orientation)) continue;
                this.setOrientation(orientation);
                return;
            }
        }
    }

    @Override
    public void onMachineBroken() {
        int metadata;
        super.onMachineBroken();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145854_h == ETBlocks.blockTankController && BlockTankController.isController(metadata = this.func_145832_p())) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        }
    }
}

