/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.tiles;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.tiles.IEssentiaTransportWithSimulate;
import thaumicenergistics.common.integration.IEssentiaProviderWatcher;
import thaumicenergistics.common.integration.tc.EssentiaTransportHelper;
import thaumicenergistics.common.tiles.abstraction.TileProviderBase;

public class TileEssentiaProvider
extends TileProviderBase
implements IEssentiaTransportWithSimulate {
    private static final int TICK_RATE_IDLE = 15;
    private static final int TICK_RATE_URGENT = 5;
    private int tickCount = 0;
    private int tickRate = 15;
    private Set<WeakReference<IEssentiaProviderWatcher>> blockWatchers;

    @Override
    protected double getIdlePowerusage() {
        return 3.0;
    }

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        return ThEApi.instance().blocks().EssentiaProvider.getStack();
    }

    protected Aspect getNeighborWantedAspect(ForgeDirection side) {
        TileEntity neighbor = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
        if (neighbor != null && neighbor instanceof IEssentiaTransport) {
            Aspect wantedAspect = ((IEssentiaTransport)neighbor).getSuctionType(side.getOpposite());
            return wantedAspect;
        }
        return null;
    }

    @Override
    protected void onPowerChange(boolean isPowered) {
        if (this.blockWatchers != null) {
            for (WeakReference<IEssentiaProviderWatcher> watcherRef : this.blockWatchers) {
                IEssentiaProviderWatcher watcher = (IEssentiaProviderWatcher)watcherRef.get();
                if (watcher == null) continue;
                watcher.onProviderPowerChange(isPowered);
            }
        }
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection side) {
        return this.addEssentia(aspect, amount, side, Actionable.MODULATE);
    }

    @Override
    public int addEssentia(Aspect aspect, int amount, ForgeDirection side, Actionable mode) {
        long rejectedAmount = amount;
        if (this.getEssentiaMonitor()) {
            rejectedAmount = this.monitor.injectEssentia(aspect, amount, mode, (BaseActionSource)this.getMachineSource(), true);
        }
        long acceptedAmount = (long)amount - rejectedAmount;
        if (mode == Actionable.MODULATE && acceptedAmount > 0L) {
            this.tickRate = 5;
        }
        return (int)acceptedAmount;
    }

    public boolean canInputFrom(ForgeDirection side) {
        return true;
    }

    public boolean canOutputTo(ForgeDirection side) {
        return true;
    }

    public int getEssentiaAmount(ForgeDirection side) {
        Aspect wantedAspect = this.getNeighborWantedAspect(side);
        if (wantedAspect != null) {
            return (int)Math.min(this.getAspectAmountInNetwork(wantedAspect), Integer.MAX_VALUE);
        }
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection side) {
        Aspect wantedAspect = this.getNeighborWantedAspect(side);
        if (wantedAspect != null && this.getAspectAmountInNetwork(wantedAspect) > 0L) {
            return wantedAspect;
        }
        return null;
    }

    public int getMinimumSuction() {
        return 1;
    }

    public int getSuctionAmount(ForgeDirection side) {
        return 8;
    }

    public Aspect getSuctionType(ForgeDirection side) {
        return null;
    }

    public boolean isConnectable(ForgeDirection side) {
        return true;
    }

    @Override
    public void onBreakBlock() {
        if (this.blockWatchers != null) {
            for (WeakReference<IEssentiaProviderWatcher> watcherRef : this.blockWatchers) {
                IEssentiaProviderWatcher watcher = (IEssentiaProviderWatcher)watcherRef.get();
                if (watcher == null) continue;
                watcher.onProviderBroken();
            }
            this.blockWatchers.clear();
        }
    }

    @TileEvent(value=TileEventType.TICK)
    public void onTick() {
        if (!this.field_145850_b.field_72995_K && ++this.tickCount >= this.tickRate) {
            this.tickCount = 0;
            this.tickRate = 15;
            EssentiaTransportHelper.INSTANCE.takeEssentiaFromTransportNeighbors(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void registerBlockWatcher(IEssentiaProviderWatcher watcher) {
        if (this.blockWatchers == null) {
            this.blockWatchers = new HashSet<WeakReference<IEssentiaProviderWatcher>>();
        }
        this.blockWatchers.add(new WeakReference<IEssentiaProviderWatcher>(watcher));
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection side) {
        return this.extractEssentiaFromNetwork(aspect, amount, false);
    }
}

