/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Pluto.worldgen.dungeon;

import com.mjr.extraplanets.planets.Pluto.worldgen.dungeon.DungeonBoundingBox;
import com.mjr.extraplanets.planets.Pluto.worldgen.dungeon.DungeonRoom;
import com.mjr.extraplanets.planets.Pluto.worldgen.dungeon.MapGenDungeon;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomChestsPluto
extends DungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    private final ArrayList<ChunkCoordinates> chests = new ArrayList();

    public RoomChestsPluto(MapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            Random rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(5) + 6;
            this.sizeY = rand.nextInt(2) + 4;
            this.sizeZ = rand.nextInt(5) + 6;
        }
    }

    @Override
    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150350_a, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        if (this.placeBlock(chunk, meta, hx, this.posY, hz, cx, cz, (Block)Blocks.field_150486_ae, 0)) {
            this.chests.add(new ChunkCoordinates(hx, this.posY, hz));
        }
    }

    @Override
    public DungeonBoundingBox getBoundingBox() {
        return new DungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    @Override
    protected DungeonRoom makeRoom(MapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomChestsPluto(dungeon, x, y, z, dir);
    }

    @Override
    protected void handleTileEntities(Random rand) {
        if (!this.chests.isEmpty()) {
            this.worldObj.func_147465_d(this.chests.get((int)0).field_71574_a, this.chests.get((int)0).field_71572_b, this.chests.get((int)0).field_71573_c, (Block)Blocks.field_150486_ae, 0, 2);
            TileEntityChest chest = (TileEntityChest)this.worldObj.func_147438_o(this.chests.get((int)0).field_71574_a, this.chests.get((int)0).field_71572_b, this.chests.get((int)0).field_71573_c);
            if (chest != null) {
                for (int i = 0; i < chest.func_70302_i_(); ++i) {
                    chest.func_70299_a(i, null);
                }
                ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)chest, (int)info.getCount(rand));
            }
            this.chests.clear();
        }
    }
}

