/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.util;

import com.mjr.extraplanets.ExtraPlanets;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class RegisterHelper {
    public static void registerExtraPlanetsNonMobEntity(Class<? extends Entity> var0, String var1, int trackingDistance, int updateFreq, boolean sendVel) {
        EntityRegistry.registerModEntity(var0, (String)var1, (int)GCCoreUtil.nextInternalID(), (Object)ExtraPlanets.instance, (int)trackingDistance, (int)updateFreq, (boolean)sendVel);
    }

    public static void registerExtraPlanetsCreature(Class<? extends Entity> var0, String var1, int back, int fore) {
        EntityRegistry.instance();
        int newID = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(var0, (String)var1, (int)newID, (int)back, (int)fore);
        EntityRegistry.registerModEntity(var0, (String)var1, (int)GCCoreUtil.nextInternalID(), (Object)ExtraPlanets.instance, (int)80, (int)3, (boolean)true);
    }

    public static void setHarvestLevel(Block block, String toolClass, int level, int meta) {
        block.setHarvestLevel(toolClass, level, meta);
    }

    public static Planet registerUnreachablePlanet(String name, SolarSystem system) {
        ArrayList cBodyList = new ArrayList();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        for (CelestialBody body : cBodyList) {
            if (!(body instanceof Planet) || !name.equals(body.getName()) || ((Planet)body).getParentSolarSystem() != system) continue;
            return null;
        }
        Planet planet = new Planet(name).setParentSolarSystem(system);
        planet.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/" + name + ".png"));
        GalaxyRegistry.registerPlanet((Planet)planet);
        return planet;
    }

    public static Moon registerUnreachableMoon(String name, Planet parent) {
        ArrayList cBodyList = new ArrayList();
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (!(body instanceof Moon) || !name.equals(body.getName()) || ((Moon)body).getParentPlanet() != parent) continue;
            return null;
        }
        Moon moon = new Moon(name).setParentPlanet(parent);
        if (name.equalsIgnoreCase("callisto") || name.equalsIgnoreCase("europa") || name.equalsIgnoreCase("io") || name.equalsIgnoreCase("ganymede")) {
            moon.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/" + name + ".png"));
        } else {
            moon.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/" + name + ".png"));
        }
        GalaxyRegistry.registerMoon((Moon)moon);
        return moon;
    }
}

