/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import hardcorequesting.QuestingData;
import hardcorequesting.Translator;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;

public enum DeathType {
    LAVA("lava"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("lava");
        }
    }
    ,
    FIRE("fire"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76347_k();
        }
    }
    ,
    SUFFOCATION("suffocation"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("inWall");
        }
    }
    ,
    THORNS("thorns"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("thorns") || source.func_76355_l().equals("cactus");
        }
    }
    ,
    DROWNING("drowning"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("drown");
        }
    }
    ,
    STARVATION("starvation"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("starve");
        }
    }
    ,
    FALL("fall"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("fall");
        }
    }
    ,
    VOID("void"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("outOfWorld");
        }
    }
    ,
    CRUSHED("crushed"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("anvil") || source.func_76355_l().equals("fallingBlock");
        }
    }
    ,
    EXPLOSION("explosions"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_94541_c();
        }
    }
    ,
    MONSTER("monsters"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("mob") || source.func_76346_g() instanceof EntityLiving;
        }
    }
    ,
    PLAYER("otherPlayers"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("player") || source.func_76346_g() instanceof EntityPlayer;
        }
    }
    ,
    MAGIC("magic"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_82725_o();
        }
    }
    ,
    HQM("rottenHearts"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return false;
        }
    }
    ,
    OTHER("other"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return true;
        }
    };

    private String name;

    private DeathType(String name) {
        this.name = name;
    }

    public void onDeath(EntityPlayer player) {
        QuestingData.getQuestingData(player).getDeathStat().increaseDeath(this.ordinal());
    }

    public static void onDeath(EntityPlayer player, DamageSource source) {
        if (source != null && source.func_76355_l() != null) {
            for (DeathType deathType : DeathType.values()) {
                if (!deathType.isSourceValid(source)) continue;
                deathType.onDeath(player);
                break;
            }
        } else {
            OTHER.onDeath(player);
        }
    }

    abstract boolean isSourceValid(DamageSource var1);

    public String getName() {
        return Translator.translate("hqm.deathType." + this.name);
    }
}

