/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.HardcoreQuesting;
import hardcorequesting.bag.BagTier;
import hardcorequesting.bag.Group;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.items.ItemInfo;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemBag
extends Item {
    public static boolean displayGui;

    public ItemBag() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(64);
        this.func_77637_a(HardcoreQuesting.HQMTab);
        this.func_77655_b("hqm:bags");
    }

    public void func_94581_a(IIconRegister register) {
        this.pickIcons(register);
    }

    private void pickIcons(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("hqm:" + ItemInfo.BAG_ICON);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List tooltip, boolean extraInfo) {
        super.func_77624_a(itemstack, player, tooltip, extraInfo);
        int dmg = itemstack.func_77960_j();
        if (dmg >= 0 && dmg < BagTier.values().length) {
            BagTier tier = BagTier.values()[dmg];
            tooltip.add((Object)((Object)tier.getColor()) + tier.getName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List stackList) {
        for (int i = 0; i < BagTier.values().length; ++i) {
            stackList.add(new ItemStack((Item)this, 1, i));
        }
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            int dmg = item.func_77960_j();
            if (dmg >= 0 && dmg < BagTier.values().length) {
                int totalWeight = 0;
                for (Group group : Group.getGroups()) {
                    if (!group.isValid(player)) continue;
                    totalWeight += group.getTier().getWeights()[dmg];
                }
                if (totalWeight > 0) {
                    int rng = (int)(Math.random() * (double)totalWeight);
                    List<Group> groups = Group.getGroups();
                    for (int i = 0; i < groups.size(); ++i) {
                        Group group = groups.get(i);
                        if (!group.isValid(player)) continue;
                        int weight = group.getTier().getWeights()[dmg];
                        if (rng < weight) {
                            group.open(player);
                            player.field_71071_by.func_70296_d();
                            this.openClientInterface(player, i, dmg);
                            world.func_72956_a((Entity)player, Sounds.BAG.getSound(), 1.0f, 1.0f);
                            break;
                        }
                        rng -= weight;
                    }
                }
            }
            --item.field_77994_a;
        }
        return item;
    }

    private void openClientInterface(EntityPlayer player, int id, int bag) {
        DataWriter dw = PacketHandler.getWriter(PacketId.BAG_INTERFACE);
        dw.writeData(id, DataBitHelper.GROUP_COUNT);
        dw.writeData(bag, DataBitHelper.BAG_TIER);
        for (Group group : Group.getGroups()) {
            if (group.getLimit() == 0) continue;
            dw.writeData(group.getRetrievalCount(player), DataBitHelper.LIMIT);
        }
        if (displayGui) {
            PacketHandler.sendToRawPlayer(player, dw);
        }
        SoundHandler.play(Sounds.BAG, player);
    }
}

