/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.parsing;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class MinecraftAdapter {
    public static final TypeAdapter<ItemStack> ITEM_STACK = new TypeAdapter<ItemStack>(){
        private static final String ID = "id";
        private static final String DAMAGE = "damage";
        private static final String STACK_SIZE = "amount";
        private static final String NBT = "nbt";

        public void write(JsonWriter out, ItemStack value) throws IOException {
            if (value == null || value.func_77973_b() == null) {
                out.nullValue();
                return;
            }
            String id = GameData.getItemRegistry().func_148750_c((Object)value.func_77973_b());
            out.beginObject();
            out.name(ID).value(id);
            if (value.func_77960_j() != 0) {
                out.name(DAMAGE).value((long)value.func_77960_j());
            }
            if (value.field_77994_a != 1) {
                out.name(STACK_SIZE).value((long)value.field_77994_a);
            }
            if (value.func_77942_o() && !value.func_77978_p().func_82582_d()) {
                NBT_TAG_COMPOUND.write(out.name(NBT), (Object)value.func_77978_p());
            }
            out.endObject();
        }

        public ItemStack read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                return null;
            }
            String id = "";
            int damage = 0;
            int size = 1;
            NBTTagCompound tag = null;
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equalsIgnoreCase(ID)) {
                    id = in.nextString();
                    continue;
                }
                if (name.equalsIgnoreCase(DAMAGE)) {
                    damage = in.nextInt();
                    continue;
                }
                if (name.equalsIgnoreCase(STACK_SIZE)) {
                    size = in.nextInt();
                    continue;
                }
                if (!name.equalsIgnoreCase(NBT)) continue;
                tag = (NBTTagCompound)NBT_TAG_COMPOUND.read(in);
            }
            in.endObject();
            String modid = "minecraft";
            String name = "";
            int colon = id.indexOf(58);
            if (colon == -1) {
                name = id;
            } else {
                modid = id.substring(0, colon);
                name = id.substring(colon + 1);
            }
            Item item = this.getItemFromID(modid, name);
            if (item == null) {
                return null;
            }
            ItemStack result = new ItemStack(item, size, damage);
            result.func_77982_d(tag);
            return result;
        }

        private Item getItemFromID(String mod, String name) {
            Item item = GameRegistry.findItem((String)mod, (String)name);
            if (item != null) {
                return item;
            }
            Block block = GameRegistry.findBlock((String)mod, (String)name);
            if (block != null) {
                return Item.func_150898_a((Block)block);
            }
            return null;
        }
    };
    public static final TypeAdapter<NBTTagCompound> NBT_TAG_COMPOUND = new TypeAdapter<NBTTagCompound>(){

        public void write(JsonWriter out, NBTTagCompound value) throws IOException {
            out.value(value.toString());
        }

        public NBTTagCompound read(JsonReader in) throws IOException {
            try {
                NBTBase nbtBase = JsonToNBT.func_150315_a((String)in.nextString());
                if (nbtBase instanceof NBTTagCompound) {
                    return (NBTTagCompound)nbtBase;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("Failed to read NBT");
        }
    };
    public static final TypeAdapter<Fluid> FLUID = new TypeAdapter<Fluid>(){

        public void write(JsonWriter out, Fluid value) throws IOException {
            out.value(value.getName());
        }

        public Fluid read(JsonReader in) throws IOException {
            return FluidRegistry.getFluid((String)in.nextString());
        }
    };
}

