/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.EventHandler;
import hardcorequesting.FileVersion;
import hardcorequesting.SaveHelper;
import hardcorequesting.Translator;
import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiEditMenuItem;
import hardcorequesting.client.interfaces.GuiEditMenuLocation;
import hardcorequesting.client.interfaces.GuiEditMenuTextEditor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestDataTask;
import hardcorequesting.quests.QuestDataTaskLocation;
import hardcorequesting.quests.QuestTask;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class QuestTaskLocation
extends QuestTask {
    private int delay = 1;
    private static final int CHECK_DELAY = 20;
    public Location[] locations = new Location[0];
    private static final int Y_OFFSET = 30;
    private static final int X_TEXT_OFFSET = 23;
    private static final int X_TEXT_INDENT = 0;
    private static final int Y_TEXT_OFFSET = 0;
    private static final int ITEM_SIZE = 18;

    @Override
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER) {
            this.tick(null, false);
        }
    }

    @Override
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER) {
            this.tick(event.player, true);
        }
    }

    private void tick(EntityPlayer player, boolean isPlayerEvent) {
        if (!isPlayerEvent) {
            ++this.delay;
            this.delay %= 20;
        } else if (this.delay == 0) {
            World world = player.field_70170_p;
            if (!world.field_72995_K) {
                boolean[] visited = ((QuestDataTaskLocation)this.getData((EntityPlayer)player)).visited;
                boolean all = true;
                boolean updated = false;
                for (int i = 0; i < this.locations.length; ++i) {
                    Location location = this.locations[i];
                    if (visited[i] || player.field_70170_p.field_73011_w.field_76574_g != location.dimension) continue;
                    int current = (int)player.func_70092_e((double)location.x + 0.5, (double)location.y + 0.5, (double)location.z + 0.5);
                    int target = location.radius * location.radius;
                    if (location.radius >= 0 && current > target) {
                        all = false;
                        continue;
                    }
                    if (this.isCompleted(player) || !this.isVisible(player) || !this.parent.isEnabled(player) || !this.parent.isAvailable(player)) continue;
                    updated = true;
                    visited[i] = true;
                }
                if (updated) {
                    if (all) {
                        this.completeTask(player.func_146103_bH().getName());
                    }
                    this.parent.sendUpdatedDataToTeam(player);
                }
            }
        }
    }

    private Location[] getEditFriendlyLocations(Location[] locations) {
        if (Quest.isEditing && locations.length < DataBitHelper.TASK_LOCATION_COUNT.getMaximum()) {
            locations = Arrays.copyOf(locations, locations.length + 1);
            locations[locations.length - 1] = new Location();
            return locations;
        }
        return locations;
    }

    public QuestTaskLocation(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
        this.register(EventHandler.Type.SERVER, EventHandler.Type.PLAYER);
    }

    private boolean visited(int id, EntityPlayer player) {
        return id < this.locations.length && ((QuestDataTaskLocation)this.getData((EntityPlayer)player)).visited[id];
    }

    public void setLocation(int id, Location location, EntityPlayer player) {
        if (id >= this.locations.length) {
            this.locations = Arrays.copyOf(this.locations, this.locations.length + 1);
            QuestDataTaskLocation data = (QuestDataTaskLocation)this.getData(player);
            data.visited = Arrays.copyOf(data.visited, data.visited.length + 1);
            SaveHelper.add(SaveHelper.EditType.LOCATION_CREATE);
        } else {
            SaveHelper.add(SaveHelper.EditType.LOCATION_CHANGE);
        }
        this.locations[id] = location;
    }

    public void setIcon(int id, ItemStack item, EntityPlayer player) {
        this.setLocation(id, id >= this.locations.length ? new Location() : this.locations[id], player);
        this.locations[id].icon = item;
    }

    public void setName(int id, String str, EntityPlayer player) {
        this.setLocation(id, id >= this.locations.length ? new Location() : this.locations[id], player);
        this.locations[id].name = str;
    }

    @Override
    public void save(DataWriter dw) {
        dw.writeData(this.locations.length, DataBitHelper.TASK_LOCATION_COUNT);
        for (Location location : this.locations) {
            location.save(dw);
        }
    }

    @Override
    public void load(DataReader dr, FileVersion version) {
        int count = dr.readData(DataBitHelper.TASK_LOCATION_COUNT);
        this.locations = new Location[count];
        for (int i = 0; i < this.locations.length; ++i) {
            this.locations[i] = new Location();
            this.locations[i].load(dr, version);
        }
    }

    @Override
    public void write(DataWriter dw, QuestDataTask task, boolean light) {
        super.write(dw, task, light);
        if (!light) {
            dw.writeData(((QuestDataTaskLocation)task).visited.length, DataBitHelper.TASK_LOCATION_COUNT);
        }
        for (boolean b : ((QuestDataTaskLocation)task).visited) {
            dw.writeBoolean(b);
        }
    }

    @Override
    public void read(DataReader dr, QuestDataTask task, FileVersion version, boolean light) {
        super.read(dr, task, version, light);
        QuestDataTaskLocation locationData = (QuestDataTaskLocation)task;
        if (light) {
            boolean[] visited = locationData.visited;
            for (int i = 0; i < visited.length; ++i) {
                visited[i] = dr.readBoolean();
            }
        } else {
            int count = dr.readData(DataBitHelper.TASK_LOCATION_COUNT);
            boolean[] visited = locationData.visited;
            for (int i = 0; i < count; ++i) {
                boolean val = dr.readBoolean();
                if (i >= visited.length) continue;
                visited[i] = val;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        Location[] locations = this.getEditFriendlyLocations(this.locations);
        for (int i = 0; i < locations.length; ++i) {
            Location location = locations[i];
            int x = 180;
            int y = 95 + i * 30;
            gui.drawItem(location.icon, x, y, mX, mY, false);
            gui.drawString(location.name, x + 23, y + 0, 0x404040);
            if (this.visited(i, player)) {
                gui.drawString((Object)((Object)GuiColor.GREEN) + Translator.translate("hqm.locationMenu.visited"), x + 23 + 0, y + 0 + 9, 0.7f, 0x404040);
                continue;
            }
            if (!location.visible.doShowCoordinate()) continue;
            if (location.radius >= 0) {
                gui.drawString("(" + location.x + ", " + location.y + ", " + location.z + ")", x + 23 + 0, y + 0 + 9, 0.7f, 0x404040);
            }
            if (player.field_70170_p.field_73011_w.field_76574_g == location.dimension) {
                if (location.radius < 0) continue;
                int distance = (int)player.func_70011_f((double)location.x + 0.5, (double)location.y + 0.5, (double)location.z + 0.5);
                String str = Translator.translate("hqm.locationMenu.mAway", distance);
                if (location.visible.doShowRadius()) {
                    str = str + " [" + Translator.translate("hqm.locationMenu.mRadius", location.radius) + "]";
                }
                gui.drawString(str, x + 23 + 0, y + 0 + 15, 0.7f, 0x404040);
                continue;
            }
            gui.drawString(Translator.translate("hqm.locationMenu.wrongDim"), x + 23 + 0, y + 0 + (location.radius >= 0 ? 15 : 9), 0.7f, 0x404040);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        if (Quest.isEditing && gui.getCurrentMode() != EditMode.NORMAL) {
            Location[] locations = this.getEditFriendlyLocations(this.locations);
            block6: for (int i = 0; i < locations.length; ++i) {
                Location location = locations[i];
                int x = 180;
                int y = 95 + i * 30;
                if (!gui.inBounds(x, y, 18, 18, mX, mY)) continue;
                switch (gui.getCurrentMode()) {
                    case LOCATION: {
                        gui.setEditMenu(new GuiEditMenuLocation(gui, this, location.copy(), i, player));
                        break;
                    }
                    case ITEM: {
                        gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, player, location.icon, i, GuiEditMenuItem.Type.LOCATION, 1, ItemPrecision.PRECISE));
                        break;
                    }
                    case RENAME: {
                        gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this, i, location));
                        break;
                    }
                    case DELETE: {
                        if (i >= this.locations.length) break block6;
                        Location[] newLocations = new Location[this.locations.length - 1];
                        int id = 0;
                        for (int j = 0; j < this.locations.length; ++j) {
                            if (j == i) continue;
                            newLocations[id] = this.locations[j];
                            ++id;
                        }
                        this.locations = newLocations;
                        SaveHelper.add(SaveHelper.EditType.LOCATION_REMOVE);
                        break;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void onUpdate(EntityPlayer player, DataReader dr) {
    }

    @Override
    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTaskLocation.class;
    }

    @Override
    public float getCompletedRatio(String playerName) {
        int visited = 0;
        for (boolean b : ((QuestDataTaskLocation)this.getData((String)playerName)).visited) {
            if (!b) continue;
            ++visited;
        }
        return (float)visited / (float)this.locations.length;
    }

    @Override
    public void mergeProgress(String playerName, QuestDataTask own, QuestDataTask other) {
        boolean[] visited = ((QuestDataTaskLocation)own).visited;
        boolean[] otherVisited = ((QuestDataTaskLocation)other).visited;
        boolean all = true;
        for (int i = 0; i < visited.length; ++i) {
            if (otherVisited[i]) {
                visited[i] = true;
                continue;
            }
            if (visited[i]) continue;
            all = false;
        }
        if (all) {
            this.completeTask(playerName);
        }
    }

    @Override
    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        super.copyProgress(own, other);
        boolean[] visited = ((QuestDataTaskLocation)own).visited;
        System.arraycopy(((QuestDataTaskLocation)other).visited, 0, visited, 0, visited.length);
    }

    @Override
    public void autoComplete(String playerName) {
        boolean[] visited = ((QuestDataTaskLocation)this.getData((String)playerName)).visited;
        for (int i = 0; i < visited.length; ++i) {
            visited[i] = true;
        }
    }

    public static enum Visibility {
        FULL("Full", true, true),
        LOCATION("Location", true, false),
        NONE("None", false, false);

        private boolean showCoordinate;
        private boolean showRadius;
        private String id;

        public boolean doShowCoordinate() {
            return this.showCoordinate;
        }

        public boolean doShowRadius() {
            return this.showRadius;
        }

        private Visibility(String id, boolean showCoordinate, boolean showRadius) {
            this.id = id;
            this.showCoordinate = showCoordinate;
            this.showRadius = showRadius;
        }

        public String getName() {
            return Translator.translate("hqm.locationMenu.vis" + this.id + ".title");
        }

        public String getDescription() {
            return Translator.translate("hqm.locationMenu.vis" + this.id + ".desc");
        }
    }

    public static class Location {
        private ItemStack icon;
        private String name = "New";
        private int x;
        private int y;
        private int z;
        private int radius = 3;
        private Visibility visible = Visibility.LOCATION;
        private int dimension;

        private Location copy() {
            Location location = new Location();
            location.icon = this.icon == null ? null : this.icon.func_77946_l();
            location.name = this.name;
            location.x = this.x;
            location.y = this.y;
            location.z = this.z;
            location.radius = this.radius;
            location.visible = this.visible;
            location.dimension = this.dimension;
            return location;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public void setIcon(ItemStack icon) {
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public int getZ() {
            return this.z;
        }

        public void setZ(int z) {
            this.z = z;
        }

        public int getRadius() {
            return this.radius;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public Visibility getVisible() {
            return this.visible;
        }

        public void setVisible(Visibility visible) {
            this.visible = visible;
        }

        public void save(DataWriter dw) {
            dw.writeBoolean(this.icon != null);
            if (this.icon != null) {
                dw.writeItem(this.icon.func_77973_b());
                dw.writeData(this.icon.func_77960_j(), DataBitHelper.SHORT);
                dw.writeNBT(this.icon.func_77978_p());
            }
            dw.writeString(this.name, DataBitHelper.NAME_LENGTH);
            dw.writeData(this.x, DataBitHelper.WORLD_COORDINATE);
            dw.writeData(this.y, DataBitHelper.WORLD_COORDINATE);
            dw.writeData(this.z, DataBitHelper.WORLD_COORDINATE);
            dw.writeData(this.radius, DataBitHelper.WORLD_COORDINATE);
            dw.writeData(this.visible.ordinal(), DataBitHelper.LOCATION_VISIBILITY);
            dw.writeData(this.dimension, DataBitHelper.WORLD_COORDINATE);
        }

        public void load(DataReader dr, FileVersion version) {
            if (dr.readBoolean()) {
                Item item = dr.readItem();
                int dmg = dr.readData(DataBitHelper.SHORT);
                NBTTagCompound compound = dr.readNBT();
                ItemStack itemStack = new ItemStack(item, 1, dmg);
                itemStack.func_77982_d(compound);
                this.icon = itemStack;
            } else {
                this.icon = null;
            }
            this.name = dr.readString(DataBitHelper.NAME_LENGTH);
            this.x = dr.readData(DataBitHelper.WORLD_COORDINATE);
            this.y = dr.readData(DataBitHelper.WORLD_COORDINATE);
            this.z = dr.readData(DataBitHelper.WORLD_COORDINATE);
            this.radius = dr.readData(DataBitHelper.WORLD_COORDINATE);
            this.visible = Visibility.values()[dr.readData(DataBitHelper.LOCATION_VISIBILITY)];
            this.dimension = dr.readData(DataBitHelper.WORLD_COORDINATE);
        }

        public int getDimension() {
            return this.dimension;
        }

        public void setDimension(int dimension) {
            this.dimension = dimension;
        }
    }
}

