/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import hardcorequesting.FileVersion;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.RepeatType;
import net.minecraft.entity.player.EntityPlayer;

public class RepeatInfo {
    private int days;
    private int hours;
    private RepeatType type;

    public RepeatInfo(RepeatType type, int days, int hours) {
        int total = Math.min(DataBitHelper.HOURS.getMaximum(), days * 24 + hours);
        this.days = total / 24;
        this.hours = hours % 24;
        this.type = type;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public RepeatType getType() {
        return this.type;
    }

    public String getMessage(Quest quest, EntityPlayer player) {
        return this.type.getMessage(quest, player, this.days, this.hours);
    }

    public String getShortMessage() {
        return this.type.getShortMessage(this.days, this.hours);
    }

    public void load(DataReader dr, FileVersion version) {
        if (version.contains(FileVersion.REPEATABLE_QUESTS)) {
            this.type = RepeatType.values()[dr.readData(DataBitHelper.REPEAT_TYPE)];
            if (this.type.isUseTime()) {
                int total = dr.readData(DataBitHelper.HOURS);
                this.days = total / 24;
                this.hours = total % 24;
            }
        } else {
            this.type = RepeatType.NONE;
        }
    }

    public void save(DataWriter dw) {
        dw.writeData(this.type.ordinal(), DataBitHelper.REPEAT_TYPE);
        if (this.type.isUseTime()) {
            int total = this.days * 24 + this.hours;
            dw.writeData(total, DataBitHelper.HOURS);
        }
    }
}

