/*
 * Decompiled with CFR 0.152.
 */
package dan200;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.registry.GameRegistry;
import dan200.qcraft.shared.BlockQBlock;
import dan200.qcraft.shared.BlockQuantumComputer;
import dan200.qcraft.shared.BlockQuantumLogic;
import dan200.qcraft.shared.BlockQuantumOre;
import dan200.qcraft.shared.BlockQuantumPortal;
import dan200.qcraft.shared.EncryptionRegistry;
import dan200.qcraft.shared.EncryptionSavedData;
import dan200.qcraft.shared.EntanglementSavedData;
import dan200.qcraft.shared.IQCraftProxy;
import dan200.qcraft.shared.ItemEOS;
import dan200.qcraft.shared.ItemMissing;
import dan200.qcraft.shared.ItemQuantumDust;
import dan200.qcraft.shared.ItemQuantumGoggles;
import dan200.qcraft.shared.LostLuggage;
import dan200.qcraft.shared.PacketHandler;
import dan200.qcraft.shared.PortalRegistry;
import dan200.qcraft.shared.QCraftCommand;
import dan200.qcraft.shared.QCraftPacket;
import dan200.qcraft.shared.TileEntityQuantumComputer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.multiplayer.ServerAddress;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

@Mod(modid="qCraft", name="qCraft", version="1.7.10-1.2.2")
public class QCraft {
    public static final int quantumComputerGUIID = 105;
    public static boolean enableQBlockOcclusionTesting = false;
    public static boolean enableWorldGen = true;
    public static boolean enableWorldGenReplacementRecipes = false;
    public static boolean letAdminsCreatePortals = true;
    public static boolean letPlayersCreatePortals = true;
    public static boolean letAdminsEditPortalServerList = true;
    public static boolean letPlayersEditPortalServerList = false;
    public static boolean letAdminsVerifyPortalServers = true;
    public static boolean letPlayersVerifyPortalServers = false;
    public static int maxPortalSize = 5;
    public static int maxQTPSize = 8;
    public static FMLEventChannel networkEventChannel;
    public static LostLuggage.Address travelNextTick;
    public static CreativeTabs creativeTab;
    @Mod.Instance(value="qCraft")
    public static QCraft instance;
    @SidedProxy(clientSide="dan200.qcraft.client.QCraftProxyClient", serverSide="dan200.qcraft.server.QCraftProxyServer")
    public static IQCraftProxy proxy;
    private static LostLuggage.Address s_currentServer;
    private static Map<String, Set<byte[]>> s_unverifiedLuggage;

    public static CreativeTabs getCreativeTab() {
        return creativeTab;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        Property prop = config.get("general", "enableQBlockOcclusionTesting", enableQBlockOcclusionTesting);
        prop.comment = "Set whether QBlocks should not be observed if their line of sight to the player is obstructed. WARNING: This has a very high performance cost if you have lots of QBlocks in your world!!";
        enableQBlockOcclusionTesting = prop.getBoolean(enableQBlockOcclusionTesting);
        prop = config.get("general", "enableWorldGen", enableWorldGen);
        prop.comment = "Set whether Quantum Ore will spawn in new chunks";
        enableWorldGen = prop.getBoolean(enableWorldGen);
        prop = config.get("general", "enableWorldGenReplacementRecipes", enableWorldGenReplacementRecipes);
        prop.comment = "Set whether Quantum Dust can be crafted instead of mined";
        enableWorldGenReplacementRecipes = prop.getBoolean(enableWorldGenReplacementRecipes);
        prop = config.get("general", "letAdminsCreatePortals", letAdminsCreatePortals);
        prop.comment = "Set whether server admins can energize portals";
        letAdminsCreatePortals = prop.getBoolean(letAdminsCreatePortals);
        prop = config.get("general", "letPlayersCreatePortals", letPlayersCreatePortals);
        prop.comment = "Set whether players can energize portals.";
        letPlayersCreatePortals = prop.getBoolean(letPlayersCreatePortals);
        prop = config.get("general", "letAdminsEditPortalServerList", letAdminsEditPortalServerList);
        prop.comment = "Set whether server admins can edit the list of Servers which portals can teleport to";
        letAdminsEditPortalServerList = prop.getBoolean(letAdminsEditPortalServerList);
        prop = config.get("general", "letPlayersEditPortalServerList", letPlayersEditPortalServerList);
        prop.comment = "Set whether players can edit the list of Servers which portals can teleport to";
        letPlayersEditPortalServerList = prop.getBoolean(letPlayersEditPortalServerList);
        prop = config.get("general", "letAdminsVerifyPortalServers", letAdminsVerifyPortalServers);
        prop.comment = "Set whether server admins can verify an inter-server portal link";
        letAdminsVerifyPortalServers = prop.getBoolean(letAdminsVerifyPortalServers);
        prop = config.get("general", "letPlayersVerifyPortalServers", letPlayersVerifyPortalServers);
        prop.comment = "Set whether players can verify an inter-server portal link";
        letPlayersVerifyPortalServers = prop.getBoolean(letPlayersVerifyPortalServers);
        prop = config.get("general", "maxPortalSize", maxPortalSize);
        prop.comment = "Set the maximum height and width for the Quantum Portal inside the frame in blocks. [min: 3, max: 16, def: 5]";
        int temp = prop.getInt(maxPortalSize);
        maxPortalSize = temp < 3 ? 3 : (temp > 16 ? 16 : prop.getInt(maxPortalSize));
        prop.set(maxPortalSize);
        prop = config.get("general", "maxQTPSize", maxQTPSize);
        prop.comment = "Set the maximum distance from the Quantum Computer that the quantization or teleportation field can extend in blocks. (3 means that there are 2 blocks between the computer and the pillar) [min: 1, max: 16, def: 8]";
        temp = prop.getInt(maxQTPSize);
        maxQTPSize = temp < 1 ? 1 : (temp > 16 ? 16 : prop.getInt(maxQTPSize));
        prop.set(maxQTPSize);
        config.save();
        networkEventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel("qCraft");
        networkEventChannel.register((Object)new PacketHandler());
        proxy.preLoad();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.load();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new QCraftCommand());
        EncryptionSavedData.get(QCraft.getDefWorld());
        EntanglementSavedData.get(QCraft.getDefWorld());
    }

    public static boolean isClient() {
        return proxy.isClient();
    }

    public static boolean isServer() {
        return !QCraft.isClient();
    }

    public static World getDefWorld() {
        return proxy.getDefWorld();
    }

    public static void openQuantumComputerGUI(EntityPlayer player, TileEntityQuantumComputer computer) {
        player.openGui((Object)instance, 105, player.field_70170_p, computer.field_145851_c, computer.field_145848_d, computer.field_145849_e);
    }

    private static FMLProxyPacket encode(QCraftPacket packet) {
        ByteBuf buffer = Unpooled.buffer();
        packet.toBytes(buffer);
        return new FMLProxyPacket(buffer, "qCraft");
    }

    public static void requestEnergize(TileEntityQuantumComputer computer) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = 1;
        packet.dataInt = new int[]{computer.field_145851_c, computer.field_145848_d, computer.field_145849_e};
        networkEventChannel.sendToServer(QCraft.encode(packet));
    }

    public static void requestCycleServerAddress(TileEntityQuantumComputer computer) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)7;
        packet.dataInt = new int[]{computer.field_145851_c, computer.field_145848_d, computer.field_145849_e};
        packet.dataString = new String[]{computer.getRemoteServerAddress()};
        networkEventChannel.sendToServer(QCraft.encode(packet));
    }

    public static void requestSetNewServerAddress(TileEntityQuantumComputer computer, String name, String address) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)8;
        packet.dataInt = new int[]{computer.field_145851_c, computer.field_145848_d, computer.field_145849_e};
        packet.dataString = new String[]{name, address};
        networkEventChannel.sendToServer(QCraft.encode(packet));
    }

    public static void requestRemoveServerAddress(TileEntityQuantumComputer computer) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)9;
        packet.dataInt = new int[]{computer.field_145851_c, computer.field_145848_d, computer.field_145849_e};
        packet.dataString = new String[]{computer.getRemoteServerAddress()};
        networkEventChannel.sendToServer(QCraft.encode(packet));
    }

    public static void requestSetRemotePortalID(TileEntityQuantumComputer computer, String remotePortalID) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)2;
        packet.dataInt = new int[]{computer.field_145851_c, computer.field_145848_d, computer.field_145849_e};
        packet.dataString = new String[]{remotePortalID};
        networkEventChannel.sendToServer(QCraft.encode(packet));
    }

    public static void requestSetPortalID(TileEntityQuantumComputer computer, String portalID) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)3;
        packet.dataInt = new int[]{computer.field_145851_c, computer.field_145848_d, computer.field_145849_e};
        packet.dataString = new String[]{portalID};
        networkEventChannel.sendToServer(QCraft.encode(packet));
    }

    public static void requestQueryGoToServer(EntityPlayer player, TileEntityQuantumComputer computer) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)10;
        packet.dataInt = new int[]{computer.field_145851_c, computer.field_145848_d, computer.field_145849_e};
        networkEventChannel.sendTo(QCraft.encode(packet), (EntityPlayerMP)player);
    }

    public static void requestConfirmGoToServer(TileEntityQuantumComputer computer, String destinationServer, boolean takeItems) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)11;
        packet.dataInt = new int[]{computer.field_145851_c, computer.field_145848_d, computer.field_145849_e, takeItems ? 1 : 0};
        packet.dataString = new String[]{destinationServer};
        networkEventChannel.sendToServer(QCraft.encode(packet));
    }

    public static void requestGoToServer(EntityPlayer player, String remoteAddress, byte[] luggage) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)4;
        packet.dataString = new String[]{remoteAddress};
        packet.dataByte = new byte[][]{luggage};
        networkEventChannel.sendTo(QCraft.encode(packet), (EntityPlayerMP)player);
    }

    public static void requestLuggage(EntityPlayer player) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)5;
        networkEventChannel.sendTo(QCraft.encode(packet), (EntityPlayerMP)player);
    }

    public static void requestDiscardLuggage(EntityPlayer player, byte[] luggage) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)12;
        packet.dataByte = new byte[][]{luggage};
        networkEventChannel.sendTo(QCraft.encode(packet), (EntityPlayerMP)player);
    }

    public static void requestUnpackLuggage(LostLuggage.LuggageMatch luggage) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)6;
        packet.dataByte = new byte[][]{luggage.m_luggage};
        packet.dataInt = new int[]{luggage.m_matchedDestination ? 1 : 0};
        networkEventChannel.sendToServer(QCraft.encode(packet));
    }

    public static boolean isPlayerWearingGoggles(EntityPlayer player) {
        return proxy.isPlayerWearingGoggles(player);
    }

    public static boolean isPlayerWearingQuantumGoggles(EntityPlayer player) {
        return proxy.isPlayerWearingQuantumGoggles(player);
    }

    public static boolean isLocalPlayerWearingGoggles() {
        return proxy.isLocalPlayerWearingGoggles();
    }

    public static boolean isLocalPlayerWearingQuantumGoggles() {
        return proxy.isLocalPlayerWearingQuantumGoggles();
    }

    public static boolean isPlayerOpped(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            return MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(player.func_146103_bH());
        }
        return false;
    }

    public static boolean canAnybodyCreatePortals() {
        return letAdminsCreatePortals || letPlayersCreatePortals;
    }

    public static boolean canPlayerCreatePortals(EntityPlayer player) {
        if (QCraft.isPlayerOpped(player)) {
            return letAdminsCreatePortals;
        }
        return letPlayersCreatePortals;
    }

    public static boolean canPlayerEditPortalServers(EntityPlayer player) {
        if (QCraft.isPlayerOpped(player)) {
            return letAdminsEditPortalServerList;
        }
        return letPlayersEditPortalServerList;
    }

    public static boolean canAnybodyVerifyPortalServers() {
        return letAdminsVerifyPortalServers || letPlayersVerifyPortalServers;
    }

    public static boolean canEverybodyVerifyPortalServers() {
        return letAdminsVerifyPortalServers && letPlayersVerifyPortalServers;
    }

    public static boolean canPlayerVerifyPortalServers(EntityPlayer player) {
        if (QCraft.isPlayerOpped(player)) {
            return letAdminsVerifyPortalServers;
        }
        return letPlayersVerifyPortalServers;
    }

    public static void renderQuantumGogglesOverlay(float width, float height) {
        proxy.renderQuantumGogglesOverlay(width, height);
    }

    public static void renderAOGogglesOverlay(float width, float height) {
        proxy.renderAOGogglesOverlay(width, height);
    }

    public static void handleServerPacket(QCraftPacket packet, EntityPlayer sender) {
        EntityPlayer entityPlayer = sender;
        World world = sender.func_130014_f_();
        switch (packet.packetType) {
            case 1: {
                int x = packet.dataInt[0];
                int y = packet.dataInt[1];
                int z = packet.dataInt[2];
                TileEntity entity = world.func_147438_o(x, y, z);
                if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                computer.tryEnergize();
                break;
            }
            case 3: {
                int x = packet.dataInt[0];
                int y = packet.dataInt[1];
                int z = packet.dataInt[2];
                TileEntity entity = world.func_147438_o(x, y, z);
                if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                if (!QCraft.canPlayerCreatePortals(entityPlayer) || computer.isTeleporterEnergized()) break;
                computer.setPortalID(packet.dataString[0]);
                world.func_147471_g(x, y, z);
                break;
            }
            case 2: {
                int x = packet.dataInt[0];
                int y = packet.dataInt[1];
                int z = packet.dataInt[2];
                TileEntity entity = world.func_147438_o(x, y, z);
                if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                if (!QCraft.canPlayerCreatePortals(entityPlayer) || computer.isTeleporterEnergized()) break;
                computer.setRemotePortalID(packet.dataString[0]);
                world.func_147471_g(x, y, z);
                break;
            }
            case 7: {
                int x = packet.dataInt[0];
                int y = packet.dataInt[1];
                int z = packet.dataInt[2];
                TileEntity entity = world.func_147438_o(x, y, z);
                if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                if (!QCraft.canPlayerCreatePortals(entityPlayer) || computer.isTeleporterEnergized()) break;
                computer.cycleRemoteServerAddress(packet.dataString[0]);
                world.func_147471_g(x, y, z);
                break;
            }
            case 8: {
                int x = packet.dataInt[0];
                int y = packet.dataInt[1];
                int z = packet.dataInt[2];
                TileEntity entity = world.func_147438_o(x, y, z);
                if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                String name = packet.dataString[0];
                String address = packet.dataString[1];
                if (QCraft.canPlayerEditPortalServers(entityPlayer) && name != null && address != null) {
                    PortalRegistry.PortalRegistry.registerServer(name, address);
                    EntanglementSavedData.get(world).func_76185_a();
                }
                TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                if (!QCraft.canPlayerCreatePortals(entityPlayer) || computer.isTeleporterEnergized()) break;
                computer.setRemoteServerAddress(address);
                world.func_147471_g(x, y, z);
                break;
            }
            case 9: {
                int x = packet.dataInt[0];
                int y = packet.dataInt[1];
                int z = packet.dataInt[2];
                TileEntity entity = world.func_147438_o(x, y, z);
                if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                String address = packet.dataString[0];
                if (QCraft.canPlayerEditPortalServers(entityPlayer) && address != null) {
                    PortalRegistry.PortalRegistry.unregisterServer(address);
                }
                TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                if (!QCraft.canPlayerCreatePortals(entityPlayer) || computer.isTeleporterEnergized()) break;
                computer.setRemoteServerAddress(null);
                world.func_147471_g(x, y, z);
                break;
            }
            case 11: {
                int x = packet.dataInt[0];
                int y = packet.dataInt[1];
                int z = packet.dataInt[2];
                TileEntity entity = world.func_147438_o(x, y, z);
                if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                boolean takeItems = packet.dataInt[3] > 0;
                String expectedServer = packet.dataString[0];
                TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                String actualServer = computer.getRemoteServerAddress();
                if (!computer.isTeleporterEnergized() || expectedServer == null || actualServer == null || !expectedServer.equals(actualServer)) break;
                computer.teleportPlayerRemote(entityPlayer, takeItems);
                break;
            }
            case 6: {
                byte[] signedLuggageData = packet.dataByte[0];
                boolean isDestination = packet.dataInt[0] > 0;
                boolean teleported = false;
                QCraft.unpackLuggage(entityPlayer, entityPlayer, signedLuggageData, isDestination, teleported, false);
                break;
            }
        }
    }

    public static void handleClientPacket(QCraftPacket packet) {
        EntityPlayer entityPlayer = proxy.getLocalPlayer();
        World world = entityPlayer.func_130014_f_();
        switch (packet.packetType) {
            case 10: {
                TileEntityQuantumComputer computer;
                int x = packet.dataInt[0];
                int y = packet.dataInt[1];
                int z = packet.dataInt[2];
                TileEntity entity = world.func_147438_o(x, y, z);
                if (entity == null || !(entity instanceof TileEntityQuantumComputer) || (computer = (TileEntityQuantumComputer)entity).getRemoteServerAddress() == null) break;
                proxy.showItemTransferGUI(entityPlayer, computer);
                break;
            }
            case 4: {
                String destination = packet.dataString[0];
                byte[] luggage = packet.dataByte[0];
                LostLuggage.Address destinationAddress = QCraft.resolveServerAddress(destination);
                LostLuggage.Instance.load();
                LostLuggage.Instance.storeLuggage(QCraft.getCurrentServerAddress(), destinationAddress, luggage);
                LostLuggage.Instance.save();
                travelNextTick = destinationAddress;
                break;
            }
            case 5: {
                LostLuggage.Address address = QCraft.getCurrentServerAddress();
                if (address == null) break;
                LostLuggage.Instance.load();
                LostLuggage.Instance.removeOldLuggage();
                Collection<LostLuggage.LuggageMatch> luggages = LostLuggage.Instance.getMatchingLuggage(address);
                if (luggages.size() > 0) {
                    for (LostLuggage.LuggageMatch match : luggages) {
                        QCraft.requestUnpackLuggage(match);
                    }
                }
                LostLuggage.Instance.save();
                break;
            }
            case 12: {
                LostLuggage.Instance.load();
                byte[] luggage = packet.dataByte[0];
                LostLuggage.Instance.removeLuggage(luggage);
                LostLuggage.Instance.save();
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static LuggageVerificationResult verifyIncomingLuggage(EntityPlayer instigator, EntityPlayer entityPlayer, byte[] signedLuggageData, boolean forceVerify) throws IOException {
        PublicKey key;
        boolean luggageFromLocalServer;
        NBTTagCompound luggage;
        byte[] luggageData;
        NBTTagCompound signedLuggage;
        block15: {
            signedLuggage = CompressedStreamTools.func_152457_a((byte[])signedLuggageData, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            luggageData = signedLuggage.func_74770_j("luggage");
            luggage = CompressedStreamTools.func_152457_a((byte[])luggageData, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            if (!signedLuggage.func_74764_b("key")) {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Portal Link failed:"));
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Signature missing."));
                QCraft.requestDiscardLuggage(entityPlayer, signedLuggageData);
                return LuggageVerificationResult.UNTRUSTED;
            }
            luggageFromLocalServer = false;
            key = EncryptionRegistry.Instance.decodePublicKey(signedLuggage.func_74770_j("key"));
            if (EncryptionRegistry.Instance.getLocalKeyPair().getPublic().equals(key)) {
                QCraft.log("Player " + entityPlayer.getDisplayName() + " has luggage from this server.");
                luggageFromLocalServer = true;
            } else {
                if (!EncryptionRegistry.Instance.getVerifiedPublicKeys().contains(key)) {
                    if (forceVerify) {
                        QCraft.log("Player " + entityPlayer.getDisplayName() + " has luggage from unverified server. Verifying.");
                        EncryptionRegistry.Instance.getVerifiedPublicKeys().add(key);
                        instigator.func_145747_a((IChatComponent)new ChatComponentText("Portal Link verified."));
                        if (instigator != entityPlayer) {
                            instigator.func_145747_a((IChatComponent)new ChatComponentText("Portal Link verified"));
                        }
                        EncryptionSavedData.get(QCraft.getDefWorld()).func_76185_a();
                        break block15;
                    } else {
                        QCraft.log("Player " + entityPlayer.getDisplayName() + " has luggage from unverified server. Ignoring.");
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Portal Link failed:"));
                        if (QCraft.canAnybodyVerifyPortalServers()) {
                            if (QCraft.canEverybodyVerifyPortalServers()) {
                                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("The server link must be verified first."));
                            } else {
                                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("The server link must be verified by an admin first."));
                            }
                            QCraft.addUnverifiedLuggage(entityPlayer, signedLuggageData);
                        } else {
                            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("This server does not allow incoming inter-server portals."));
                        }
                        boolean canVerify = QCraft.canPlayerVerifyPortalServers(entityPlayer);
                        boolean hasItems = luggage.func_74764_b("items");
                        if (canVerify && hasItems) {
                            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Type \"/qcraft verify\" to do this now, or return to the original server within 24 hours to get your items back."));
                            return LuggageVerificationResult.UNTRUSTED;
                        }
                        if (canVerify) {
                            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Type \"/qcraft verify\" to do this now."));
                            return LuggageVerificationResult.UNTRUSTED;
                        }
                        if (!hasItems) return LuggageVerificationResult.UNTRUSTED;
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Return to the original server within 24 hours to get your items back."));
                        return LuggageVerificationResult.UNTRUSTED;
                    }
                }
                QCraft.log("Player " + entityPlayer.getDisplayName() + " has luggage from verified server.");
            }
        }
        byte[] luggageSignature = signedLuggage.func_74770_j("signature");
        if (!EncryptionRegistry.Instance.verifyData(key, luggageSignature, luggageData)) {
            QCraft.log("Player " + entityPlayer.getDisplayName() + "'s luggage failed signature check. Ignoring.");
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Portal Link failed:"));
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Signature violation."));
            QCraft.requestDiscardLuggage(entityPlayer, signedLuggageData);
            return LuggageVerificationResult.UNTRUSTED;
        }
        UUID uuid = UUID.fromString(luggage.func_74779_i("uuid"));
        if (EncryptionRegistry.Instance.getReceivedLuggageIDs().contains(uuid)) {
            QCraft.log("Player " + entityPlayer.getDisplayName() + "'s luggage is a duplicate. Ignoring.");
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Portal Link failed:"));
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Luggage duplicate."));
            QCraft.requestDiscardLuggage(entityPlayer, signedLuggageData);
            return LuggageVerificationResult.UNTRUSTED;
        }
        EncryptionRegistry.Instance.getReceivedLuggageIDs().add(uuid);
        EncryptionSavedData.get(QCraft.getDefWorld()).func_76185_a();
        QCraft.requestDiscardLuggage(entityPlayer, signedLuggageData);
        if (!luggageFromLocalServer) return LuggageVerificationResult.TRUSTED;
        return LuggageVerificationResult.LOCALKEY;
    }

    private static boolean unpackLuggage(EntityPlayer instigator, EntityPlayer entityPlayer, byte[] signedLuggageData, boolean isDestination, boolean alreadyTeleported, boolean forceVerify) {
        try {
            LuggageVerificationResult verificationResult = QCraft.verifyIncomingLuggage(instigator, entityPlayer, signedLuggageData, forceVerify);
            if (verificationResult != LuggageVerificationResult.UNTRUSTED) {
                NBTTagCompound signedLuggage = CompressedStreamTools.func_152457_a((byte[])signedLuggageData, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                byte[] luggageData = signedLuggage.func_74770_j("luggage");
                NBTTagCompound luggage = CompressedStreamTools.func_152457_a((byte[])luggageData, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                if (luggage.func_74764_b("items")) {
                    if (verificationResult == LuggageVerificationResult.LOCALKEY && !isDestination) {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Previous attempted Portal Link failed, restoring inventory."));
                    }
                    NBTTagList items = luggage.func_150295_c("items", 10);
                    QCraft.log("Adding " + items.func_74745_c() + " items to " + entityPlayer.getDisplayName() + "'s inventory");
                    for (int i = 0; i < items.func_74745_c(); ++i) {
                        NBTTagCompound itemNBT = items.func_150305_b(i);
                        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)itemNBT);
                        String oldName = itemNBT.func_74779_i("Name");
                        String newName = "";
                        if (stack != null) {
                            GameRegistry.UniqueIdentifier uniqueId = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
                            newName = uniqueId.modId + ":" + uniqueId.name;
                        }
                        if (!oldName.equals(newName)) {
                            GameRegistry.UniqueIdentifier oldUniqueId = new GameRegistry.UniqueIdentifier(oldName);
                            int newID = Item.func_150891_b((Item)GameRegistry.findItem((String)oldUniqueId.modId, (String)oldUniqueId.name));
                            if (newID < 1) {
                                stack = new ItemStack((Item)Items.missingItem);
                                stack.field_77990_d = itemNBT;
                            } else {
                                itemNBT.func_74777_a("id", (short)newID);
                                stack = ItemStack.func_77949_a((NBTTagCompound)itemNBT);
                            }
                        }
                        if (entityPlayer.field_71071_by.func_70441_a(stack)) continue;
                        entityPlayer.func_70099_a(stack, 1.5f);
                    }
                    entityPlayer.field_71071_by.func_70296_d();
                }
                if (!alreadyTeleported && luggage.func_74764_b("destinationPortal") && (verificationResult == LuggageVerificationResult.TRUSTED || verificationResult == LuggageVerificationResult.LOCALKEY && isDestination)) {
                    String destination = luggage.func_74779_i("destinationPortal");
                    TileEntityQuantumComputer.PortalLocation location = PortalRegistry.PortalRegistry.getPortal(destination);
                    if (location != null) {
                        QCraft.log("Teleporting " + entityPlayer.getDisplayName() + " to portal \"" + destination + "\"");
                        TileEntityQuantumComputer.teleportPlayerLocal(entityPlayer, destination);
                    } else {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Portal Link failed:"));
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("There is no portal on this server called \"" + destination + "\""));
                    }
                    alreadyTeleported = true;
                }
            }
            return alreadyTeleported;
        }
        catch (IOException e) {
            throw new RuntimeException("Error unpacking luggage");
        }
    }

    public static void spawnQuantumDustFX(World world, double x, double y, double z) {
        proxy.spawnQuantumDustFX(world, x, y, z);
    }

    public static LostLuggage.Address resolveServerAddress(String addressString) {
        ServerAddress address = ServerAddress.func_78860_a((String)addressString);
        if (address != null) {
            return new LostLuggage.Address(address.func_78861_a() + ":" + address.func_78864_b());
        }
        return null;
    }

    public static void setCurrentServerAddress(String addressString) {
        s_currentServer = addressString != null ? QCraft.resolveServerAddress(addressString) : null;
    }

    public static LostLuggage.Address getCurrentServerAddress() {
        return s_currentServer;
    }

    public static void addUnverifiedLuggage(EntityPlayer player, byte[] luggage) {
        Set<byte[]> luggageSet;
        String username = player.func_70005_c_();
        if (!s_unverifiedLuggage.containsKey(username)) {
            s_unverifiedLuggage.put(username, new HashSet());
        }
        if (!(luggageSet = s_unverifiedLuggage.get(username)).contains(luggage)) {
            luggageSet.add(luggage);
        }
    }

    public static void clearUnverifiedLuggage(EntityPlayer player) {
        String username = player.func_70005_c_();
        if (s_unverifiedLuggage.containsKey(username)) {
            s_unverifiedLuggage.remove(username);
        }
    }

    public static void verifyUnverifiedLuggage(EntityPlayer instigator, EntityPlayer player) {
        String username = player.func_70005_c_();
        if (s_unverifiedLuggage.containsKey(username)) {
            Set<byte[]> luggageSet = s_unverifiedLuggage.remove(username);
            boolean teleported = false;
            for (byte[] signedLuggageData : luggageSet) {
                if (!QCraft.unpackLuggage(instigator, player, signedLuggageData, true, teleported, true)) continue;
                teleported = true;
            }
        }
    }

    public static void log(String text) {
        FMLLog.info((String)("[qCraft] " + text), (Object[])new Object[]{0});
    }

    static {
        s_currentServer = null;
        s_unverifiedLuggage = new HashMap<String, Set<byte[]>>();
    }

    private static enum LuggageVerificationResult {
        UNTRUSTED,
        TRUSTED,
        LOCALKEY;

    }

    public static class Items {
        public static ItemQuantumDust quantumDust;
        public static ItemEOS eos;
        public static ItemQuantumGoggles quantumGoggles;
        public static ItemMissing missingItem;
    }

    public static class Blocks {
        public static BlockQuantumOre quantumOre;
        public static BlockQuantumOre quantumOreGlowing;
        public static BlockQuantumLogic quantumLogic;
        public static BlockQBlock qBlock;
        public static BlockQuantumComputer quantumComputer;
        public static BlockQuantumPortal quantumPortal;
    }
}

