/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import dan200.QCraft;
import dan200.qcraft.shared.ItemQuantumComputer;
import dan200.qcraft.shared.TileEntityQuantumComputer;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockQuantumComputer
extends BlockDirectional
implements ITileEntityProvider {
    public BlockQuantumComputer() {
        super(Material.field_151573_f);
        this.func_149647_a(QCraft.getCreativeTab());
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c("qcraft:computer");
    }

    public boolean func_149662_c() {
        return false;
    }

    public Item func_149650_a(int i, Random random, int j) {
        return Item.func_150898_a((Block)this);
    }

    public int func_149692_a(int i) {
        return 0;
    }

    public void func_149690_a(World world, int x, int y, int z, int side, float f, int unknown) {
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> blocks = new ArrayList<ItemStack>();
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null && entity instanceof TileEntityQuantumComputer) {
            TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
            ItemStack stack = ItemQuantumComputer.create(computer.getEntanglementFrequency(), 1);
            ItemQuantumComputer.setStoredData(stack, computer.getStoredData());
            blocks.add(stack);
        }
        return blocks;
    }

    protected boolean shouldDropItemsInCreative(World world, int x, int y, int z) {
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.field_72995_K) {
            return false;
        }
        if (!player.field_71075_bZ.field_75098_d || this.shouldDropItemsInCreative(world, x, y, z)) {
            int metadata = world.func_72805_g(x, y, z);
            ArrayList<ItemStack> items = this.getDrops(world, x, y, z, metadata, 0);
            for (ItemStack item : items) {
                this.func_149642_a(world, x, y, z, item);
            }
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        ArrayList<ItemStack> items = this.getDrops(world, x, y, z, metadata, 0);
        if (items.size() > 0) {
            return items.get(0);
        }
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int l, float m, float n, float o) {
        TileEntity entity;
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K && (entity = world.func_147438_o(x, y, z)) != null && entity instanceof TileEntityQuantumComputer) {
            TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
            QCraft.openQuantumComputerGUI(player, computer);
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null && entity instanceof TileEntityQuantumComputer) {
            TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
            computer.onDestroy();
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int direction = ((MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) + 2) % 4;
        int metadata = direction & 3;
        world.func_72921_c(x, y, z, metadata, 3);
    }

    public void func_149695_a(World world, int x, int y, int z, Block id) {
        super.func_149695_a(world, x, y, z, id);
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null && entity instanceof TileEntityQuantumComputer) {
            TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
            computer.setRedstonePowered(world.func_72864_z(x, y, z));
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        Icons.Front = iconRegister.func_94245_a("qcraft:computer");
        Icons.Top = iconRegister.func_94245_a("qcraft:computer_top");
        Icons.Side = iconRegister.func_94245_a("qcraft:computer_side");
    }

    public IIcon func_149673_e(IBlockAccess world, int i, int j, int k, int side) {
        if (side == 0 || side == 1) {
            return Icons.Top;
        }
        int metadata = world.func_72805_g(i, j, k);
        int direction = Direction.field_71582_c[BlockQuantumComputer.func_149895_l((int)metadata)];
        if (side == direction) {
            return Icons.Front;
        }
        return Icons.Side;
    }

    public IIcon func_149691_a(int side, int damage) {
        switch (side) {
            case 0: 
            case 1: {
                return Icons.Top;
            }
            case 4: {
                return Icons.Front;
            }
        }
        return Icons.Side;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityQuantumComputer();
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return this.func_149915_a(world, metadata);
    }

    private static class Icons {
        public static IIcon Front;
        public static IIcon Top;
        public static IIcon Side;

        private Icons() {
        }
    }
}

