/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import dan200.QCraft;
import dan200.qcraft.shared.ItemQBlock;
import dan200.qcraft.shared.TileEntityQBlock;
import dan200.qcraft.shared.TileEntityQuantumComputer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemQuantumComputer
extends ItemBlock {
    public ItemQuantumComputer(Block block) {
        super(block);
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77655_b("qcraft:computer");
        this.func_77637_a(QCraft.getCreativeTab());
    }

    public static ItemStack create(int entanglementFrequency, int quantity) {
        ItemStack result = new ItemStack((Block)QCraft.Blocks.quantumComputer, quantity, 0);
        ItemQuantumComputer.setEntanglementFrequency(result, entanglementFrequency);
        return result;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        list.add(ItemQuantumComputer.create(-1, 1));
    }

    public static void setEntanglementFrequency(ItemStack stack, int entanglementFrequency) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (entanglementFrequency < 0) {
            if (nbt.func_74764_b("e")) {
                nbt.func_82580_o("e");
            }
            if (nbt.func_74764_b("R")) {
                nbt.func_82580_o("R");
            }
        } else if (entanglementFrequency == 0) {
            nbt.func_74768_a("e", entanglementFrequency);
            nbt.func_74768_a("R", TileEntityQBlock.s_random.nextInt(0xFFFFFF));
        } else {
            nbt.func_74768_a("e", entanglementFrequency);
            if (nbt.func_74764_b("R")) {
                nbt.func_82580_o("R");
            }
        }
    }

    public static int getEntanglementFrequency(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("e")) {
            int frequency = nbt.func_74762_e("e");
            return frequency;
        }
        return -1;
    }

    public static void setStoredData(ItemStack stack, TileEntityQuantumComputer.AreaData data) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (data != null) {
            nbt.func_74782_a("d", (NBTBase)data.encode());
        } else if (nbt.func_74764_b("d")) {
            nbt.func_82580_o("d");
        }
    }

    public static TileEntityQuantumComputer.AreaData getStoredData(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("d")) {
            return TileEntityQuantumComputer.AreaData.decode(nbt.func_74775_l("d"));
        }
        return null;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (ItemQuantumComputer.getEntanglementFrequency(stack) == 0 && !world.field_72995_K) {
            ItemQuantumComputer.setEntanglementFrequency(stack, TileEntityQuantumComputer.getEntanglementRegistry(world).getUnusedFrequency());
            player.field_71071_by.func_70296_d();
            if (player.field_71070_bA != null) {
                player.field_71070_bA.func_75142_b();
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileEntity entity = world.func_147438_o(x, y, z);
            if (entity != null && entity instanceof TileEntityQuantumComputer) {
                TileEntityQuantumComputer quantum = (TileEntityQuantumComputer)entity;
                quantum.setEntanglementFrequency(ItemQuantumComputer.getEntanglementFrequency(stack));
                quantum.setStoredData(ItemQuantumComputer.getStoredData(stack));
            }
            return true;
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        if (ItemQuantumComputer.getEntanglementFrequency(stack) >= 0) {
            return "tile.qcraft:computer_entangled";
        }
        return "tile.qcraft:computer";
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        TileEntityQuantumComputer.AreaData data;
        int frequency = ItemQuantumComputer.getEntanglementFrequency(stack);
        if (frequency > 0) {
            list.add("Group: " + ItemQBlock.formatFrequency(frequency));
        }
        if ((data = ItemQuantumComputer.getStoredData(stack)) != null) {
            int w = data.m_shape.m_xMax - data.m_shape.m_xMin + 1;
            int h = data.m_shape.m_yMax - data.m_shape.m_yMin + 1;
            int l = data.m_shape.m_zMax - data.m_shape.m_zMin + 1;
            list.add("Stored Area: " + w + "m x " + l + "m x " + h + "m");
        }
    }
}

