/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import com.google.common.base.CaseFormat;
import cpw.mods.fml.common.registry.GameRegistry;
import dan200.QCraft;
import dan200.qcraft.shared.EncryptionRegistry;
import dan200.qcraft.shared.EntanglementRegistry;
import dan200.qcraft.shared.EntanglementSavedData;
import dan200.qcraft.shared.ItemQBlock;
import dan200.qcraft.shared.ItemQuantumComputer;
import dan200.qcraft.shared.PortalRegistry;
import dan200.qcraft.shared.QuantumTeleporter;
import dan200.qcraft.shared.TileEntityQBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;

public class TileEntityQuantumComputer
extends TileEntity {
    public static final EntanglementRegistry<TileEntityQuantumComputer> ComputerRegistry = new EntanglementRegistry();
    public static final EntanglementRegistry<TileEntityQuantumComputer> ClientComputerRegistry = new EntanglementRegistry();
    private static boolean tooManyPossiblePortals = false;
    private boolean m_powered = false;
    private int m_entanglementFrequency = -1;
    private int m_timeSinceEnergize = 0;
    private AreaData m_storedData = null;
    private String m_portalID = null;
    private boolean m_portalNameConflict = false;
    private String m_remoteServerAddress = null;
    private String m_remoteServerName = null;
    private String m_remotePortalID = null;

    public static EntanglementRegistry<TileEntityQuantumComputer> getEntanglementRegistry(World world) {
        if (!world.field_72995_K) {
            return ComputerRegistry;
        }
        return ClientComputerRegistry;
    }

    private EntanglementRegistry<TileEntityQuantumComputer> getEntanglementRegistry() {
        return TileEntityQuantumComputer.getEntanglementRegistry(this.field_145850_b);
    }

    private PortalRegistry getPortalRegistry() {
        return PortalRegistry.getPortalRegistry(this.field_145850_b);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.register();
    }

    public void func_145843_s() {
        this.unregister();
        super.func_145843_s();
    }

    public void onDestroy() {
        PortalLocation location = this.getPortal();
        if (location != null && this.isPortalDeployed(location)) {
            this.undeployPortal(location);
        }
        this.unregisterPortal();
    }

    private void register() {
        if (this.m_entanglementFrequency >= 0) {
            this.getEntanglementRegistry().register(this.m_entanglementFrequency, this, this.func_145831_w());
        }
    }

    private void unregister() {
        if (this.m_entanglementFrequency >= 0) {
            this.getEntanglementRegistry().unregister(this.m_entanglementFrequency, this, this.func_145831_w());
        }
    }

    public void setEntanglementFrequency(int frequency) {
        if (this.m_entanglementFrequency != frequency) {
            this.unregister();
            this.m_entanglementFrequency = frequency;
            this.register();
        }
    }

    public int getEntanglementFrequency() {
        return this.m_entanglementFrequency;
    }

    private TileEntityQuantumComputer findEntangledTwin() {
        List<TileEntityQuantumComputer> twins;
        if (this.m_entanglementFrequency >= 0 && (twins = ComputerRegistry.getEntangledObjects(this.m_entanglementFrequency)) != null) {
            for (TileEntityQuantumComputer computer : twins) {
                if (computer == this) continue;
                return computer;
            }
        }
        return null;
    }

    public void setStoredData(AreaData data) {
        this.m_storedData = data;
    }

    public AreaData getStoredData() {
        return this.m_storedData;
    }

    private boolean isPillarBase(int x, int y, int z, int side) {
        if (y < 0 || y >= 256) {
            return false;
        }
        TileEntity entity = this.field_145850_b.func_147438_o(x, y, z);
        if (entity != null && entity instanceof TileEntityQBlock) {
            TileEntityQBlock quantum = (TileEntityQBlock)entity;
            int[] types = quantum.getTypes();
            for (int i = 0; i < 6; ++i) {
                if (!(i == side ? types[i] != 31 : types[i] != 21)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isPillar(int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return false;
        }
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        return block == Blocks.field_150343_Z;
    }

    private boolean isGlass(int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return false;
        }
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        return block.func_149688_o() == Material.field_151592_s && !(block instanceof BlockPane);
    }

    private AreaShape calculateShape() {
        int i;
        AreaShape shape = new AreaShape();
        shape.m_xMin = -99;
        shape.m_xMax = -99;
        shape.m_yMin = 0;
        shape.m_yMax = 0;
        shape.m_zMin = -99;
        shape.m_zMax = -99;
        for (i = 0; i < QCraft.maxQTPSize; ++i) {
            if (shape.m_xMin == -99 && this.isPillarBase(this.field_145851_c - i - 1, this.field_145848_d, this.field_145849_e, 5)) {
                shape.m_xMin = -i;
            }
            if (shape.m_xMax == -99 && this.isPillarBase(this.field_145851_c + i + 1, this.field_145848_d, this.field_145849_e, 4)) {
                shape.m_xMax = i;
            }
            if (shape.m_zMin == -99 && this.isPillarBase(this.field_145851_c, this.field_145848_d, this.field_145849_e - i - 1, 3)) {
                shape.m_zMin = -i;
            }
            if (shape.m_zMax != -99 || !this.isPillarBase(this.field_145851_c, this.field_145848_d, this.field_145849_e + i + 1, 2)) continue;
            shape.m_zMax = i;
        }
        if (shape.m_xMin != -99 && shape.m_xMax != -99 && shape.m_zMin != -99 && shape.m_zMax != -99) {
            for (i = 1; i < QCraft.maxQTPSize && this.isPillar(this.field_145851_c + shape.m_xMin - 1, this.field_145848_d - i, this.field_145849_e) && this.isPillar(this.field_145851_c + shape.m_xMax + 1, this.field_145848_d - i, this.field_145849_e) && this.isPillar(this.field_145851_c, this.field_145848_d - i, this.field_145849_e + shape.m_zMin - 1) && this.isPillar(this.field_145851_c, this.field_145848_d - i, this.field_145849_e + shape.m_zMax + 1); ++i) {
                shape.m_yMin = -i;
            }
            i = 1;
            while (i < QCraft.maxQTPSize && this.isPillar(this.field_145851_c + shape.m_xMin - 1, this.field_145848_d + i, this.field_145849_e) && this.isPillar(this.field_145851_c + shape.m_xMax + 1, this.field_145848_d + i, this.field_145849_e) && this.isPillar(this.field_145851_c, this.field_145848_d + i, this.field_145849_e + shape.m_zMin - 1) && this.isPillar(this.field_145851_c, this.field_145848_d + i, this.field_145849_e + shape.m_zMax + 1)) {
                shape.m_yMax = i++;
            }
            int top = this.field_145848_d + shape.m_yMax + 1;
            if (this.isGlass(this.field_145851_c + shape.m_xMin - 1, top, this.field_145849_e) && this.isGlass(this.field_145851_c + shape.m_xMax + 1, top, this.field_145849_e) && this.isGlass(this.field_145851_c, top, this.field_145849_e + shape.m_zMin - 1) && this.isGlass(this.field_145851_c, top, this.field_145849_e + shape.m_zMax + 1)) {
                return shape;
            }
        }
        return null;
    }

    private AreaData storeArea() {
        AreaShape shape = this.calculateShape();
        if (shape == null) {
            return null;
        }
        AreaData storedData = new AreaData();
        int minX = shape.m_xMin;
        int maxX = shape.m_xMax;
        int minY = shape.m_yMin;
        int maxY = shape.m_yMax;
        int minZ = shape.m_zMin;
        int maxZ = shape.m_zMax;
        int size = (maxX - minX + 1) * (maxY - minY + 1) * (maxZ - minZ + 1);
        int index = 0;
        storedData.m_shape = shape;
        storedData.m_blocks = new Block[size];
        storedData.m_metaData = new int[size];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int worldX = this.field_145851_c + x;
                    int worldY = this.field_145848_d + y;
                    int worldZ = this.field_145849_e + z;
                    if (worldX != this.field_145851_c || worldY != this.field_145848_d || worldZ != this.field_145849_e) {
                        TileEntity tileentity = this.field_145850_b.func_147438_o(worldX, worldY, worldZ);
                        if (tileentity != null) {
                            return null;
                        }
                        Block block = this.field_145850_b.func_147439_a(worldX, worldY, worldZ);
                        int meta = this.field_145850_b.func_72805_g(worldX, worldY, worldZ);
                        storedData.m_blocks[index] = block;
                        storedData.m_metaData[index] = meta;
                    }
                    ++index;
                }
            }
        }
        return storedData;
    }

    private void notifyBlockOfNeighborChange(int x, int y, int z) {
        this.field_145850_b.func_147460_e(x, y, z, this.field_145850_b.func_147439_a(x, y, z));
    }

    private void notifyEdgeBlocks(AreaShape shape) {
        int z;
        int x;
        int minX = shape.m_xMin;
        int maxX = shape.m_xMax;
        int minY = shape.m_yMin;
        int maxY = shape.m_yMax;
        int minZ = shape.m_zMin;
        int maxZ = shape.m_zMax;
        for (x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                this.notifyBlockOfNeighborChange(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + minZ);
                this.notifyBlockOfNeighborChange(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + maxZ);
                this.notifyBlockOfNeighborChange(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + minZ);
                this.notifyBlockOfNeighborChange(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + maxZ + 1);
            }
        }
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                this.notifyBlockOfNeighborChange(this.field_145851_c + x, this.field_145848_d + minY, this.field_145849_e + z);
                this.notifyBlockOfNeighborChange(this.field_145851_c + x, this.field_145848_d + maxY, this.field_145849_e + z);
                this.notifyBlockOfNeighborChange(this.field_145851_c + x, this.field_145848_d + minY - 1, this.field_145849_e + z);
                this.notifyBlockOfNeighborChange(this.field_145851_c + x, this.field_145848_d + maxY + 1, this.field_145849_e + z);
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (z = minZ; z <= maxZ; ++z) {
                this.notifyBlockOfNeighborChange(this.field_145851_c + minX, this.field_145848_d + y, this.field_145849_e + z);
                this.notifyBlockOfNeighborChange(this.field_145851_c + maxX, this.field_145848_d + y, this.field_145849_e + z);
                this.notifyBlockOfNeighborChange(this.field_145851_c + minX - 1, this.field_145848_d + y, this.field_145849_e + z);
                this.notifyBlockOfNeighborChange(this.field_145851_c + maxX + 1, this.field_145848_d + y, this.field_145849_e + z);
            }
        }
    }

    private Set<EntityItem> getEntityItemsInArea(AreaShape shape) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c + shape.m_xMin), (double)(this.field_145848_d + shape.m_yMin), (double)(this.field_145849_e + shape.m_zMin), (double)(this.field_145851_c + shape.m_xMax + 1), (double)(this.field_145848_d + shape.m_yMax + 1), (double)(this.field_145849_e + shape.m_zMax + 1));
        List list = this.field_145850_b.func_72839_b(null, aabb);
        HashSet<EntityItem> set = new HashSet<EntityItem>();
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityItem) || entity.field_70128_L) continue;
            set.add((EntityItem)entity);
        }
        return set;
    }

    private void killNewItems(Set<EntityItem> before, Set<EntityItem> after) {
        for (EntityItem item : after) {
            if (item.field_70128_L || before.contains(item)) continue;
            item.func_70106_y();
        }
    }

    private void clearArea(AreaShape shape) {
        Set<EntityItem> before = this.getEntityItemsInArea(shape);
        int minX = shape.m_xMin;
        int maxX = shape.m_xMax;
        int minY = shape.m_yMin;
        int maxY = shape.m_yMax;
        int minZ = shape.m_zMin;
        int maxZ = shape.m_zMax;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int worldX = this.field_145851_c + x;
                    int worldY = this.field_145848_d + y;
                    int worldZ = this.field_145849_e + z;
                    if (worldX == this.field_145851_c && worldY == this.field_145848_d && worldZ == this.field_145849_e) continue;
                    this.field_145850_b.func_147468_f(worldX, worldY, worldZ);
                }
            }
        }
        Set<EntityItem> after = this.getEntityItemsInArea(shape);
        this.killNewItems(before, after);
        this.notifyEdgeBlocks(shape);
    }

    private void unpackArea(AreaData storedData) {
        Set<EntityItem> before = this.getEntityItemsInArea(storedData.m_shape);
        int index = 0;
        int minX = storedData.m_shape.m_xMin;
        int maxX = storedData.m_shape.m_xMax;
        int minY = storedData.m_shape.m_yMin;
        int maxY = storedData.m_shape.m_yMax;
        int minZ = storedData.m_shape.m_zMin;
        int maxZ = storedData.m_shape.m_zMax;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int worldX = this.field_145851_c + x;
                    int worldY = this.field_145848_d + y;
                    int worldZ = this.field_145849_e + z;
                    if (worldX != this.field_145851_c || worldY != this.field_145848_d || worldZ != this.field_145849_e) {
                        Block block = storedData.m_blocks[index];
                        if (block != null) {
                            int meta = storedData.m_metaData[index];
                            this.field_145850_b.func_147465_d(worldX, worldY, worldZ, block, meta, 2);
                        } else {
                            this.field_145850_b.func_147468_f(worldX, worldY, worldZ);
                        }
                    }
                    ++index;
                }
            }
        }
        Set<EntityItem> after = this.getEntityItemsInArea(storedData.m_shape);
        this.killNewItems(before, after);
        this.notifyEdgeBlocks(storedData.m_shape);
    }

    private boolean checkCooling() {
        for (int i = 0; i < 6; ++i) {
            int x = this.field_145851_c + Facing.field_71586_b[i];
            int y = this.field_145848_d + Facing.field_71587_c[i];
            int z = this.field_145849_e + Facing.field_71585_d[i];
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (block == null || block.func_149688_o() != Material.field_151588_w && block.func_149688_o() != Material.field_151598_x) continue;
            return true;
        }
        return false;
    }

    private TeleportError canTeleport() {
        AreaData twinData;
        TileEntityQuantumComputer twin = null;
        if (this.m_entanglementFrequency >= 0 && (twin = this.findEntangledTwin()) == null) {
            return TeleportError.NoTwin;
        }
        AreaShape localShape = this.calculateShape();
        if (localShape == null) {
            return TeleportError.FrameIncomplete;
        }
        if (twin != null) {
            AreaShape twinShape = twin.calculateShape();
            if (twinShape == null) {
                return TeleportError.DestinationFrameIncomplete;
            }
            if (!localShape.equals(twinShape)) {
                return TeleportError.FrameMismatch;
            }
        } else if (this.m_storedData != null && !localShape.equals(this.m_storedData.m_shape)) {
            return TeleportError.FrameMismatch;
        }
        if (!this.checkCooling()) {
            return TeleportError.InsufficientCooling;
        }
        AreaData localData = this.storeArea();
        if (localData == null) {
            return TeleportError.AreaNotTransportable;
        }
        if (twin != null && (twinData = twin.storeArea()) == null) {
            return TeleportError.DestinationNotTransportable;
        }
        return TeleportError.Ok;
    }

    private TeleportError tryTeleport() {
        TeleportError error = this.canTeleport();
        if (error == TeleportError.Ok) {
            if (this.m_entanglementFrequency >= 0) {
                TileEntityQuantumComputer twin = this.findEntangledTwin();
                if (twin != null) {
                    AreaData localData = this.storeArea();
                    AreaData twinData = twin.storeArea();
                    if (localData != null && twinData != null) {
                        this.unpackArea(twinData);
                        twin.unpackArea(localData);
                    }
                }
            } else {
                AreaData localData = this.storeArea();
                if (this.m_storedData != null) {
                    this.unpackArea(this.m_storedData);
                } else {
                    this.clearArea(localData.m_shape);
                }
                this.m_storedData = localData;
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
        }
        return error;
    }

    private void registerPortal() {
        PortalLocation location = this.findPortal();
        if (location != null) {
            if (this.m_portalID == null) {
                this.m_portalID = this.getPortalRegistry().getUnusedID();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.m_portalNameConflict = !this.getPortalRegistry().register(this.m_portalID, location);
            EntanglementSavedData.get(this.func_145831_w()).func_76185_a();
        }
        tooManyPossiblePortals = false;
    }

    private void unregisterPortal() {
        if (this.m_portalID != null) {
            if (!this.m_portalNameConflict) {
                this.getPortalRegistry().unregister(this.m_portalID);
                EntanglementSavedData.get(this.func_145831_w()).func_76185_a();
            }
            this.m_portalNameConflict = false;
        }
    }

    public void setPortalID(String id) {
        this.unregisterPortal();
        this.m_portalID = id;
        this.registerPortal();
    }

    public String getPortalID() {
        return this.m_portalID;
    }

    public void setRemoteServerAddress(String address) {
        this.m_remoteServerAddress = address;
        this.m_remoteServerName = this.getPortalRegistry().getServerName(address);
    }

    public String getRemoteServerAddress() {
        return this.m_remoteServerAddress;
    }

    public String getRemoteServerName() {
        return this.m_remoteServerName;
    }

    public void cycleRemoteServerAddress(String previousAddress) {
        this.m_remoteServerAddress = this.getPortalRegistry().getServerAddressAfter(previousAddress);
        this.m_remoteServerName = this.getPortalRegistry().getServerName(this.m_remoteServerAddress);
    }

    public void setRemotePortalID(String id) {
        this.m_remotePortalID = id;
    }

    public String getRemotePortalID() {
        return this.m_remotePortalID;
    }

    public boolean isTeleporter() {
        if (this.m_entanglementFrequency >= 0) {
            return false;
        }
        if (!QCraft.canAnybodyCreatePortals()) {
            return false;
        }
        PortalLocation location = this.getPortal();
        return location != null;
    }

    public boolean isTeleporterEnergized() {
        return this.canDeactivatePortal() == TeleportError.Ok;
    }

    private boolean isPortalCorner(int x, int y, int z, int dir) {
        if (y < 0 || y >= 256) {
            return false;
        }
        TileEntity entity = this.field_145850_b.func_147438_o(x, y, z);
        if (entity != null && entity instanceof TileEntityQBlock) {
            TileEntityQBlock quantum = (TileEntityQBlock)entity;
            int[] types = quantum.getTypes();
            for (int i = 0; i < 6; ++i) {
                if (!(i == dir || i == Facing.field_71588_a[dir] ? types[i] != 31 : types[i] != 21)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean portalExistsAt(PortalLocation location) {
        int c2;
        int c1;
        int lookDir;
        if (location.m_x1 == location.m_x2) {
            lookDir = 4;
            c1 = location.m_z1;
            c2 = location.m_z2;
        } else {
            lookDir = 2;
            c1 = location.m_x1;
            c2 = location.m_x2;
        }
        for (int y = Math.min(location.m_y1, location.m_y2) + 1; y < Math.max(location.m_y1, location.m_y2); ++y) {
            if (!this.isGlass(location.m_x1, y, location.m_z1)) {
                return false;
            }
            if (this.isGlass(location.m_x2, y, location.m_z2)) continue;
            return false;
        }
        for (int xz = Math.min(c1, c2) + 1; xz < Math.max(c1, c2); ++xz) {
            if (!this.isGlass(location.m_x1 == location.m_x2 ? location.m_x1 : xz, location.m_y1, location.m_z1 == location.m_z2 ? location.m_z1 : xz)) {
                return false;
            }
            if (this.isGlass(location.m_x1 == location.m_x2 ? location.m_x1 : xz, location.m_y2, location.m_z1 == location.m_z2 ? location.m_z1 : xz)) continue;
            return false;
        }
        if (!this.isPortalCorner(location.m_x1, location.m_y1, location.m_z1, lookDir)) {
            return false;
        }
        if (!this.isPortalCorner(location.m_x1, location.m_y2, location.m_z1, lookDir)) {
            return false;
        }
        if (!this.isPortalCorner(location.m_x2, location.m_y1, location.m_z2, lookDir)) {
            return false;
        }
        return this.isPortalCorner(location.m_x2, location.m_y2, location.m_z2, lookDir);
    }

    private PortalLocation getPortal() {
        if (this.m_portalID != null) {
            if (!this.m_portalNameConflict) {
                PortalLocation portal = this.getPortalRegistry().getPortal(this.m_portalID);
                if (portal != null) {
                    return portal;
                }
            } else {
                PortalLocation portal = this.findPortal();
                if (portal != null) {
                    return portal;
                }
            }
        }
        return null;
    }

    private ArrayList<PortalLocation> findPortalsAt(int x, int y, int z) {
        ArrayList<PortalLocation> returnValue = new ArrayList<PortalLocation>();
        ArrayList<int[]> possibleCornerPairs = new ArrayList<int[]>();
        if (this.isGlass(x, y, z)) {
            int x1 = 0;
            int y1 = 0;
            int z1 = 0;
            block0: for (int dir = 0; dir < 6; ++dir) {
                int[] temp;
                int i;
                int tempX = x;
                int tempY = y;
                int tempZ = z;
                for (i = 0; i < QCraft.maxPortalSize + 1 && this.isGlass(tempX += Facing.field_71586_b[dir], tempY += Facing.field_71587_c[dir], tempZ += Facing.field_71585_d[dir]); ++i) {
                }
                if (dir % 2 == 0) {
                    x1 = tempX;
                    y1 = tempY;
                    z1 = tempZ;
                    continue;
                }
                if (dir < 2) {
                    for (i = 0; i < 2; ++i) {
                        if (!this.isPortalCorner(tempX, tempY, tempZ, (i + 1) * 2) || !this.isPortalCorner(x1, y1, z1, (i + 1) * 2) || Math.abs(tempY - y1) >= QCraft.maxPortalSize + 2) continue;
                        temp = new int[]{tempX, tempY, tempZ, x1, y1, z1, (i + 1) * 2};
                        possibleCornerPairs.add(temp);
                        continue block0;
                    }
                    continue;
                }
                int perpenDir = (dir - 1) % 4 + 2;
                if (!this.isPortalCorner(tempX, tempY, tempZ, perpenDir) || !this.isPortalCorner(x1, y1, z1, perpenDir) || Math.abs(tempX - x1) >= QCraft.maxPortalSize + 2 || Math.abs(tempZ - z1) >= QCraft.maxPortalSize + 2) continue;
                temp = new int[]{tempX, tempY, tempZ, x1, y1, z1, perpenDir};
                possibleCornerPairs.add(temp);
            }
        } else {
            block3: for (int dir = 0; dir < 6; ++dir) {
                int[] temp;
                int i;
                if (this.isPortalCorner(x, y, z, dir)) continue;
                int tempX = x;
                int tempY = y;
                int tempZ = z;
                for (i = 0; i < QCraft.maxPortalSize + 1 && this.isGlass(tempX += Facing.field_71586_b[dir], tempY += Facing.field_71587_c[dir], tempZ += Facing.field_71585_d[dir]); ++i) {
                }
                if (dir < 2) {
                    for (i = 0; i < 2; ++i) {
                        if (!this.isPortalCorner(x, y, z, (i + 1) * 2) || !this.isPortalCorner(tempX, tempY, tempZ, (i + 1) * 2)) continue;
                        temp = new int[]{x, y, z, tempX, tempY, tempZ, (i + 1) * 2};
                        possibleCornerPairs.add(temp);
                        continue block3;
                    }
                    continue;
                }
                int perpenDir = (dir - 1) % 4 + 2;
                if (!this.isPortalCorner(tempX, tempY, tempZ, perpenDir)) continue;
                temp = new int[]{x, y, z, tempX, tempY, tempZ, perpenDir};
                possibleCornerPairs.add(temp);
            }
        }
        for (int[] i : possibleCornerPairs) {
            ArrayList<PortalLocation> temp = this.findRestOfPortal(i);
            if (temp == null) continue;
            for (PortalLocation location : temp) {
                returnValue.add(location);
            }
        }
        return returnValue;
    }

    private ArrayList<PortalLocation> findRestOfPortal(int[] cornerPair) {
        ArrayList<PortalLocation> returnValue = new ArrayList<PortalLocation>();
        int x1 = cornerPair[0];
        int y1 = cornerPair[1];
        int z1 = cornerPair[2];
        int x2 = cornerPair[3];
        int y2 = cornerPair[4];
        int z2 = cornerPair[5];
        int lookDir = cornerPair[6];
        int searchDir = (lookDir - lookDir % 2) % 4 + 2;
        if (Math.abs(y1 - y2) < 4 && Math.abs(x1 - x2) < 3 && Math.abs(z1 - z2) < 3) {
            return null;
        }
        if (y1 == y2) {
            for (int dir = 0; dir < 2; ++dir) {
                int c2;
                int c1;
                int tempY = y2;
                for (int i = 0; i < QCraft.maxPortalSize + 1 && this.isGlass(x1, tempY += Facing.field_71587_c[dir], z1) && this.isGlass(x2, tempY, z2); ++i) {
                }
                if (this.isGlass(x1, tempY, z1) || this.isGlass(x2, tempY, z2) || Math.abs(y1 - tempY) < 4 || !this.isPortalCorner(x1, tempY, z1, lookDir) || !this.isPortalCorner(x2, tempY, z2, lookDir)) continue;
                if (x1 == x2) {
                    c1 = z1;
                    c2 = z2;
                } else {
                    c1 = x1;
                    c2 = x2;
                }
                for (int i = Math.min(c1, c2) + 1; i < Math.max(c1, c2) && this.isGlass(x1 == x2 ? x1 : i, tempY, z1 == z2 ? z1 : i); ++i) {
                    if (i != Math.max(c1, c2) - 1) continue;
                    returnValue.add(new PortalLocation(x1, y1, z1, x2, tempY, z2, this.field_145850_b.field_73011_w.field_76574_g));
                }
            }
        } else {
            for (int dir = searchDir; dir < searchDir + 2; ++dir) {
                int i;
                int tempX = x2;
                int tempZ = z2;
                for (i = 0; i < QCraft.maxPortalSize + 1 && this.isGlass(tempX += Facing.field_71586_b[dir], y1, tempZ += Facing.field_71585_d[dir]) && this.isGlass(tempX, y2, tempZ); ++i) {
                }
                if (this.isGlass(tempX, y1, tempZ) || this.isGlass(tempX, y2, tempZ) || Math.abs(x1 - tempX) < 3 && Math.abs(z1 - tempZ) < 3 || !this.isPortalCorner(tempX, y1, tempZ, lookDir) || !this.isPortalCorner(tempX, y2, tempZ, lookDir)) continue;
                for (i = Math.min(y1, y2) + 1; i < Math.max(y1, y2) && this.isGlass(tempX, i, tempZ); ++i) {
                    if (i != Math.max(y1, y2) - 1) continue;
                    returnValue.add(new PortalLocation(x1, y1, z1, tempX, y2, tempZ, this.field_145850_b.field_73011_w.field_76574_g));
                }
            }
        }
        return returnValue;
    }

    private PortalLocation findPortal() {
        ArrayList<PortalLocation> portalLocations = new ArrayList<PortalLocation>();
        tooManyPossiblePortals = false;
        for (int dir = 0; dir < 6; ++dir) {
            int x = this.field_145851_c + Facing.field_71586_b[dir];
            int y = this.field_145848_d + Facing.field_71587_c[dir];
            int z = this.field_145849_e + Facing.field_71585_d[dir];
            if (!this.isGlass(x, y, z) && !this.isPortalCorner(x, y, z, 2) && !this.isPortalCorner(x, y, z, 4)) continue;
            ArrayList<PortalLocation> tempLocations = this.findPortalsAt(x, y, z);
            if (tempLocations.size() == 2 && !this.isPortalCorner(x, y, z, 2) && !this.isPortalCorner(x, y, z, 4) || tempLocations.size() > 2) {
                tooManyPossiblePortals = true;
                return null;
            }
            portalLocations.addAll(tempLocations);
            if (portalLocations.size() <= 2) continue;
            tooManyPossiblePortals = true;
            return null;
        }
        if (portalLocations.size() < 1) {
            return null;
        }
        if (portalLocations.size() == 2) {
            PortalLocation portal1 = (PortalLocation)portalLocations.get(0);
            PortalLocation portal2 = (PortalLocation)portalLocations.get(1);
            if (Math.min(portal1.m_x1, portal1.m_x2) == Math.min(portal2.m_x1, portal2.m_x2) && Math.min(portal1.m_y1, portal1.m_y2) == Math.min(portal2.m_y1, portal2.m_y2) && Math.min(portal1.m_z1, portal1.m_z2) == Math.min(portal2.m_z1, portal2.m_z2)) {
                return (PortalLocation)portalLocations.get(0);
            }
            tooManyPossiblePortals = true;
            return null;
        }
        if (portalLocations.size() > 2) {
            tooManyPossiblePortals = true;
            return null;
        }
        return (PortalLocation)portalLocations.get(0);
    }

    private boolean isPortalClear(PortalLocation portal) {
        for (int y = Math.min(portal.m_y1, portal.m_y2) + 1; y < Math.max(portal.m_y1, portal.m_y2); ++y) {
            for (int x = Math.min(portal.m_x1, portal.m_x2) + 1; x < Math.max(portal.m_x1, portal.m_x2); ++x) {
                if (this.field_145850_b.func_147437_c(x, y, portal.m_z1)) continue;
                return false;
            }
            for (int z = Math.min(portal.m_z1, portal.m_z2) + 1; z < Math.max(portal.m_z1, portal.m_z2); ++z) {
                if (this.field_145850_b.func_147437_c(portal.m_x1, y, z)) continue;
                return false;
            }
        }
        return true;
    }

    private void deployPortal(PortalLocation portal) {
        for (int y = Math.min(portal.m_y1, portal.m_y2) + 1; y < Math.max(portal.m_y1, portal.m_y2); ++y) {
            for (int x = Math.min(portal.m_x1, portal.m_x2) + 1; x < Math.max(portal.m_x1, portal.m_x2); ++x) {
                this.field_145850_b.func_147465_d(x, y, portal.m_z1, (Block)QCraft.Blocks.quantumPortal, 0, 2);
            }
            for (int z = Math.min(portal.m_z1, portal.m_z2) + 1; z < Math.max(portal.m_z1, portal.m_z2); ++z) {
                this.field_145850_b.func_147465_d(portal.m_x1, y, z, (Block)QCraft.Blocks.quantumPortal, 0, 2);
            }
        }
    }

    private void undeployPortal(PortalLocation portal) {
        for (int y = Math.min(portal.m_y1, portal.m_y2) + 1; y < Math.max(portal.m_y1, portal.m_y2); ++y) {
            for (int x = Math.min(portal.m_x1, portal.m_x2) + 1; x < Math.max(portal.m_x1, portal.m_x2); ++x) {
                this.field_145850_b.func_147468_f(x, y, portal.m_z1);
            }
            for (int z = Math.min(portal.m_z1, portal.m_z2) + 1; z < Math.max(portal.m_z1, portal.m_z2); ++z) {
                this.field_145850_b.func_147468_f(portal.m_x1, y, z);
            }
        }
    }

    private boolean isPortalDeployed(PortalLocation portal) {
        for (int y = Math.min(portal.m_y1, portal.m_y2) + 1; y < Math.max(portal.m_y1, portal.m_y2); ++y) {
            for (int x = Math.min(portal.m_x1, portal.m_x2) + 1; x < Math.max(portal.m_x1, portal.m_x2); ++x) {
                if (this.field_145850_b.func_147439_a(x, y, portal.m_z1) == QCraft.Blocks.quantumPortal) continue;
                return false;
            }
            for (int z = Math.min(portal.m_z1, portal.m_z2) + 1; z < Math.max(portal.m_z1, portal.m_z2); ++z) {
                if (this.field_145850_b.func_147439_a(portal.m_x1, y, z) == QCraft.Blocks.quantumPortal) continue;
                return false;
            }
        }
        return true;
    }

    private TeleportError canActivatePortal() {
        if (this.m_entanglementFrequency >= 0) {
            return TeleportError.FrameIncomplete;
        }
        if (!QCraft.canAnybodyCreatePortals()) {
            return TeleportError.FrameIncomplete;
        }
        tooManyPossiblePortals = false;
        PortalLocation location = this.getPortal();
        if (tooManyPossiblePortals) {
            tooManyPossiblePortals = false;
            return TeleportError.MultiplePossiblePortalsFound;
        }
        if (location == null) {
            return TeleportError.FrameIncomplete;
        }
        if (this.isPortalDeployed(location)) {
            return TeleportError.FrameDeployed;
        }
        if (this.m_portalNameConflict) {
            return TeleportError.NameConflict;
        }
        if (!this.isPortalClear(location)) {
            return TeleportError.FrameObstructed;
        }
        if (!this.checkCooling()) {
            return TeleportError.InsufficientCooling;
        }
        return TeleportError.Ok;
    }

    private TeleportError tryActivatePortal() {
        TeleportError error = this.canActivatePortal();
        if (error == TeleportError.Ok) {
            PortalLocation location = this.getPortal();
            if (location != null) {
                this.deployPortal(location);
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
        }
        return error;
    }

    public TeleportError canDeactivatePortal() {
        if (this.m_entanglementFrequency >= 0) {
            return TeleportError.FrameIncomplete;
        }
        PortalLocation location = this.getPortal();
        if (location == null) {
            return TeleportError.FrameIncomplete;
        }
        if (!this.isPortalDeployed(location)) {
            return TeleportError.FrameIncomplete;
        }
        return TeleportError.Ok;
    }

    private TeleportError tryDeactivatePortal() {
        TeleportError error = this.canDeactivatePortal();
        if (error == TeleportError.Ok) {
            PortalLocation location = this.getPortal();
            if (location != null) {
                this.undeployPortal(location);
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
        }
        return error;
    }

    public void setRedstonePowered(boolean powered) {
        if (this.m_powered != powered) {
            this.m_powered = powered;
            if (!this.field_145850_b.field_72995_K && this.m_powered && this.m_timeSinceEnergize >= 4) {
                this.tryEnergize();
            }
        }
    }

    public TeleportError canEnergize() {
        TeleportError error = this.canTeleport();
        if (error == TeleportError.Ok) {
            return error;
        }
        TeleportError serverError = this.canActivatePortal();
        if (serverError == TeleportError.Ok) {
            return serverError;
        }
        TeleportError deactivateError = this.canDeactivatePortal();
        if (deactivateError == TeleportError.Ok) {
            return deactivateError;
        }
        if (error.ordinal() >= serverError.ordinal()) {
            return error;
        }
        return serverError;
    }

    public TeleportError tryEnergize() {
        TeleportError error = this.tryTeleport();
        if (error == TeleportError.Ok) {
            this.m_timeSinceEnergize = 0;
            return error;
        }
        TeleportError serverError = this.tryActivatePortal();
        if (serverError == TeleportError.Ok) {
            this.m_timeSinceEnergize = 0;
            return serverError;
        }
        TeleportError deactivateError = this.tryDeactivatePortal();
        if (deactivateError == TeleportError.Ok) {
            return deactivateError;
        }
        if (error.ordinal() >= serverError.ordinal()) {
            return error;
        }
        return serverError;
    }

    public void func_145845_h() {
        ++this.m_timeSinceEnergize;
        if (!this.field_145850_b.field_72995_K) {
            PortalLocation location;
            if (this.m_portalNameConflict) {
                this.registerPortal();
            }
            if ((location = this.getPortal()) != null) {
                if (!this.portalExistsAt(location)) {
                    if (this.isPortalDeployed(location)) {
                        this.undeployPortal(location);
                    }
                    this.unregisterPortal();
                    location = null;
                } else if (!this.checkCooling() && this.isPortalDeployed(location)) {
                    this.undeployPortal(location);
                }
            } else {
                this.unregisterPortal();
                location = null;
            }
            if (location == null) {
                this.registerPortal();
                location = this.getPortal();
            }
            if (location != null && this.isPortalDeployed(location)) {
                int z2;
                int z1;
                int x1 = Math.min(location.m_x1, location.m_x2);
                int x2 = Math.max(location.m_x1, location.m_x2);
                int y1 = Math.min(location.m_y1, location.m_y2);
                int y2 = Math.max(location.m_y1, location.m_y2);
                AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)x1 + (x1 == x2 ? 0.25 : 1.0)), (double)((double)y1 + 1.0), (double)((double)(z1 = Math.min(location.m_z1, location.m_z2)) + (z1 == (z2 = Math.max(location.m_z1, location.m_z2)) ? 0.25 : 1.0)), (double)((double)x2 + (x1 == x2 ? 0.75 : 0.0)), (double)y2, (double)((double)z2 + (z1 == z2 ? 0.75 : 0.0)));
                List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, aabb);
                if (entities != null && entities.size() > 0) {
                    for (Object next : entities) {
                        if (next == null || !(next instanceof EntityPlayer)) continue;
                        EntityPlayer player = (EntityPlayer)next;
                        if (player.field_71088_bW > 0 || player.field_70173_aa < 200 || player.field_70154_o != null || player.field_70153_n != null) continue;
                        this.teleportPlayer(player);
                    }
                }
            }
        }
    }

    private void teleportPlayer(EntityPlayer player) {
        if (this.m_remoteServerAddress != null) {
            this.queryTeleportPlayerRemote(player);
        } else {
            TileEntityQuantumComputer.teleportPlayerLocal(player, this.m_remotePortalID);
        }
    }

    private void queryTeleportPlayerRemote(EntityPlayer player) {
        QCraft.requestQueryGoToServer(player, this);
        player.field_71088_bW = 50;
    }

    public void teleportPlayerRemote(EntityPlayer player, boolean takeItems) {
        TileEntityQuantumComputer.teleportPlayerRemote(player, this.m_remoteServerAddress, this.m_remotePortalID, takeItems);
    }

    public static void teleportPlayerRemote(EntityPlayer player, String remoteServerAddress, String remotePortalID, boolean takeItems) {
        QCraft.log("Sending player " + player.getDisplayName() + " to server \"" + remoteServerAddress + "\"");
        NBTTagCompound luggage = new NBTTagCompound();
        if (takeItems) {
            NBTTagList items = new NBTTagList();
            InventoryPlayer playerInventory = player.field_71071_by;
            for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
                ItemStack stack = playerInventory.func_70301_a(i);
                if (stack == null || stack.field_77994_a <= 0 || stack.func_77973_b() == Item.func_150898_a((Block)QCraft.Blocks.quantumComputer) && ItemQuantumComputer.getEntanglementFrequency(stack) >= 0 || stack.func_77973_b() == Item.func_150898_a((Block)QCraft.Blocks.qBlock) && ItemQBlock.getEntanglementFrequency(stack) >= 0) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                if (stack.func_77973_b() == QCraft.Items.missingItem) {
                    itemTag = stack.field_77990_d;
                } else {
                    GameRegistry.UniqueIdentifier uniqueId = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
                    String itemName = uniqueId.modId + ":" + uniqueId.name;
                    itemTag.func_74778_a("Name", itemName);
                    stack.func_77955_b(itemTag);
                }
                items.func_74742_a((NBTBase)itemTag);
                playerInventory.func_70299_a(i, null);
            }
            if (items.func_74745_c() > 0) {
                QCraft.log("Removed " + items.func_74745_c() + " items from " + player.getDisplayName() + "'s inventory.");
                playerInventory.func_70296_d();
                luggage.func_74782_a("items", (NBTBase)items);
            }
        }
        if (remotePortalID != null) {
            luggage.func_74778_a("destinationPortal", remotePortalID);
        }
        try {
            luggage.func_74778_a("uuid", UUID.randomUUID().toString());
            byte[] luggageData = CompressedStreamTools.func_74798_a((NBTTagCompound)luggage);
            byte[] luggageSignature = EncryptionRegistry.Instance.signData(luggageData);
            NBTTagCompound signedLuggage = new NBTTagCompound();
            signedLuggage.func_74773_a("key", EncryptionRegistry.Instance.encodePublicKey(EncryptionRegistry.Instance.getLocalKeyPair().getPublic()));
            signedLuggage.func_74773_a("luggage", luggageData);
            signedLuggage.func_74773_a("signature", luggageSignature);
            byte[] signedLuggageData = CompressedStreamTools.func_74798_a((NBTTagCompound)signedLuggage);
            QCraft.requestGoToServer(player, remoteServerAddress, signedLuggageData);
        }
        catch (IOException e) {
            throw new RuntimeException("Error encoding inventory");
        }
        finally {
            player.field_71088_bW = 200;
        }
    }

    public void teleportPlayerLocal(EntityPlayer player) {
        TileEntityQuantumComputer.teleportPlayerLocal(player, this.m_remotePortalID);
    }

    public static void teleportPlayerLocal(EntityPlayer player, String portalID) {
        PortalLocation location;
        PortalLocation portalLocation = location = portalID != null ? PortalRegistry.PortalRegistry.getPortal(portalID) : null;
        if (location != null) {
            double xPos = ((double)location.m_x1 + (double)location.m_x2 + 1.0) / 2.0;
            double yPos = (double)Math.min(location.m_y1, location.m_y2) + 1.0;
            double zPos = ((double)location.m_z1 + (double)location.m_z2 + 1.0) / 2.0;
            if (location.m_dimensionID == player.field_71093_bK) {
                player.field_71088_bW = 40;
                player.func_70634_a(xPos, yPos, zPos);
            } else if (player instanceof EntityPlayerMP) {
                player.field_71088_bW = 40;
                MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension((EntityPlayerMP)player, location.m_dimensionID, (Teleporter)new QuantumTeleporter(MinecraftServer.func_71276_C().func_71218_a(location.m_dimensionID), xPos, yPos, zPos));
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.m_powered = nbttagcompound.func_74767_n("p");
        this.m_timeSinceEnergize = nbttagcompound.func_74762_e("tse");
        this.m_entanglementFrequency = nbttagcompound.func_74762_e("f");
        if (nbttagcompound.func_74764_b("d")) {
            this.m_storedData = AreaData.decode(nbttagcompound.func_74775_l("d"));
        }
        if (nbttagcompound.func_74764_b("portalID")) {
            this.m_portalID = nbttagcompound.func_74779_i("portalID");
        }
        this.m_portalNameConflict = nbttagcompound.func_74767_n("portalNameConflict");
        if (nbttagcompound.func_74764_b("remoteIPAddress")) {
            this.m_remoteServerAddress = nbttagcompound.func_74779_i("remoteIPAddress");
        }
        this.m_remoteServerName = nbttagcompound.func_74764_b("remoteIPName") ? nbttagcompound.func_74779_i("remoteIPName") : this.m_remoteServerAddress;
        if (nbttagcompound.func_74764_b("remotePortalID")) {
            this.m_remotePortalID = nbttagcompound.func_74779_i("remotePortalID");
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("p", this.m_powered);
        nbttagcompound.func_74768_a("tse", this.m_timeSinceEnergize);
        nbttagcompound.func_74768_a("f", this.m_entanglementFrequency);
        if (this.m_storedData != null) {
            nbttagcompound.func_74782_a("d", (NBTBase)this.m_storedData.encode());
        }
        if (this.m_portalID != null) {
            nbttagcompound.func_74778_a("portalID", this.m_portalID);
        }
        nbttagcompound.func_74757_a("portalNameConflict", this.m_portalNameConflict);
        if (this.m_remoteServerAddress != null) {
            nbttagcompound.func_74778_a("remoteIPAddress", this.m_remoteServerAddress);
        }
        if (this.m_remoteServerName != null) {
            nbttagcompound.func_74778_a("remoteIPName", this.m_remoteServerName);
        }
        if (this.m_remotePortalID != null) {
            nbttagcompound.func_74778_a("remotePortalID", this.m_remotePortalID);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("f", this.m_entanglementFrequency);
        if (this.m_portalID != null) {
            nbttagcompound.func_74778_a("portalID", this.m_portalID);
        }
        nbttagcompound.func_74757_a("portalNameConflict", this.m_portalNameConflict);
        if (this.m_remoteServerAddress != null) {
            nbttagcompound.func_74778_a("remoteIPAddress", this.m_remoteServerAddress);
        }
        if (this.m_remoteServerName != null) {
            nbttagcompound.func_74778_a("remoteIPName", this.m_remoteServerName);
        }
        if (this.m_remotePortalID != null) {
            nbttagcompound.func_74778_a("remotePortalID", this.m_remotePortalID);
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        switch (packet.func_148853_f()) {
            case 0: {
                NBTTagCompound nbttagcompound = packet.func_148857_g();
                this.setEntanglementFrequency(nbttagcompound.func_74762_e("f"));
                this.m_portalID = nbttagcompound.func_74764_b("portalID") ? nbttagcompound.func_74779_i("portalID") : null;
                this.m_portalNameConflict = nbttagcompound.func_74767_n("portalNameConflict");
                this.m_remoteServerAddress = nbttagcompound.func_74764_b("remoteIPAddress") ? nbttagcompound.func_74779_i("remoteIPAddress") : null;
                this.m_remoteServerName = nbttagcompound.func_74764_b("remoteIPName") ? nbttagcompound.func_74779_i("remoteIPName") : null;
                if (nbttagcompound.func_74764_b("remotePortalID")) {
                    this.m_remotePortalID = nbttagcompound.func_74779_i("remotePortalID");
                    break;
                }
                this.m_remotePortalID = null;
                break;
            }
        }
    }

    public static class PortalLocation {
        public int m_dimensionID;
        public int m_x1;
        public int m_x2;
        public int m_y1;
        public int m_y2;
        public int m_z1;
        public int m_z2;

        private PortalLocation(int x1, int y1, int z1, int x2, int y2, int z2, int id) {
            this.m_dimensionID = id;
            this.m_x1 = x1;
            this.m_x2 = x2;
            this.m_y1 = y1;
            this.m_y2 = y2;
            this.m_z1 = z1;
            this.m_z2 = z2;
        }

        public NBTTagCompound encode() {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("dimensionID", this.m_dimensionID);
            nbttagcompound.func_74768_a("x1", this.m_x1);
            nbttagcompound.func_74768_a("y1", this.m_y1);
            nbttagcompound.func_74768_a("z1", this.m_z1);
            nbttagcompound.func_74768_a("x2", this.m_x2);
            nbttagcompound.func_74768_a("y2", this.m_y2);
            nbttagcompound.func_74768_a("z2", this.m_z2);
            return nbttagcompound;
        }

        public static PortalLocation decode(NBTTagCompound nbttagcompound) {
            int dimID = nbttagcompound.func_74764_b("dimensionID") ? nbttagcompound.func_74762_e("dimensionID") : 0;
            int x1 = nbttagcompound.func_74762_e("x1");
            int y1 = nbttagcompound.func_74762_e("y1");
            int z1 = nbttagcompound.func_74762_e("z1");
            int x2 = nbttagcompound.func_74762_e("x2");
            int y2 = nbttagcompound.func_74762_e("y2");
            int z2 = nbttagcompound.func_74762_e("z2");
            return new PortalLocation(x1, y1, z1, x2, y2, z2, dimID);
        }
    }

    public static enum TeleportError {
        Ok,
        NoTwin,
        FrameIncomplete,
        DestinationFrameIncomplete,
        FrameMismatch,
        FrameObstructed,
        InsufficientCooling,
        AreaNotTransportable,
        DestinationNotTransportable,
        FrameDeployed,
        NameConflict,
        MultiplePossiblePortalsFound;


        public static String decode(TeleportError error) {
            if (error != Ok) {
                return "gui.qcraft:computer.error_" + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, error.toString());
            }
            return null;
        }
    }

    public static class AreaData {
        public AreaShape m_shape;
        public Block[] m_blocks;
        public int[] m_metaData;

        public NBTTagCompound encode() {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("xmin", this.m_shape.m_xMin);
            nbttagcompound.func_74768_a("xmax", this.m_shape.m_xMax);
            nbttagcompound.func_74768_a("ymin", this.m_shape.m_yMin);
            nbttagcompound.func_74768_a("ymax", this.m_shape.m_yMax);
            nbttagcompound.func_74768_a("zmin", this.m_shape.m_zMin);
            nbttagcompound.func_74768_a("zmax", this.m_shape.m_zMax);
            NBTTagList blockNames = new NBTTagList();
            for (int i = 0; i < this.m_blocks.length; ++i) {
                String name = null;
                Block block = this.m_blocks[i];
                if (block != null) {
                    name = Block.field_149771_c.func_148750_c((Object)block);
                }
                if (name != null && name.length() > 0) {
                    blockNames.func_74742_a((NBTBase)new NBTTagString(name));
                    continue;
                }
                blockNames.func_74742_a((NBTBase)new NBTTagString("null"));
            }
            nbttagcompound.func_74782_a("blockNames", (NBTBase)blockNames);
            nbttagcompound.func_74783_a("metaData", this.m_metaData);
            return nbttagcompound;
        }

        public static AreaData decode(NBTTagCompound nbttagcompound) {
            AreaData storedData = new AreaData();
            storedData.m_shape = new AreaShape();
            storedData.m_shape.m_xMin = nbttagcompound.func_74762_e("xmin");
            storedData.m_shape.m_xMax = nbttagcompound.func_74762_e("xmax");
            storedData.m_shape.m_yMin = nbttagcompound.func_74762_e("ymin");
            storedData.m_shape.m_yMax = nbttagcompound.func_74762_e("ymax");
            storedData.m_shape.m_zMin = nbttagcompound.func_74762_e("zmin");
            storedData.m_shape.m_zMax = nbttagcompound.func_74762_e("zmax");
            int size = (storedData.m_shape.m_xMax - storedData.m_shape.m_xMin + 1) * (storedData.m_shape.m_yMax - storedData.m_shape.m_yMin + 1) * (storedData.m_shape.m_zMax - storedData.m_shape.m_zMin + 1);
            storedData.m_blocks = new Block[size];
            if (nbttagcompound.func_74764_b("blockData")) {
                int[] blockIDs = nbttagcompound.func_74759_k("blockData");
                for (int i = 0; i < size; ++i) {
                    storedData.m_blocks[i] = Block.func_149729_e((int)blockIDs[i]);
                }
            } else {
                NBTTagList blockNames = nbttagcompound.func_150295_c("blockNames", 8);
                for (int i = 0; i < size; ++i) {
                    String name = blockNames.func_150307_f(i);
                    if (name.length() <= 0 || name.equals("null")) continue;
                    storedData.m_blocks[i] = Block.func_149684_b((String)name);
                }
            }
            storedData.m_metaData = nbttagcompound.func_74759_k("metaData");
            return storedData;
        }
    }

    public static class AreaShape {
        public int m_xMin;
        public int m_xMax;
        public int m_yMin;
        public int m_yMax;
        public int m_zMin;
        public int m_zMax;

        public boolean equals(AreaShape o) {
            return o.m_xMin == this.m_xMin && o.m_xMax == this.m_xMax && o.m_yMin == this.m_yMin && o.m_yMax == this.m_yMax && o.m_zMin == this.m_zMin && o.m_zMax == this.m_zMax;
        }
    }
}

