/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.data;

import com.xcompwiz.mystcraft.api.grammar.GrammarData;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.util.CollectionUtils;
import java.util.ArrayList;

public class SymbolRules {
    public static void initialize() {
        SymbolRules.addRule("ModNorth", SymbolRules.buildRule(1, "AngleBasic", "ModNorth"));
        SymbolRules.addRule("ModSouth", SymbolRules.buildRule(1, "AngleBasic", "ModSouth"));
        SymbolRules.addRule("ModEast", SymbolRules.buildRule(1, "AngleBasic", "ModEast"));
        SymbolRules.addRule("ModWest", SymbolRules.buildRule(1, "AngleBasic", "ModWest"));
        SymbolRules.addRule("ModRising", SymbolRules.buildRule(1, "PhaseBasic", "ModRising"));
        SymbolRules.addRule("ModNoon", SymbolRules.buildRule(1, "PhaseBasic", "ModNoon"));
        SymbolRules.addRule("ModSetting", SymbolRules.buildRule(1, "PhaseBasic", "ModSetting"));
        SymbolRules.addRule("ModEnd", SymbolRules.buildRule(1, "PhaseBasic", "ModEnd"));
        SymbolRules.addRule("ModZero", SymbolRules.buildRule(2, "PeriodBasic", "ModZero"));
        SymbolRules.addRule("ModHalf", SymbolRules.buildRule(1, "PeriodBasic", "ModHalf"));
        SymbolRules.addRule("ModFull", SymbolRules.buildRule(1, "PeriodBasic", "ModFull"));
        SymbolRules.addRule("ModDouble", SymbolRules.buildRule(1, "PeriodBasic", "ModDouble"));
        SymbolRules.addRule("ModGradient", SymbolRules.buildRule(1, "GradientBasic", "Color", "Period", "ModGradient"));
        SymbolRules.addRule("ColorHorizon", SymbolRules.buildRule(2, "Sunset", "Sunset_Ext", "Gradient", "ColorHorizon"));
        SymbolRules.addRule("NoSea", SymbolRules.buildRule(2, GrammarData.BLOCK_SEA, "NoSea"));
        SymbolRules.addRule("WeatherOff", SymbolRules.buildRule(2, "Weather", "WeatherOff"));
        SymbolRules.addRule("WeatherStorm", SymbolRules.buildRule(2, "Weather", "WeatherStorm"));
        SymbolRules.addRule("WeatherSnow", SymbolRules.buildRule(2, "Weather", "WeatherSnow"));
        SymbolRules.addRule("WeatherRain", SymbolRules.buildRule(2, "Weather", "WeatherRain"));
        SymbolRules.addRule("WeatherCloudy", SymbolRules.buildRule(2, "Weather", "WeatherCloudy"));
        SymbolRules.addRule("WeatherOn", SymbolRules.buildRule(2, "Weather", "WeatherOn"));
        SymbolRules.addRule("WeatherSlow", SymbolRules.buildRule(2, "Weather", "WeatherSlow"));
        SymbolRules.addRule("WeatherNorm", SymbolRules.buildRule(1, "Weather", "WeatherNorm"));
        SymbolRules.addRule("WeatherFast", SymbolRules.buildRule(2, "Weather", "WeatherFast"));
        SymbolRules.addRule("TerrainVoid", SymbolRules.buildRule(3, "TerrainGen", "TerrainVoid"));
        SymbolRules.addRule("TerrainNormal", SymbolRules.buildRule(1, "TerrainGen", GrammarData.BLOCK_TERRAIN, GrammarData.BLOCK_SEA, "TerrainNormal"));
        SymbolRules.addRule("TerrainAmplified", SymbolRules.buildRule(3, "TerrainGen", GrammarData.BLOCK_TERRAIN, GrammarData.BLOCK_SEA, "TerrainAmplified"));
        SymbolRules.addRule("TerrainNether", SymbolRules.buildRule(3, "TerrainGen", GrammarData.BLOCK_TERRAIN, GrammarData.BLOCK_SEA, "TerrainNether"));
        SymbolRules.addRule("TerrainFlat", SymbolRules.buildRule(2, "TerrainGen", GrammarData.BLOCK_TERRAIN, GrammarData.BLOCK_SEA, "TerrainFlat"));
        SymbolRules.addRule("TerrainEnd", SymbolRules.buildRule(3, "TerrainGen", GrammarData.BLOCK_TERRAIN, GrammarData.BLOCK_SEA, "TerrainEnd"));
        SymbolRules.addRule("LightingNormal", SymbolRules.buildRule(1, "Lighting", "LightingNormal"));
        SymbolRules.addRule("LightingDark", SymbolRules.buildRule(2, "Lighting", "LightingDark"));
        SymbolRules.addRule("LightingBright", SymbolRules.buildRule(2, "Lighting", "LightingBright"));
        SymbolRules.addRule("ColorFog", SymbolRules.buildRule(3, "Visual", "Gradient", "ColorFog"));
        SymbolRules.addRule("ColorSkyNight", SymbolRules.buildRule(3, "Visual", "Gradient", "ColorSkyNight"));
        SymbolRules.addRule("ColorSky", SymbolRules.buildRule(3, "Visual", "Gradient", "ColorSky"));
        SymbolRules.addRule("ColorCloud", SymbolRules.buildRule(3, "Visual", "Gradient", "ColorCloud"));
        SymbolRules.addRule("ColorGrass", SymbolRules.buildRule(3, "Visual", "Color", "ColorGrass"));
        SymbolRules.addRule("ColorFoliage", SymbolRules.buildRule(3, "Visual", "Color", "ColorFoliage"));
        SymbolRules.addRule("ColorWater", SymbolRules.buildRule(3, "Visual", "Color", "ColorWater"));
        SymbolRules.addRule("ColorFogNat", SymbolRules.buildRule(2, "Visual", "ColorFogNat"));
        SymbolRules.addRule("ColorSkyNat", SymbolRules.buildRule(2, "Visual", "ColorSkyNat"));
        SymbolRules.addRule("ColorCloudNat", SymbolRules.buildRule(2, "Visual", "ColorCloudNat"));
        SymbolRules.addRule("ColorGrassNat", SymbolRules.buildRule(2, "Visual", "ColorGrassNat"));
        SymbolRules.addRule("ColorFoliageNat", SymbolRules.buildRule(2, "Visual", "ColorFoliageNat"));
        SymbolRules.addRule("ColorWaterNat", SymbolRules.buildRule(2, "Visual", "ColorWaterNat"));
        SymbolRules.addRule("NoHorizon", SymbolRules.buildRule(2, "Visual", "NoHorizon"));
        SymbolRules.addRule("Rainbow", SymbolRules.buildRule(4, "Visual", "Angle", "Rainbow"));
        SymbolRules.addRule("EnvScorch", SymbolRules.buildRule(null, "Effect", "EnvScorch"));
        SymbolRules.addRule("EnvMeteor", SymbolRules.buildRule(null, "Effect", "EnvMeteor"));
        SymbolRules.addRule("EnvLightning", SymbolRules.buildRule(null, "Effect", "Gradient", "EnvLightning"));
        SymbolRules.addRule("EnvExplosions", SymbolRules.buildRule(null, "Effect", "EnvExplosions"));
        SymbolRules.addRule("EnvAccel", SymbolRules.buildRule(null, "Effect", "EnvAccel"));
        SymbolRules.addRule("StarsEndSky", SymbolRules.buildRule(4, "Starfield", "Gradient", "StarsEndSky"));
        SymbolRules.addRule("StarsNormal", SymbolRules.buildRule(1, "Starfield", "Gradient", "Period", "Angle", "StarsNormal"));
        SymbolRules.addRule("StarsTwinkle", SymbolRules.buildRule(2, "Starfield", "Gradient", "Period", "Angle", "StarsTwinkle"));
        SymbolRules.addRule("StarsDark", SymbolRules.buildRule(3, "Starfield", "StarsDark"));
        SymbolRules.addRule("SunNormal", SymbolRules.buildRule(1, "Sun", "Sunset", "Period", "Angle", "Phase", "SunNormal"));
        SymbolRules.addRule("SunDark", SymbolRules.buildRule(3, "Sun", "SunDark"));
        SymbolRules.addRule("MoonNormal", SymbolRules.buildRule(1, "Moon", "SunsetUncommon", "Period", "Angle", "Phase", "MoonNormal"));
        SymbolRules.addRule("MoonDark", SymbolRules.buildRule(3, "Moon", "MoonDark"));
        SymbolRules.addRule("BioConNative", SymbolRules.buildRule(1, "BiomeController", "BioConNative"));
        SymbolRules.addRule("BioConSingle", SymbolRules.buildRule(1, "BiomeController", "Biome", "BioConSingle"));
        SymbolRules.addRule("BioConTiled", SymbolRules.buildRule(2, "BiomeController", "Biomes", "Biome", "BioConTiled"));
        SymbolRules.addRule("BioConGrid", SymbolRules.buildRule(2, "BiomeController", "Biomes", "Biome", "BioConGrid"));
        SymbolRules.addRule("BioConTiny", SymbolRules.buildRule(2, "BiomeController", "Biomes", "Biome", "Biome", "BioConTiny"));
        SymbolRules.addRule("BioConSmall", SymbolRules.buildRule(2, "BiomeController", "Biomes", "Biome", "Biome", "BioConSmall"));
        SymbolRules.addRule("BioConMedium", SymbolRules.buildRule(1, "BiomeController", "Biomes", "Biome", "Biome", "BioConMedium"));
        SymbolRules.addRule("BioConLarge", SymbolRules.buildRule(2, "BiomeController", "Biomes", "Biome", "Biome", "BioConLarge"));
        SymbolRules.addRule("BioConHuge", SymbolRules.buildRule(2, "BiomeController", "Biomes", "Biome", "Biome", "BioConHuge"));
        SymbolRules.addRule("FloatIslands", SymbolRules.buildRule(4, "FeatureLarge", "Biome", GrammarData.BLOCK_STRUCTURE, "FloatIslands"));
        SymbolRules.addRule("Tendrils", SymbolRules.buildRule(4, "FeatureLarge", GrammarData.BLOCK_STRUCTURE, "Tendrils"));
        SymbolRules.addRule("Skylands", SymbolRules.buildRule(5, "FeatureLarge", "Skylands"));
        SymbolRules.addRule("Caves", SymbolRules.buildRule(1, "FeatureLarge", "Caves"));
        SymbolRules.addRule("DenseOres", SymbolRules.buildRule(null, "FeatureLarge", "DenseOres"));
        SymbolRules.addRule("HugeTrees", SymbolRules.buildRule(2, "FeatureLarge", "HugeTrees"));
        SymbolRules.addRule("NetherFort", SymbolRules.buildRule(2, "FeatureMedium", "NetherFort"));
        SymbolRules.addRule("Villages", SymbolRules.buildRule(1, "FeatureMedium", "Villages"));
        SymbolRules.addRule("Strongholds", SymbolRules.buildRule(1, "FeatureMedium", "Strongholds"));
        SymbolRules.addRule("Mineshafts", SymbolRules.buildRule(1, "FeatureMedium", "Mineshafts"));
        SymbolRules.addRule("Ravines", SymbolRules.buildRule(1, "FeatureMedium", "Ravines"));
        SymbolRules.addRule("TerModSpheres", SymbolRules.buildRule(3, "FeatureMedium", GrammarData.BLOCK_STRUCTURE, "TerModSpheres"));
        SymbolRules.addRule("Dungeons", SymbolRules.buildRule(2, "FeatureMedium", "Dungeons"));
        SymbolRules.addRule("GenSpikes", SymbolRules.buildRule(3, "FeatureMedium", GrammarData.BLOCK_STRUCTURE, "GenSpikes"));
        SymbolRules.addRule("StarFissure", SymbolRules.buildRule(3, "FeatureSmall", "StarFissure"));
        SymbolRules.addRule("Obelisks", SymbolRules.buildRule(3, "FeatureSmall", GrammarData.BLOCK_STRUCTURE, "Obelisks"));
        SymbolRules.addRule("LakesSurface", SymbolRules.buildRule(1, "FeatureSmall", GrammarData.BLOCK_FLUID, "LakesSurface"));
        SymbolRules.addRule("LakesDeep", SymbolRules.buildRule(1, "FeatureSmall", "BLOCK_NONSOLID", "LakesDeep"));
        SymbolRules.addRule("CryForm", SymbolRules.buildRule(3, "FeatureSmall", GrammarData.BLOCK_CRYSTAL, "CryForm"));
        SymbolRules.addRule("FeatureLargeDummy", SymbolRules.buildRule(5, "FeatureLarges0", "FeatureLargeExt", "FeatureLargeDummy"));
        SymbolRules.addRule("FeatureMediumDummy", SymbolRules.buildRule(5, "FeatureMediums0", "FeatureMediumExt", "FeatureMediumDummy"));
        SymbolRules.addRule("FeatureSmallDummy", SymbolRules.buildRule(null, "FeatureSmalls0", "FeatureSmallExt", "FeatureSmallDummy"));
        SymbolRules.addRule("FeatureLargeDummy", SymbolRules.buildRule(null, "FeatureLargeExt", "FeatureLargeDummy"));
        SymbolRules.addRule("FeatureMediumDummy", SymbolRules.buildRule(null, "FeatureMediumExt", "FeatureMediumDummy"));
        SymbolRules.addRule("FeatureSmallDummy", SymbolRules.buildRule(null, "FeatureSmallExt", "FeatureSmallDummy"));
    }

    private static void addRule(String string, GrammarGenerator.Rule rule) {
        IAgeSymbol symbol2 = SymbolManager.getAgeSymbol(string);
        if (string == null) {
            LoggerUtils.info("Failed to add rule to symbol " + string, new Object[0]);
            return;
        }
        if (symbol2 instanceof SymbolBase) {
            ((SymbolBase)symbol2).addRule(rule);
        }
    }

    private static GrammarGenerator.Rule buildRule(Integer rank, String parent, String ... args) {
        ArrayList<String> list = CollectionUtils.buildList(args);
        return new GrammarGenerator.Rule(parent, list, rank);
    }
}

