/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.debug;

import com.xcompwiz.mystcraft.debug.DebugHierarchy;
import com.xcompwiz.mystcraft.world.agedata.AgeData;

public class DebugUtils {
    public static DebugHierarchy.DebugNode getDebugNodeForAge(AgeData age) {
        DebugHierarchy.DebugNode current = DebugHierarchy.root;
        current = current.getOrCreateNode("ages");
        current = current.getOrCreateNode(age.field_76190_i);
        return current;
    }

    public static DebugHierarchy.IDebugElement getElement(String address) {
        int i;
        if (address == null) {
            return null;
        }
        String[] array = address.split("\\.");
        DebugHierarchy.DebugNode current = DebugHierarchy.root;
        for (i = 0; i < array.length - 1; ++i) {
            DebugHierarchy.IDebugElement next = current.get(array[i]);
            if (next == null) {
                return null;
            }
            if (!(next instanceof DebugHierarchy.DebugNode)) {
                throw new RuntimeException(String.format("Cannot expand debug element to address %s as a non-node type lies in the address (@%s).", address, array[i]));
            }
            current = (DebugHierarchy.DebugNode)next;
        }
        if (array.length <= i) {
            return current;
        }
        return current.get(array[i]);
    }

    public static void register(String address, DebugHierarchy.IDebugElement elem) {
        int i;
        if (elem instanceof DebugHierarchy.DebugNode) {
            throw new RuntimeException("Cannot register nodes as children. Use DebugNode.createNode instead.");
        }
        String[] array = address.split("\\.");
        DebugHierarchy.DebugNode current = DebugHierarchy.root;
        for (i = 0; i < array.length - 1; ++i) {
            DebugHierarchy.IDebugElement next = current.get(array[i]);
            if (next == null) {
                next = current.getOrCreateNode(array[i]);
            }
            if (!(next instanceof DebugHierarchy.DebugNode)) {
                throw new RuntimeException(String.format("Cannot add debug element to address %s as a non-node type lies in the address (@%s).", address, array[i]));
            }
            current = (DebugHierarchy.DebugNode)next;
        }
        current.addChild(array[i], elem);
    }
}

