/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.grammar;

import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.utility.WeightedItemSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class GrammarTree {
    private GrammarNode root;
    private List<GrammarNode> unexplored = new LinkedList<GrammarNode>();
    private List<GrammarNode> subroots = new ArrayList<GrammarNode>();
    private List<String> terminals;

    public GrammarTree(String root) {
        this.root = new GrammarNode(root);
    }

    public void parseTerminals(List<String> terminals, Random rand) {
        this.terminals = Collections.unmodifiableList(terminals);
        for (int i = terminals.size(); i > 0; --i) {
            String terminal = terminals.get(i - 1);
            this.buildSubtree(new GrammarNode(terminal, i - 1), rand);
        }
    }

    public List<String> getExpanded(Random rand) {
        ArrayList<String> out = new ArrayList<String>();
        if (this.terminals != null) {
            for (String str : this.terminals) {
                out.add(str);
            }
        }
        this.unexplored.clear();
        if (this.root.selected == null) {
            this.unexplored.add(this.root);
        }
        for (int i = 0; i < this.unexplored.size(); ++i) {
            List<GrammarGenerator.Rule> rules = GrammarGenerator.getAllRules(this.unexplored.get((int)i).token);
            if (rules == null || rules.size() != 1) continue;
            this.expandUnexploredNode(i--, rules.get(0));
        }
        ArrayList<GrammarNode> failedsubs = new ArrayList<GrammarNode>();
        while (this.subroots.size() > 0) {
            if (this.unexplored.size() == 0) {
                failedsubs.addAll(this.subroots);
                break;
            }
            GrammarNode subroot = this.subroots.remove(0);
            if (this.connectSubtreeShortest(subroot, rand)) continue;
            failedsubs.add(subroot);
        }
        this.subroots = failedsubs;
        HashMap<Integer, List<String>> insertLeft = new HashMap<Integer, List<String>>();
        HashMap<Integer, List<String>> insertRight = new HashMap<Integer, List<String>>();
        this.getInsertions(insertLeft, insertRight);
        List<String> products = null;
        for (int i = out.size() + 1; i > 0; --i) {
            int j;
            products = insertRight.get(i - 1);
            if (products != null) {
                for (j = products.size(); j > 0; --j) {
                    out.addAll(i, GrammarGenerator.explore(products.get(j - 1), rand));
                }
            }
            if ((products = insertLeft.get(i - 1)) == null) continue;
            for (j = products.size(); j > 0; --j) {
                out.addAll(i - 1, GrammarGenerator.explore(products.get(j - 1), rand));
            }
        }
        this.unexplored.clear();
        return out;
    }

    private void getInsertions(GrammarNode node, HashMap<Integer, List<String>> insertLeft, HashMap<Integer, List<String>> insertRight) {
        for (GrammarNode child : node.children) {
            this.getInsertions(child, insertLeft, insertRight);
        }
        if (node.children.size() == 0 && node.selected == null && !node.isTerminal) {
            Integer left = node.getLeftPosition();
            if (left == null) {
                Integer right = node.getRightPosition();
                if (right == null) {
                    left = this.terminals.size();
                } else {
                    this.getOrCreateList(right, insertRight).add(node.token);
                }
            }
            if (left != null) {
                this.getOrCreateList(left, insertLeft).add(node.token);
            }
        }
    }

    private void getInsertions(HashMap<Integer, List<String>> left, HashMap<Integer, List<String>> right) {
        this.getInsertions(this.root, left, right);
    }

    private List<String> getOrCreateList(Integer key, HashMap<Integer, List<String>> map) {
        List<String> rules = map.get(key);
        if (rules == null) {
            rules = new ArrayList<String>();
            map.put(key, rules);
        }
        return rules;
    }

    private void printNode(GrammarNode node, String prefix) {
        System.out.println(prefix + node.token + (node.selected != null ? ":" : "") + (node.isTerminal ? "*" : "") + "-" + (node.getLeftPosition() == null ? "?" : node.getLeftPosition()) + "|" + (node.getRightPosition() == null ? "?" : node.getRightPosition()));
        for (GrammarNode child : node.children) {
            this.printNode(child, prefix + "  ");
        }
    }

    public void print() {
        this.printNode(this.root, ">");
        System.out.println(String.format("With %d subtrees", this.subroots.size()));
        for (GrammarNode subroot : this.subroots) {
            this.printNode(subroot, "  >");
        }
    }

    private void buildSubtree(GrammarNode subroot, Random rand) {
        for (GrammarNode node : this.unexplored) {
            List<GrammarGenerator.Rule> path = this.getShortestPath(subroot, node, rand);
            if (path == null) continue;
            for (GrammarGenerator.Rule rule : path) {
                subroot = this.reverseExpand(subroot, rule);
            }
            this.replaceNodeWithTree(node, subroot);
            return;
        }
        List<GrammarGenerator.Rule> rules = GrammarGenerator.getParentRules(subroot.token);
        while (rules != null && rules.size() == 1 && !rules.get(0).getParent().equals(this.root.token)) {
            subroot = this.reverseExpand(subroot, rules.get(0));
            rules = GrammarGenerator.getParentRules(subroot.token);
        }
        this.subroots.add(subroot);
        this.addUnexploredNodes(subroot);
    }

    private List<GrammarGenerator.Rule> getShortestPath(GrammarNode subroot, GrammarNode node, Random rand) {
        List<List<GrammarGenerator.Rule>> paths = GrammarGenerator.getShortestPaths(subroot.token, node.token);
        if (paths == null || paths.size() == 0) {
            return null;
        }
        return WeightedItemSelector.getRandomItem(rand, paths);
    }

    private boolean connectSubtreeRandomly(GrammarNode subroot, Random rand) {
        List<GrammarGenerator.Rule> rules = GrammarGenerator.getParentRules(subroot.token);
        if (rules == null || rules.size() == 0) {
            return false;
        }
        for (GrammarNode node : this.unexplored) {
            if (node.token.equals(subroot.token)) {
                this.replaceNodeWithTree(node, subroot);
                return true;
            }
            ArrayList<GrammarGenerator.Rule> options = new ArrayList<GrammarGenerator.Rule>();
            for (GrammarGenerator.Rule rule : rules) {
                if (!node.token.equals(rule.getParent())) continue;
                options.add(rule);
            }
            if (options.size() <= 0 || !(WeightedItemSelector.getTotalWeight(options) > 0.0f)) continue;
            subroot = this.reverseExpand(subroot, (GrammarGenerator.Rule)WeightedItemSelector.getRandomItem(rand, options));
            this.replaceNodeWithTree(node, subroot);
            return true;
        }
        HashMap<GrammarNode, GrammarNode> connections = new HashMap<GrammarNode, GrammarNode>();
        for (GrammarGenerator.Rule rule : rules) {
            if (this.checkForLoop(rule.getParent(), subroot)) continue;
            this.producePaths(connections, this.reverseExpand(subroot.clone(), rule), rand);
        }
        if (connections.size() == 0) {
            return false;
        }
        int selected = rand.nextInt(connections.size());
        for (Map.Entry pair : connections.entrySet()) {
            if (selected == 0) {
                this.replaceNodeWithTree((GrammarNode)pair.getValue(), (GrammarNode)pair.getKey());
                break;
            }
            --selected;
        }
        return true;
    }

    private boolean connectSubtreeShortest(GrammarNode subroot, Random rand) {
        List<GrammarGenerator.Rule> rules = GrammarGenerator.getParentRules(subroot.token);
        if (rules == null || rules.size() == 0) {
            return false;
        }
        for (GrammarNode node : this.unexplored) {
            if (node.token.equals(subroot.token)) {
                this.replaceNodeWithTree(node, subroot);
                return true;
            }
            ArrayList<GrammarGenerator.Rule> options = new ArrayList<GrammarGenerator.Rule>();
            for (GrammarGenerator.Rule rule : rules) {
                if (!node.token.equals(rule.getParent())) continue;
                options.add(rule);
            }
            if (options.size() > 0 && WeightedItemSelector.getTotalWeight(options) > 0.0f) {
                subroot = this.reverseExpand(subroot, (GrammarGenerator.Rule)WeightedItemSelector.getRandomItem(rand, options));
                this.replaceNodeWithTree(node, subroot);
                return true;
            }
            List<GrammarGenerator.Rule> path = this.getShortestPath(subroot, node, rand);
            if (path == null) continue;
            for (GrammarGenerator.Rule rule : path) {
                subroot = this.reverseExpand(subroot, rule);
            }
            this.replaceNodeWithTree(node, subroot);
            return true;
        }
        return false;
    }

    private boolean checkForLoop(String parent, GrammarNode subroot) {
        LinkedList<GrammarNode> nodes = new LinkedList<GrammarNode>();
        nodes.add(subroot);
        while (nodes.size() > 0) {
            GrammarNode node = (GrammarNode)nodes.remove(0);
            if (node.token.equals(parent)) {
                return true;
            }
            nodes.addAll(node.children);
        }
        return false;
    }

    private void producePaths(HashMap<GrammarNode, GrammarNode> connections, GrammarNode subroot, Random rand) {
        List<GrammarGenerator.Rule> rules = GrammarGenerator.getParentRules(subroot.token);
        if (rules == null || rules.size() == 0) {
            return;
        }
        for (GrammarNode node : this.unexplored) {
            ArrayList<GrammarGenerator.Rule> options = new ArrayList<GrammarGenerator.Rule>();
            for (GrammarGenerator.Rule rule : rules) {
                if (!node.token.equals(rule.getParent())) continue;
                options.add(rule);
            }
            if (options.size() <= 0 || !(WeightedItemSelector.getTotalWeight(options) > 0.0f)) continue;
            subroot = this.reverseExpand(subroot, (GrammarGenerator.Rule)WeightedItemSelector.getRandomItem(rand, options));
            connections.put(subroot, node);
            return;
        }
        for (GrammarGenerator.Rule rule : rules) {
            if (this.checkForLoop(rule.getParent(), subroot)) continue;
            this.producePaths(connections, this.reverseExpand(subroot.clone(), rule), rand);
        }
    }

    private void replaceNodeWithTree(GrammarNode node, GrammarNode subroot) {
        this.unexplored.remove(node);
        node.selected = subroot.selected;
        node.children = subroot.children;
        for (GrammarNode child : node.children) {
            child.parent = node;
        }
        node.leftPos = null;
        node.rightPos = null;
        this.addUnexploredNodes(node);
    }

    private void addUnexploredNodes(GrammarNode subroot) {
        LinkedList<GrammarNode> nodes = new LinkedList<GrammarNode>();
        nodes.add(subroot);
        while (nodes.size() > 0) {
            GrammarNode node = (GrammarNode)nodes.remove(0);
            for (GrammarNode child : node.children) {
                if (child.selected != null) {
                    nodes.add(child);
                    continue;
                }
                if (child.isTerminal) continue;
                this.unexplored.add(0, child);
            }
        }
    }

    private void expandUnexploredNode(int index, GrammarGenerator.Rule rule) {
        GrammarNode node = this.unexplored.remove(index);
        node.selected = rule;
        List<String> products = rule.getValues();
        for (int i = products.size(); i > 0; --i) {
            String product = products.get(i - 1);
            GrammarNode newnode = new GrammarNode(product);
            node.addChild(0, newnode);
            this.unexplored.add(index, newnode);
        }
    }

    private GrammarNode reverseExpand(GrammarNode subroot, GrammarGenerator.Rule rule) {
        GrammarNode newroot = new GrammarNode(rule.getParent());
        newroot.selected = rule;
        List<String> products = rule.getValues();
        for (int i = products.size(); i > 0; --i) {
            String product = products.get(i - 1);
            if (subroot != null && product.equals(subroot.token)) {
                newroot.addChild(0, subroot);
                subroot = null;
                continue;
            }
            newroot.addChild(0, new GrammarNode(product));
        }
        return newroot;
    }

    private static class GrammarNode {
        public final String token;
        public final boolean isTerminal;
        public GrammarGenerator.Rule selected = null;
        private GrammarNode parent;
        private List<GrammarNode> children = new ArrayList<GrammarNode>();
        private Integer leftPos;
        private Integer rightPos;

        public GrammarNode(String token) {
            this.token = token;
            this.leftPos = null;
            this.rightPos = null;
            this.isTerminal = false;
        }

        public GrammarNode(String token, int pos) {
            this.token = token;
            this.leftPos = pos;
            this.rightPos = pos;
            this.isTerminal = true;
        }

        public Integer getLeftPosition() {
            int i;
            if (this.leftPos != null) {
                return this.leftPos;
            }
            for (i = 0; i < this.children.size(); ++i) {
                Integer pos = this.children.get(i).getLeftPosition();
                if (pos == null || this.leftPos != null && this.leftPos <= pos) continue;
                this.leftPos = pos;
            }
            if (this.leftPos != null) {
                return this.leftPos;
            }
            if (this.parent != null) {
                for (i = 0; i < this.parent.children.size(); ++i) {
                    if (!this.parent.children.get(i).equals(this)) continue;
                    if (this.parent.children.size() <= i + 1) break;
                    this.leftPos = this.parent.children.get(i + 1).getLeftPosition();
                    break;
                }
            }
            return this.leftPos;
        }

        public Integer getRightPosition() {
            int i;
            if (this.rightPos != null) {
                return this.rightPos;
            }
            for (i = 0; i < this.children.size(); ++i) {
                Integer pos = this.children.get(i).getRightPosition();
                if (pos == null || this.rightPos != null && this.rightPos >= pos) continue;
                this.rightPos = pos;
            }
            if (this.rightPos != null) {
                return this.rightPos;
            }
            if (this.parent != null) {
                for (i = this.parent.children.size() - 1; i >= 0; --i) {
                    if (this.parent.children.get(i).equals(this)) {
                        if (i <= 0) continue;
                        this.rightPos = this.parent.children.get(--i).getRightPosition();
                        continue;
                    }
                    if (this.rightPos == null || this.parent.children.get(i).getRightPosition() == null || this.rightPos >= this.parent.children.get(i).getRightPosition()) continue;
                    this.rightPos = this.parent.children.get(i).getRightPosition();
                }
            }
            return this.rightPos;
        }

        private void addChild(GrammarNode child) {
            this.children.add(child);
            child.parent = this;
        }

        private void addChild(int index, GrammarNode child) {
            this.children.add(index, child);
            child.parent = this;
        }

        public GrammarNode clone() {
            LinkedList<NodePair> todo = new LinkedList<NodePair>();
            GrammarNode clone = this.flatClone(this);
            todo.add(new NodePair(this, clone));
            while (todo.size() > 0) {
                NodePair current = (NodePair)todo.remove(0);
                for (GrammarNode child : current.original.children) {
                    GrammarNode childclone = this.flatClone(child);
                    current.clone.addChild(childclone);
                    todo.add(new NodePair(child, childclone));
                }
            }
            return clone;
        }

        private GrammarNode flatClone(GrammarNode grammarNode) {
            GrammarNode clone = null;
            clone = grammarNode.isTerminal ? new GrammarNode(grammarNode.token, grammarNode.leftPos) : new GrammarNode(grammarNode.token);
            clone.leftPos = grammarNode.leftPos;
            clone.rightPos = grammarNode.rightPos;
            clone.selected = grammarNode.selected;
            return clone;
        }

        public String toString() {
            return String.format("%s%s (%d)", this.token, (this.selected != null ? ":" : "") + (this.isTerminal ? "*" : ""), this.children.size());
        }

        private static class NodePair {
            public GrammarNode original;
            public GrammarNode clone;

            public NodePair(GrammarNode o, GrammarNode c) {
                this.original = o;
                this.clone = c;
            }
        }
    }
}

