/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.seasonal;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.word.DrawableWord;
import com.xcompwiz.mystcraft.words.DrawableWordManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class SeasonalManager {
    public static final ResourceLocation egg_components = new ResourceLocation("mystcraft:textures/eastercomponents.png");
    private static boolean isEaster;
    private static boolean isEasterOverride;
    private static Calendar checkedDate;

    @SideOnly(value=Side.CLIENT)
    public static boolean drawSymbol(TextureManager renderEngine, float zLevel, IAgeSymbol symbol2, float scale, float x, float y) {
        if (!SeasonalManager.isEaster()) {
            return false;
        }
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (symbol2 == null) {
            SeasonalManager.drawEggColors(renderEngine, zLevel, null, scale, x, y, -16777216, new Random());
            return true;
        }
        SeasonalManager.drawEggColors(renderEngine, zLevel, null, scale, x, y, -16777216, SeasonalManager.getRandom(symbol2.identifier()));
        String[] words = symbol2.getPoem();
        if (words == null) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (words.length <= i) continue;
            SeasonalManager.drawEggColors(renderEngine, zLevel, "easter_" + words[i], scale, x, y, -637534208, SeasonalManager.getRandom(words[i]));
        }
        GL11.glDisable((int)3042);
        return true;
    }

    private static Random getRandom(String string) {
        if (string != null) {
            return new Random(string.hashCode());
        }
        return new Random();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawEggColors(TextureManager renderEngine, float zLevel, String string, float scale, float x, float y, int alpha, Random rand) {
        DrawableWord word = DrawableWordManager.getDrawableWord(string);
        ArrayList<Integer> components = null;
        ArrayList<Integer> colors = null;
        ResourceLocation imagesource = egg_components;
        if (word != null) {
            components = word.components();
            colors = word.colors();
        }
        renderEngine.func_110577_a(imagesource);
        if (components == null) {
            components = new ArrayList();
        }
        if (components.size() == 0) {
            components.add(0);
        }
        if (colors == null) {
            colors = new ArrayList();
        }
        for (int c = 0; c < components.size(); ++c) {
            int color = 0;
            if (c < colors.size()) {
                color = colors.get(c);
            } else {
                color = rand.nextInt(155) + 100 << 16 | rand.nextInt(155) + 100 << 8 | rand.nextInt(155) + 100;
                colors.add(color);
            }
            SeasonalManager.drawComponent(scale, zLevel, components.get(c), color | alpha, x, y);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawComponent(float drawscale, float zLevel, int iconIndex, int color, float x, float y) {
        int iconSize = 64;
        int imgSize = 512;
        float transform = 0.001953125f;
        int iconX = iconIndex % 8 * 64;
        int iconY = iconIndex / 8 * 64;
        float fAlpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float fRed = (float)(color >> 16 & 0xFF) / 255.0f;
        float fGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        float fBlue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)fRed, (float)fGreen, (float)fBlue, (float)fAlpha);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + drawscale), (double)zLevel, (double)((float)(iconX + 0) * 0.001953125f), (double)((float)(iconY + 64) * 0.001953125f));
        tessellator.func_78374_a((double)(x + drawscale), (double)(y + drawscale), (double)zLevel, (double)((float)(iconX + 64) * 0.001953125f), (double)((float)(iconY + 64) * 0.001953125f));
        tessellator.func_78374_a((double)(x + drawscale), (double)(y + 0.0f), (double)zLevel, (double)((float)(iconX + 64) * 0.001953125f), (double)((float)(iconY + 0) * 0.001953125f));
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel, (double)((float)(iconX + 0) * 0.001953125f), (double)((float)(iconY + 0) * 0.001953125f));
        tessellator.func_78381_a();
    }

    private static boolean isEaster() {
        SeasonalManager.checkDateFlags();
        return isEasterOverride || isEaster;
    }

    private static void checkDateFlags() {
        if (checkedDate != null) {
            return;
        }
        GregorianCalendar now = new GregorianCalendar();
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        if (now.equals(checkedDate)) {
            return;
        }
        checkedDate = now;
        isEaster = now.equals(SeasonalManager.findEasterDate(now.get(1)));
    }

    public static final Calendar findEasterDate(int year) {
        int n;
        if (year <= 1582) {
            throw new IllegalArgumentException("Algorithm invalid before April 1583");
        }
        int golden = year % 19 + 1;
        int century = year / 100 + 1;
        int x = 3 * century / 4 - 12;
        int z = (8 * century + 5) / 25 - 5;
        int d = 5 * year / 4 - x - 10;
        int epact = (11 * golden + 20 + z - x) % 30;
        if (epact == 25 && golden > 11 || epact == 24) {
            ++epact;
        }
        n += 30 * ((n = 44 - epact) < 21 ? 1 : 0);
        if ((n += 7 - (d + n) % 7) > 31) {
            return new GregorianCalendar(year, 3, n - 31);
        }
        return new GregorianCalendar(year, 2, n);
    }
}

